/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.publish.PublishEvent;
import com.pageseeder.publish.PublishScheduleHandler;
import com.pageseeder.publish.PublishSchedulerThread;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class PublishScheduler {
    private static final PublishScheduler INSTANCE = new PublishScheduler();
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishScheduler.class);
    private PublishSchedulerThread thread = null;
    private final List<PublishEvent> events = new ArrayList<PublishEvent>();

    public static PublishScheduler getInstance() {
        return INSTANCE;
    }

    private PublishScheduler() {
        this.thread = new PublishSchedulerThread(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addSchedule(String project, File scheduleFile) {
        FileInputStream in = null;
        Iterator<PublishEvent> loaded = null;
        try {
            LOGGER.debug("Adding schedule {} with project {} ", (Object)scheduleFile, (Object)project);
            in = new FileInputStream(scheduleFile);
            PublishScheduleHandler handler = new PublishScheduleHandler(project);
            XMLHelpers.parse((InputStream)in, (ContentHandler)handler);
            loaded = handler.getEvents();
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to parse publish scheduler file {}", (Object)scheduleFile.getAbsolutePath(), (Object)ex);
            IOUtils.closeQuietly((InputStream)in);
            return;
        }
        catch (IOException ex2) {
            LOGGER.error("Failed to load publish scheduler file {}", (Object)scheduleFile.getAbsolutePath(), (Object)ex2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            return;
        }
        IOUtils.closeQuietly((InputStream)in);
        if (!loaded.hasNext()) {
            LOGGER.debug("No events found");
        }
        while (loaded.hasNext()) {
            PublishEvent event = loaded.next();
            if (event.getDescription() == null) {
                LOGGER.error("Invalid event has no description");
                continue;
            }
            this.events.add(event);
            LOGGER.debug("Found new event {}", (Object)event.getDescription());
        }
    }

    public Collection<PublishEvent> getEvents() {
        return this.events;
    }

    public Runnable getThread() {
        return this.thread;
    }

    public void setEventStatus(String eventID, String status) {
        if (eventID == null) {
            return;
        }
        for (PublishEvent event : this.events) {
            if (!eventID.equals(event.getProcessID())) continue;
            event.setLastStatus(status);
            break;
        }
    }

    public static void reloadAllEvents(File webInf) {
        PublishScheduler.INSTANCE.events.clear();
        File templateDirs = new File(webInf, "config" + File.separator + "template");
        if (templateDirs.exists() && templateDirs.isDirectory()) {
            for (File templateDir : templateDirs.listFiles()) {
                File scheduleFile;
                if (!templateDir.isDirectory() || !(scheduleFile = new File(templateDir, "publish/schedule-config.xml")).exists()) continue;
                String project = templateDir.getName();
                if (project.indexOf(46) != -1) {
                    project = project.substring(0, project.indexOf(46));
                }
                INSTANCE.addSchedule(project, scheduleFile);
            }
        }
    }
}

