/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.publish.PublishEvent;
import java.time.OffsetDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class PublishScheduleHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishScheduleHandler.class);
    private static final String ELEMENT_EVENT = "event";
    private static final String ELEMENT_START = "start";
    private static final String ATTRIBUTE_DATETIME = "datetime";
    private static final String ELEMENT_REPEAT = "repeat";
    private static final String ATTRIBUTE_DAYS = "days";
    private static final String ATTRIBUTE_MINUTES = "minutes";
    private static final String ATTRIBUTE_HOURS = "hours";
    private static final String ATTRIBUTE_UNTIL = "until";
    private static final String ATTRIBUTE_DAYSOFWEEK = "daysofweek";
    private static final String ELEMENT_TARGET = "target";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_USERNAME = "username";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_PARAM = "param";
    private static final String ATTRIBUTE_VALUE = "value";
    private final String project;
    private final List<PublishEvent> events = new ArrayList<PublishEvent>();
    private PublishEvent currentEvent = null;
    private final StringBuffer buffer = new StringBuffer();

    public PublishScheduleHandler(String proj) {
        this.project = proj;
    }

    public Iterator<PublishEvent> getEvents() {
        return this.events.iterator();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.buffer.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (ELEMENT_EVENT.equals(localName)) {
            try {
                this.events.add(this.currentEvent.completeInitialisation());
            }
            catch (IllegalStateException ex) {
                LOGGER.error("Failed to add scheduled publish event: {}", (Object)ex.getMessage());
            }
            this.currentEvent = null;
        } else if (this.isDescriptionTagName(localName)) {
            this.currentEvent.setDescription(this.buffer.toString());
        }
    }

    @Override
    public void startElement(String uri, String localName, String qname, Attributes attributes) throws SAXException {
        if (this.isEventTagName(localName)) {
            this.currentEvent = new PublishEvent(this.project);
        } else if (this.isTargetTagName(localName)) {
            this.currentEvent.setTarget(attributes.getValue(ATTRIBUTE_NAME));
            this.currentEvent.setUsername(attributes.getValue(ATTRIBUTE_USERNAME));
        } else {
            if (this.isStartTagName(localName)) {
                String date = attributes.getValue(ATTRIBUTE_DATETIME);
                if (date == null) {
                    throw new SAXException("Missing attribute datetime in element start.");
                }
                try {
                    this.currentEvent.setStartDate(Date.from(OffsetDateTime.parse(date).toInstant()));
                }
                catch (DateTimeParseException e) {
                    throw new SAXException("Invalid format for start date: " + date + ".");
                }
            }
            if (this.isRepeatTagName(localName)) {
                PublishEvent.Repeat repeat;
                int delay;
                String days = attributes.getValue(ATTRIBUTE_DAYS);
                String hours = attributes.getValue(ATTRIBUTE_HOURS);
                String minutes = attributes.getValue(ATTRIBUTE_MINUTES);
                if (days != null) {
                    try {
                        delay = Integer.parseInt(days);
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("Invalid number of days: " + days + ".");
                    }
                    repeat = PublishEvent.Repeat.DAYS;
                } else if (hours != null) {
                    try {
                        delay = Integer.parseInt(hours);
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("Invalid number of hours: " + hours + ".");
                    }
                    repeat = PublishEvent.Repeat.HOURS;
                } else if (minutes != null) {
                    try {
                        delay = Integer.parseInt(minutes);
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("Invalid number of minutes: " + minutes + ".");
                    }
                    repeat = PublishEvent.Repeat.MINUTES;
                } else {
                    throw new SAXException("One of days, hours or minutes is needed in element repeat.");
                }
                this.currentEvent.setRepeat(delay, repeat);
                String until = attributes.getValue(ATTRIBUTE_UNTIL);
                if (until != null) {
                    try {
                        this.currentEvent.setEndDate(Date.from(OffsetDateTime.parse(until).toInstant()));
                    }
                    catch (DateTimeParseException ex) {
                        LOGGER.error("Format error for attribute {} in element {}, value is {}", new Object[]{ATTRIBUTE_UNTIL, ELEMENT_REPEAT, until});
                    }
                }
                this.currentEvent.setDaysOfWeek(attributes.getValue(ATTRIBUTE_DAYSOFWEEK));
            } else if (this.isParamTagName(localName)) {
                String name = attributes.getValue(ATTRIBUTE_NAME);
                if (name == null) {
                    throw new SAXException("Attribute name is required for element param");
                }
                String value = attributes.getValue(ATTRIBUTE_VALUE);
                if (value == null) {
                    throw new SAXException("Attribute value is required for element param");
                }
                this.currentEvent.addParameter(name, value);
            }
        }
        this.buffer.setLength(0);
    }

    public boolean isEventTagName(String name) {
        return ELEMENT_EVENT.equals(name) && this.currentEvent == null;
    }

    public boolean isStartTagName(String name) {
        return ELEMENT_START.equals(name) && this.currentEvent != null;
    }

    public boolean isRepeatTagName(String name) {
        return ELEMENT_REPEAT.equals(name) && this.currentEvent != null;
    }

    public boolean isTargetTagName(String name) {
        return ELEMENT_TARGET.equals(name) && this.currentEvent != null;
    }

    public boolean isDescriptionTagName(String name) {
        return ELEMENT_DESCRIPTION.equals(name) && this.currentEvent != null;
    }

    public boolean isParamTagName(String name) {
        return ELEMENT_PARAM.equals(name) && this.currentEvent != null;
    }
}

