/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.publish.PublishJobDetails;
import com.pageseeder.publish.PublishJobs;
import com.pageseeder.publish.PublishLogMessage;
import com.pageseeder.publish.PublishLogger;
import com.pageseeder.publish.PublishScheduler;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class PublishResponseHandler
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(PublishResponseHandler.class);
    private UniversalPrinter out = null;
    private XMLStringWriter xml = null;
    private static SAXParserFactory factory;
    private XMLStringWriter messageContent = null;
    private final StringBuilder ch = new StringBuilder();
    private final Stack<String> elements = new Stack();
    private final Stack<PublishLogMessage> messages = new Stack();
    private PublishLogMessage currentMessage = null;
    private final Map<String, PublishJobDetails> jobs = new HashMap<String, PublishJobDetails>();
    private String uriPath = null;
    private String pubId = null;
    private String groupId = null;
    private String groupName = null;
    private String username = null;
    private long started = -1L;
    private boolean logMessage = false;
    private final PublishLogger _logger;
    private final String processID;

    public PublishResponseHandler(PublishLogger logger, String jobID) {
        this._logger = logger;
        this.processID = jobID;
    }

    public Stack<PublishLogMessage> getMessages() {
        return this.messages;
    }

    public String parse(String response) throws IOException, SAXException {
        this.xml = new XMLStringWriter(XML.NamespaceAware.No);
        this.out = new UniversalPrinter((OutputPrinter)new XMLOutputPrinter((XMLWriter)this.xml));
        this.parseResponse(response);
        return this.xml.toString();
    }

    public void parse(String response, UniversalPrinter output) throws IOException, SAXException {
        this.xml = null;
        this.out = output;
        this.parseResponse(response);
    }

    private void parseResponse(String response) throws IOException, SAXException {
        try {
            if (factory == null) {
                PublishResponseHandler.initFactory();
            }
            XMLReader reader = factory.newSAXParser().getXMLReader();
            this.messages.clear();
            reader.setContentHandler(this);
            reader.parse(new InputSource(new StringReader(response)));
            for (PublishLogMessage msg : this.messages) {
                String jobid = msg.getJobid();
                if (jobid == null || "".equals(jobid)) {
                    if (this.processID == null || !"error".equals(msg.getEventType()) || !"This publishing action is not currently running.".equals(msg.getContent())) continue;
                    PublishJobs.removeJob(jobid);
                    continue;
                }
                if ("in-progress".equals(msg.getEventType())) continue;
                if ("error".equals(msg.getEventType())) {
                    this._logger.error(msg);
                    continue;
                }
                if ("warn".equals(msg.getEventType())) {
                    this._logger.warn(msg);
                    continue;
                }
                this._logger.info(msg);
            }
            for (PublishJobDetails job : this.jobs.values()) {
                PublishJobs.synchroniseJob(job);
                if (!job.isCompleted()) continue;
                PublishScheduler.getInstance().setEventStatus(job.id(), job.getStatus());
            }
        }
        catch (SAXException ex) {
            LOGGER.error("PublishControl.response: {}", (Object)response);
            throw new SAXException(response);
        }
        catch (ParserConfigurationException ex) {
            LOGGER.error("Failed to create XML Reader.", (Throwable)ex);
            throw new SAXException("Failed to create XML Reader.", ex);
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        int i;
        this.out.startObject(localName);
        for (i = 0; i < atts.getLength(); ++i) {
            this.out.field(atts.getLocalName(i), atts.getValue(i));
        }
        if ("check".equals(localName)) {
            this.out.field("date", ISO8601.DATETIME.format(System.currentTimeMillis()));
        }
        if (this.messageContent != null) {
            String jobAsXML;
            this.messageContent.openElement(uri, localName, true);
            for (i = 0; i < atts.getLength(); ++i) {
                this.messageContent.attribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
            }
            if ("other-job".equals(localName) && (jobAsXML = PublishJobs.getJobAsXML(atts.getValue("id"))) != null) {
                if (this.xml != null) {
                    this.xml.writeXML(jobAsXML);
                } else {
                    this.out.field("xml", jobAsXML);
                }
            }
        } else {
            this.ch.setLength(0);
            if ("publish".equals(localName)) {
                this.pubId = atts.getValue("id");
            } else if ("message".equals(localName)) {
                this.logMessage = !"true".equals(atts.getValue("logged"));
                this.currentMessage = new PublishLogMessage(atts.getValue("type"), atts.getValue("target"), this.pubId, this.groupId, this.groupName);
                this.currentMessage.setURIPath(this.uriPath);
                this.currentMessage.setStarted(this.started);
                this.currentMessage.setUser(this.username);
                this.currentMessage.setProgress(atts.getValue("progress"));
                this.messageContent = new XMLStringWriter(XML.NamespaceAware.Yes);
            } else if ("param".equals(localName) && "parameters".equals(this.elements.peek())) {
                String name = atts.getValue("name");
                String value = atts.getValue("value");
                if ("ps-uriPath".equals(name)) {
                    this.uriPath = value;
                } else if ("ps-username".equals(name)) {
                    this.username = value;
                } else if ("ps-started".equals(name)) {
                    try {
                        this.started = Long.parseLong(value);
                    }
                    catch (NumberFormatException ex) {
                        LOGGER.warn("Failed to load start time for {}: {}", (Object)this.processID, (Object)value);
                    }
                } else if ("ps-groupId".equals(name)) {
                    this.groupId = value;
                } else if ("ps-groupName".equals(name)) {
                    this.groupName = value;
                }
            }
        }
        this.elements.push(localName);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.out.endObject();
        this.elements.pop();
        if (!"message".equals(localName) && this.messageContent != null) {
            this.messageContent.closeElement();
            return;
        }
        if ("publish".equals(localName)) {
            this.pubId = null;
        } else if ("message".equals(localName) && this.currentMessage != null) {
            this.currentMessage.setContent(this.messageContent.toString().trim());
            if (this.currentMessage.getContent().length() > 0 || this.currentMessage.getProgress() != null) {
                PublishJobDetails job;
                if (this.logMessage) {
                    this.messages.push(this.currentMessage);
                }
                if ((job = this.jobs.get(this.pubId)) != null) {
                    job.setCurrentMessage(this.currentMessage.getContent());
                }
            }
            this.messageContent = null;
            this.logMessage = false;
            this.currentMessage = null;
        } else if ("stacktrace".equals(localName) && this.currentMessage != null) {
            this.currentMessage.setStacktrace(this.ch.toString().trim());
        } else if ("status".equals(localName) && this.currentMessage == null && this.pubId != null) {
            PublishJobDetails job = new PublishJobDetails(this.pubId, this.started, this.uriPath, this.username, this.groupName);
            job.setCurrentStatus(this.ch.toString().trim());
            this.jobs.put(this.pubId, job);
        }
        this.ch.setLength(0);
    }

    @Override
    public void characters(char[] buf, int pos, int len) {
        this.out.field("value", new String(buf, pos, len), OutputPrinter.FieldOption.XML_TEXT);
        if (this.messageContent != null) {
            this.messageContent.writeText(new String(buf, pos, len));
        } else {
            this.ch.append(buf, pos, len);
        }
    }

    private static void initFactory() throws ParserConfigurationException, SAXException {
        SAXParserFactory f = XMLHelpers.safeSAXParserFactory();
        f.setValidating(false);
        f.setNamespaceAware(true);
        try {
            f.setFeature("http://xml.org/sax/features/validation", false);
            f.setFeature("http://xml.org/sax/features/namespaces", true);
            f.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (ParserConfigurationException | SAXException exception) {
            // empty catch block
        }
        factory = f;
    }
}

