/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publish;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentConfigHandler;
import com.pageseeder.base.document.PSMLFiles;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.url.URLConfig;
import com.pageseeder.base.url.URLFiles;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true)
public final class GetPublishConfig
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        boolean allUris = "none".equals(req.getParameter((Parameter)StandardParameters.uri));
        long uriid = req.getParameter((Parameter)StandardParameters.uri, -1L);
        URI uri = null;
        if (uriid == -1L && !allUris) {
            uri = req.getURI();
        } else if (!allUris) {
            uri = DatabaseQuery.getURIById((Database)req.getDatabase(), (Long)uriid);
        }
        Group group = req.getGroup();
        Member member = req.getMember();
        if (group == null) {
            return new ForbiddenCheck();
        }
        if (uri != null && member != null) {
            return new ViewMemberCheck(member, (PermissionCheck)new ViewURICheck(uri));
        }
        if (uri != null) {
            return new ViewURICheck(uri);
        }
        if (member != null) {
            return new ViewMemberCheck(member, (PermissionCheck)new ViewGroupCheck(group));
        }
        return new ViewGroupCheck(group);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Role role;
        Database db = req.getDatabase();
        boolean allUris = "none".equals(req.getParameter((Parameter)StandardParameters.uri));
        long uriid = req.getParameter((Parameter)StandardParameters.uri, -1L);
        URI uri = null;
        if (uriid < 0L && !allUris) {
            uri = req.getURI();
        } else if (!allUris) {
            uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
        }
        String actiontypes = req.getParameter((Parameter)StandardParameters.type);
        String sourcetypes = req.getParameter((Parameter)StandardParameters.source);
        Group group = req.getGroup();
        String template = GroupRule.getTemplate((Group)group);
        if (template == null) {
            template = GlobalSettings.getGlobalTemplate();
        }
        if (template == null) {
            template = "default";
        }
        boolean manager_in_project = false;
        if (req.getMember() != null) {
            UserDetailsManager user_manager = new UserDetailsManager();
            UserDetails userdetails = user_manager.get(db, req.getMember().getId());
            role = MemberRule.isApproverForGroup((UserDetails)userdetails, (String)group.getName()) ? Role.APPROVER : (MemberRule.isManagerForGroup((UserDetails)userdetails, (String)group.getName()) ? Role.MANAGER : (MemberRule.isContributorForGroup((UserDetails)userdetails, (String)group.getName()) ? Role.CONTRIBUTOR : Role.REVIEWER));
            manager_in_project = MemberRule.isManagerForProject((Map)userdetails.flags(), (String)template);
        } else {
            role = Role.REVIEWER;
        }
        ArrayList<String> configFiles = new ArrayList<String>();
        try {
            if (uri != null) {
                if (sourcetypes == null) {
                    sourcetypes = "folder".equals(uri.getType()) ? "folder" : (URIs.isExternal((URI)uri) ? "url" : "document");
                }
                this.loadURIConfig(configFiles, template, actiontypes, sourcetypes, uri, role);
            } else if (allUris) {
                this.loadAllURIsConfig(configFiles, template, actiontypes, sourcetypes == null ? "folder,document" : sourcetypes, role);
            } else {
                configFiles.add(PSMLFiles.findGroupPublishConfig((String)template, (String)actiontypes, (String)(sourcetypes == null ? "group" : sourcetypes), null, null, (Role)role, null));
            }
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
            return;
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("publish-config");
        xml.attribute("manager-in-project", Boolean.toString(manager_in_project));
        for (String config : configFiles) {
            xml.writeXML(config);
        }
        xml.closeElement();
    }

    private void loadURIConfig(List<String> configs, String template, String actiontypes, String sourcetypes, URI uri, Role role) throws FoundationException {
        String cfg;
        URLConfig config;
        String doctype = URIRule.getStyleConfig((URI)uri);
        if (URIs.isExternal((URI)uri) && (config = URLFiles.loadURLConfig((String)doctype, null)) != null) {
            XMLOutputPrinter out = new XMLOutputPrinter();
            config.printPublishing((OutputPrinter)new UniversalPrinter((OutputPrinter)out), role);
            configs.add(out.toString());
        }
        boolean checkGroupPSMLActions = true;
        DocumentConfigHandler handler = new DocumentConfigHandler(null, doctype);
        if (URIRule.isPSML((URI)uri) && !Strings.isEmpty((String)(cfg = PSMLFiles.findDocumentPublishConfig((String)template, (String)(doctype == null || "null".equals(doctype) ? "default" : doctype), (String)actiontypes, (String)sourcetypes, (boolean)true, (Role)role, (DocumentConfigHandler)handler)))) {
            configs.add(cfg);
            boolean bl = checkGroupPSMLActions = !cfg.contains("<publishing override=\"true\"");
        }
        if (checkGroupPSMLActions) {
            String[] fn = URIRule.getFilename((URI)uri);
            String ext = Strings.isEmpty((String)fn[1]) || fn[1].length() < 2 ? null : fn[1].substring(1);
            configs.add(PSMLFiles.findGroupPublishConfig((String)template, (String)actiontypes, (String)sourcetypes, (String)ext, (String)doctype, (Role)role, (List)handler.overrideTargets()));
        }
    }

    private void loadAllURIsConfig(List<String> configs, String template, String actiontypes, String sourcetypes, Role role) throws FoundationException {
        for (String type : URLFiles.listAvailableTypes((String)template)) {
            URLConfig config = URLFiles.loadURLConfig((String)type, null);
            if (config == null) continue;
            XMLOutputPrinter out = new XMLOutputPrinter();
            config.printPublishing((OutputPrinter)new UniversalPrinter((OutputPrinter)out), role);
            configs.add(out.toString());
        }
        for (String type : PSMLFiles.listAvailableTypes((String)template, (String)"psml")) {
            DocumentConfigHandler handler = new DocumentConfigHandler(null, type);
            configs.add(PSMLFiles.findDocumentPublishConfig((String)template, (String)type, (String)actiontypes, (String)sourcetypes, (boolean)false, (Role)role, (DocumentConfigHandler)handler));
        }
        configs.add(PSMLFiles.findGroupPublishConfig((String)template, (String)actiontypes, (String)sourcetypes, null, null, (Role)role, null));
    }
}

