/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.publication.PublicationManager;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.search.GroupIndexingThread;
import com.pageseeder.search.utils.IndexingThreadBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.pageseeder.psml.toc.FragmentNumbering;
import org.pageseeder.psml.toc.PublicationConfig;
import org.pageseeder.psml.toc.PublicationTree;

public final class RepairPublicationsThread
extends ProcessThread {
    private long total = 0L;
    private int current = 0;

    private RepairPublicationsThread(String username, Group group) {
        super(username, "Repairing publications for " + (String)(group == null ? "server" : "group " + group.getName()), group);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Database db;
        try {
            db = Database.open();
        }
        catch (OpenDatabaseException ex) {
            this.fail("Failed to open database: " + ex.getMessage());
            this.complete("");
            return;
        }
        Transaction tr = new Transaction(db);
        try {
            List publications;
            tr.begin();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Computing publications number");
            Long groupid = this.getGroupID();
            Group group = null;
            if (groupid == -1L) {
                publications = DatabaseQuery.getAllPublications((Database)db);
            } else {
                group = DatabaseQuery.getGroupById((Database)db, (Long)groupid);
                publications = DatabaseQuery.getPublicationsByGroups((Database)db, Collections.singleton(group.getName()), (boolean)true, (int)1, (int)-1);
            }
            this.total = publications.size();
            this.updateStatus(ProcessStage.Status.INPROGRESS, "Found " + this.total + " publications to repair");
            PublicationManager manager = PublicationManager.singleton();
            HashSet pub_groups = new HashSet();
            for (Publication pub : publications) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Repairing publication " + pub.getId() + " (" + (this.current + 1) + " of " + this.total + ")");
                manager.lockPublicationCache(pub);
                try {
                    XLink xlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
                    URI root_uri = DatabaseQuery.getURIById((Database)db, (Long)pub.getRootURIId());
                    Collection locators = DatabaseQuery.getLocatorsForPublication((Database)db, (XLink)xlink);
                    for (Locator locator : locators) {
                        locator.removePublications(xlink);
                    }
                    manager.clearCachedTOC(pub);
                    if (root_uri.getPath().contains("/archive/")) {
                        XLinkRule.archiveXLink((XLink)xlink);
                        ++this.current;
                        continue;
                    }
                    pub_groups.addAll(DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)root_uri.getId()));
                    Group pgroup = DatabaseQuery.getGroupById((Database)db, (Long)pub.getDefaultGroupId());
                    PublicationConfig pubconfig = manager.getPublicationConfig(pgroup, pub.getType());
                    PublicationTree pubtree = manager.createPublicationTree(db, pub, pgroup, pubconfig, new HashMap());
                    if (this.wasCancelled()) {
                        tr.abort();
                        return;
                    }
                    NumberedTOC toc = new NumberedTOC(pubtree, new FragmentNumbering(), pub.getDefaultGroupId(), pub.getType(), true, new Date(), false);
                    manager.putCachedTOC(pub, toc);
                    tr.commitAndStart();
                }
                finally {
                    manager.unlockPublicationCache(pub);
                    continue;
                }
                ++this.current;
            }
            if (group != null) {
                for (Group grp : pub_groups) {
                    if (GroupRule.isAdminGroup((String)grp.getName()) || GroupRule.isPublicGroup((String)grp.getName())) continue;
                    this.updateStatus(ProcessStage.Status.INPROGRESS, "Starting re-indexing group " + grp.getName() + " (in another process thread)");
                    GroupIndexingThread thread = GroupIndexingThread.newInstance((String)this.getUsername(), (String)("Indexing group after repair publications " + grp.getName()), (Group)grp);
                    thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.DOCUMENT);
                    thread.addTypeToindex(IndexingThreadBase.INDEXTYPE.COMMENT);
                    ProcessManager.getInstance().start((ProcessThread)thread);
                }
            }
            tr.commit();
        }
        catch (StartTransactionException e) {
            this.fail("Failed to start transaction");
            tr.abort();
        }
        catch (DatabaseException e) {
            this.fail("Failed to communicate with database: " + e.getMessage());
            tr.abort();
        }
        finally {
            db.close();
            db = null;
            this.complete(this.current + " publications repaired.");
        }
    }

    public void writeThreadElements(OutputPrinter out) {
        out.startObject("progress");
        out.field("total", this.total);
        out.field("current", (long)this.current);
        out.endObject();
    }

    public static RepairPublicationsThread newInstance(String username, Group group) {
        return new RepairPublicationsThread(username, group);
    }
}

