/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

@Requires(database=true, uri=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListPublicationsForURI
implements Generator,
SingleCheck,
Cacheable {
    private static final String PUBLICATION_ATTRIBUTE = "com.pageseeder.publication.ListPublicationsForURI.publications";

    public String getETag(GeneratorRequest req) throws DatabaseException {
        List<Publication> pubs = this.loadPublications(req);
        req.getHttpServletRequest().setAttribute(PUBLICATION_ATTRIBUTE, pubs);
        StringBuilder etag = new StringBuilder();
        for (Publication pub : pubs) {
            etag.append(pub.getRootModified()).append('|');
        }
        return MD5.hash((String)etag.toString());
    }

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getMember() != null) {
            return new ViewMemberCheck(req.getMember(), (PermissionCheck)new ViewURICheck(req.getGroup(), req.getURI()));
        }
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        List<Publication> pubs = null;
        if (req.getHttpServletRequest() != null) {
            pubs = (List<Publication>)req.getHttpServletRequest().getAttribute(PUBLICATION_ATTRIBUTE);
        }
        if (pubs == null) {
            pubs = this.loadPublications(req);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("publications");
        out.startCollection("publications", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Publication pub : pubs) {
            Publications.print((Publication)pub, (UniversalPrinter)out);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private List<Publication> loadPublications(GeneratorRequest req) throws DatabaseException {
        if (req.getParameter((Parameter)StandardParameters.rootonly, false)) {
            Publication pub = DatabaseQuery.getPublicationByRootURI((Database)req.getDatabase(), (URI)req.getURI(), (boolean)false);
            return pub == null ? Collections.emptyList() : Collections.singletonList(pub);
        }
        UserDetails userdetails = req.getMember() == null ? SecurityUtils.getDefaultUserDetails() : new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), false);
        return Publications.getAncestorPublications((Database)req.getDatabase(), (URI)req.getURI(), (UserDetails)userdetails);
    }
}

