/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.publication;

import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Publication;
import java.io.IOException;

@Requires(database=true, group=true, parameters={"publicationid"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetPublication
implements Generator,
SingleCheck,
Cacheable {
    private static final String PUBLICATION_ATTRIBUTE = "com.pageseeder.publication.GetPublication.publication";

    public String getETag(GeneratorRequest req) throws DatabaseException {
        Publication pub = (Publication)req.getHttpServletRequest().getAttribute(PUBLICATION_ATTRIBUTE);
        if (pub == null) {
            pub = this.loadPublication(req);
        }
        if (pub == null) {
            return null;
        }
        req.getHttpServletRequest().setAttribute(PUBLICATION_ATTRIBUTE, (Object)pub);
        return String.valueOf(pub.getRootModified());
    }

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        Publication pub = (Publication)req.getHttpServletRequest().getAttribute(PUBLICATION_ATTRIBUTE);
        if (pub == null) {
            pub = this.loadPublication(req);
        }
        if (pub == null) {
            return new NoCheck();
        }
        req.getHttpServletRequest().setAttribute(PUBLICATION_ATTRIBUTE, (Object)pub);
        return new ViewURICheck(DatabaseQuery.getURIById((Database)req.getDatabase(), (Long)pub.getRootURIId()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Publication pub = (Publication)req.getHttpServletRequest().getAttribute(PUBLICATION_ATTRIBUTE);
        if (pub == null) {
            pub = this.loadPublication(req);
        }
        if (pub == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Invalid publicationid");
        } else {
            UniversalPrinter out = res.getUniversalWriter();
            Publications.print((Publication)pub, (UniversalPrinter)out);
            out.flush();
        }
    }

    private Publication loadPublication(GeneratorRequest req) throws DatabaseException {
        Host host = GroupURIRule.getDefaultGroupURI((Group)req.getGroup()).getHost();
        String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
        return DatabaseQuery.getPublicationByPublicationIDHost((Database)req.getDatabase(), (String)publicationid, (Host)host);
    }
}

