/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Structure {
    private Structure() {
    }

    public static void createStructureXLink(String structureXML, URI uri, Group group, Member author, Date creationDate, String contentTitle, Database database) throws DatabaseException {
        Structure.createStructureXLink(structureXML, uri, group, author, creationDate, contentTitle, false, database);
    }

    public static void createStructureXLink(String structureXML, URI uri, Group group, Member author, Date creationDate, String contentTitle, boolean statusNew, Database database) throws DatabaseException {
        XLink structure = DatabaseQuery.getXLinkURIStructure((Database)database, (URI)uri, (Group)group, null);
        if (structure != null) {
            structure.setStatus("Documentation-Old");
        }
        XLinkRule.createStructureXLink((URI)uri, (Group)group, (Database)database, (String)structureXML, (Member)author, (Date)creationDate, (String)contentTitle, (boolean)statusNew);
    }

    public static boolean addFragmentToStructureXLink(String[] fragDetails, boolean prepend, @Nullable XLink structure, URI uri, Group group, Member author, Database database) throws FoundationException, DatabaseException {
        InputStream content = Structure.getStructureContent(structure, uri, group, database);
        XMLStringWriter xmlStructure = new XMLStringWriter(XML.NamespaceAware.No);
        StructureHandler screator = new StructureHandler((XMLWriter)xmlStructure);
        screator.addNewFragment(fragDetails[0], fragDetails[1], prepend, fragDetails[2], fragDetails[3]);
        ArrayList errors = new ArrayList();
        XMLHelpers.parse((InputStream)content, (ContentHandler)screator, errors, null);
        if (!screator.wasFragmentAdded()) {
            return false;
        }
        if (!errors.isEmpty()) {
            StringBuilder err = new StringBuilder();
            for (String e : errors) {
                err.append(e).append("\n");
            }
            throw new FoundationException("Failed to create URI structure: " + err.toString());
        }
        if (structure != null) {
            structure.setStatus("Documentation-Old");
        }
        XLinkRule.createStructureXLink((URI)uri, (Group)group, (Database)database, (String)xmlStructure.toString(), (Member)author, null, (String)"Fragment Add");
        return true;
    }

    public static void cancelLatestStructureChange(URI uri, Group group, Database database) throws DatabaseException {
        XLink current = DatabaseQuery.getXLinkURIStructure((Database)database, (URI)uri, (Group)group, null);
        XLink previous = DatabaseQuery.getXLinkPreviousURIStructure((Database)database, (URI)uri, (Group)group);
        if (current != null && previous != null) {
            previous.setStatus(null);
            current.delete(database);
        }
    }

    public static MoveResult moveFragment(@Nullable XLink structure, String[] moveDetails, URI uri, Group group, Member author, Database database) throws FoundationException, DatabaseException {
        String fragment = moveDetails[0];
        String section = moveDetails[1];
        String afterfragment = moveDetails[2];
        String beforefragment = moveDetails[3];
        InputStream content = Structure.getStructureContent(structure, uri, group, database);
        XMLStringWriter xmlStructure = new XMLStringWriter(XML.NamespaceAware.No);
        StructureHandler screator = new StructureHandler((XMLWriter)xmlStructure);
        screator.checkFragment(fragment);
        screator.removeFragment(fragment);
        screator.addNewFragment(fragment, section, false, afterfragment, beforefragment);
        ArrayList errors = new ArrayList();
        XMLHelpers.parse((InputStream)content, (ContentHandler)screator, errors, null);
        if (!screator.wasFragmentFound() && !screator.wasFragmentAdded()) {
            return MoveResult.FRAG_AND_TARGET_NOT_FOUND;
        }
        if (!screator.wasFragmentFound()) {
            return MoveResult.FRAG_NOT_FOUND;
        }
        if (!screator.wasFragmentAdded()) {
            return MoveResult.TARGET_NOT_FOUND;
        }
        if (!errors.isEmpty()) {
            StringBuilder err = new StringBuilder();
            for (String e : errors) {
                err.append(e).append("\n");
            }
            throw new FoundationException("Failed to create URI structure: " + err.toString());
        }
        if (structure != null) {
            structure.setStatus("Documentation-Old");
        }
        XLinkRule.createStructureXLink((URI)uri, (Group)group, (Database)database, (String)xmlStructure.toString(), (Member)author, null, (String)"Fragment Move");
        return MoveResult.SUCCESS;
    }

    public static boolean structureHasFragment(String fragment, @Nullable XLink structure, URI uri, Group group, Database database) throws FoundationException {
        InputStream content = Structure.getStructureContent(structure, uri, group, database);
        XMLStringWriter xmlStructure = new XMLStringWriter(XML.NamespaceAware.No);
        StructureHandler verifier = new StructureHandler((XMLWriter)xmlStructure);
        verifier.checkFragment(fragment);
        ArrayList errors = new ArrayList();
        XMLHelpers.parse((InputStream)content, (ContentHandler)verifier, errors, null);
        return verifier.wasFragmentFound();
    }

    public static String[] findDeletedFragmentLocation(String fragment, URI uri, Group group, boolean original, Database database) throws FoundationException, DatabaseException {
        List structures = DatabaseQuery.getXLinksURIStructure((Database)database, (URI)uri, (Group)group);
        ListIterator structurei = structures.listIterator(structures.size());
        if (!structurei.hasPrevious()) {
            return new String[]{fragment, null, null, null};
        }
        XLink structure = (XLink)structurei.previous();
        InputStream content = Structure.getStructureContent(structure, uri, group, database);
        StructureHandler handler = new StructureHandler((XMLWriter)new XMLStringWriter(XML.NamespaceAware.No));
        handler.checkFragment(fragment);
        ArrayList errors = new ArrayList();
        XMLHelpers.parse((InputStream)content, (ContentHandler)handler, errors, null);
        Map<String, List<String>> current_section_fragments = handler.getSectionFragments();
        if (original) {
            structurei = structures.listIterator(1);
        }
        while (structurei.hasPrevious()) {
            structure = (XLink)structurei.previous();
            content = Structure.getStructureContent(structure, uri, group, database);
            handler = new StructureHandler((XMLWriter)new XMLStringWriter(XML.NamespaceAware.No));
            handler.checkFragment(fragment);
            errors = new ArrayList();
            XMLHelpers.parse((InputStream)content, (ContentHandler)handler, errors, null);
            String sectionid = handler.getFragmentSectionID();
            if (sectionid == null) continue;
            List<String> fragments = handler.getSectionFragments().get(sectionid);
            List<String> currentfragments = current_section_fragments.get(sectionid);
            if (currentfragments == null) {
                return new String[]{fragment, null, null, null};
            }
            ListIterator<String> fragmenti = fragments.listIterator(fragments.size());
            boolean found_deleted = false;
            while (fragmenti.hasPrevious()) {
                String id = fragmenti.previous();
                if (fragment.equals(id)) {
                    found_deleted = true;
                    continue;
                }
                if (!found_deleted || !currentfragments.contains(id)) continue;
                return new String[]{fragment, null, id, null};
            }
            return new String[]{fragment, sectionid, null, null};
        }
        return new String[]{fragment, null, null, null};
    }

    public static void removeFragmentFromStructureXLink(String fragment, URI uri, Group group, Member author, Database db) throws FoundationException, DatabaseException {
        XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null);
        InputStream content = Structure.getStructureContent(structure, uri, group, db);
        XMLStringWriter xmlStructure = new XMLStringWriter(XML.NamespaceAware.No);
        StructureHandler screator = new StructureHandler((XMLWriter)xmlStructure);
        screator.removeFragment(fragment);
        ArrayList errors = new ArrayList();
        XMLHelpers.parse((InputStream)content, (ContentHandler)screator, errors, null);
        if (!errors.isEmpty()) {
            StringBuilder err = new StringBuilder();
            for (String e : errors) {
                err.append(e).append("\n");
            }
            throw new FoundationException("Failed to create URI structure: " + err.toString());
        }
        if (structure != null) {
            structure.setStatus("Documentation-Old");
        }
        XLinkRule.createStructureXLink((URI)uri, (Group)group, (Database)db, (String)xmlStructure.toString(), (Member)author, null, (String)"Fragment Remove");
    }

    protected static InputStream getStructureContent(@Nullable XLink structure, URI uri, Group group, Database db) throws URIException {
        if (structure != null) {
            return new ByteArrayInputStream(((Content)structure.getContents().next()).getData().getBytes(StandardCharsets.UTF_8));
        }
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        return resolver.getContent(db);
    }

    public static class StructureHandler
    extends DefaultHandler {
        private static final String DOCUMENT_ELEMENT = "document";
        private static final String SECTION_ELEMENT = "section";
        private static final String ID_ATTRIBUTE = "id";
        private final XMLWriter xml;
        private String fragmentToRemove = null;
        private String fragmentToCheck = null;
        private boolean fragmentToCheckFound = false;
        private String newFragment = null;
        private String sectionID = null;
        private boolean prependToSection = false;
        private String currentSectionID = null;
        private String fragmentSectionID = null;
        private String afterFragment = null;
        private String beforeFragment = null;
        private boolean inCorrectSection = false;
        private boolean inSectionTitle = false;
        private boolean fragmentAdded = false;
        private boolean closeSection = false;
        private boolean addTOC = false;
        private final Stack<String> elements = new Stack();
        private final Map<String, List<String>> sectionFragments = new HashMap<String, List<String>>();

        public StructureHandler(XMLWriter output) {
            this.xml = output;
        }

        public void addNewFragment(String frag, String sectionid, boolean prepend, String after, String before) {
            this.newFragment = frag;
            this.sectionID = after != null || before != null ? null : sectionid;
            this.prependToSection = prepend;
            this.afterFragment = after;
            this.beforeFragment = after != null ? null : before;
        }

        public void removeFragment(String frag) {
            this.fragmentToRemove = frag;
        }

        public void checkFragment(String frag) {
            this.fragmentToCheck = frag;
        }

        @Override
        public void startElement(String uri, String lName, String qName, Attributes atts) throws SAXException {
            List<String> fragments;
            boolean isTOC;
            String dad = this.elements.isEmpty() ? null : this.elements.peek();
            boolean isSection = SECTION_ELEMENT.equals(lName) && DOCUMENT_ELEMENT.equals(dad);
            this.inSectionTitle = "title".equals(lName) && SECTION_ELEMENT.equals(dad);
            boolean isFragment = SECTION_ELEMENT.equals(dad) && (PSMLContentUtils.isFragmentElement((String)lName) || "fragment-ref".equals(lName));
            boolean bl = isTOC = "toc".equals(lName) && DOCUMENT_ELEMENT.equals(dad);
            if (this.closeSection && !isTOC) {
                try {
                    this.xml.closeElement();
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to close section", ex);
                }
                this.closeSection = false;
            }
            if (this.addTOC) {
                try {
                    this.xml.emptyElement("toc");
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to add TOC", ex);
                }
                this.addTOC = false;
            }
            String id = atts.getValue(ID_ATTRIBUTE);
            if (isSection) {
                this.inCorrectSection = this.sectionID != null && this.sectionID.equals(id);
                this.currentSectionID = id;
                this.sectionFragments.put(id, new ArrayList());
            }
            if (isFragment && (fragments = this.sectionFragments.get(this.currentSectionID)) != null) {
                fragments.add(id);
            }
            if (isFragment && (id != null && id.equals(this.beforeFragment) || this.prependToSection && this.inCorrectSection && !this.fragmentAdded)) {
                this.newFragment();
            }
            try {
                if (isFragment && this.fragmentToCheck != null && this.fragmentToCheck.equals(id)) {
                    this.fragmentToCheckFound = true;
                    this.fragmentSectionID = this.currentSectionID;
                }
                if (isTOC) {
                    this.addTOC = true;
                } else if (isFragment && (this.fragmentToRemove == null || !this.fragmentToRemove.equals(id))) {
                    this.xml.openElement("fragment-ref");
                    if (id != null) {
                        this.xml.attribute(ID_ATTRIBUTE, id);
                    }
                    this.xml.closeElement();
                } else if (DOCUMENT_ELEMENT.equals(lName) || isSection || this.inSectionTitle) {
                    this.xml.openElement(lName);
                    for (int i = 0; i < atts.getLength(); ++i) {
                        this.xml.attribute(atts.getLocalName(i), atts.getValue(i));
                    }
                }
            }
            catch (IOException ex) {
                throw new SAXException("Failed to open element " + lName, ex);
            }
            if (isFragment && id != null && id.equals(this.afterFragment)) {
                this.newFragment();
            }
            this.elements.push(lName);
        }

        @Override
        public void endElement(String uri, String lName, String qName) throws SAXException {
            boolean isSectionTitle;
            this.elements.pop();
            String dad = this.elements.isEmpty() ? null : this.elements.peek();
            boolean isSection = SECTION_ELEMENT.equals(lName) && DOCUMENT_ELEMENT.equals(dad);
            boolean bl = isSectionTitle = "title".equals(lName) && SECTION_ELEMENT.equals(dad);
            if (isSection && this.inCorrectSection && !this.fragmentAdded) {
                this.newFragment();
            }
            if (DOCUMENT_ELEMENT.equals(lName) || isSectionTitle) {
                try {
                    if (DOCUMENT_ELEMENT.equals(lName) && this.sectionID == null && this.afterFragment == null && this.beforeFragment == null && this.newFragment != null && this.closeSection) {
                        this.newFragment();
                    }
                    if (this.closeSection) {
                        this.xml.closeElement();
                        this.closeSection = false;
                    }
                    if (this.addTOC) {
                        this.xml.emptyElement("toc");
                        this.addTOC = false;
                    }
                    this.xml.closeElement();
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to close element " + lName, ex);
                }
            } else if (isSection) {
                this.closeSection = true;
            }
            this.inSectionTitle = isSectionTitle;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inSectionTitle) {
                try {
                    this.xml.writeText(ch, start, length);
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to write text", ex);
                }
            }
        }

        private void newFragment() throws SAXException {
            try {
                this.xml.openElement("fragment-ref");
                this.xml.attribute(ID_ATTRIBUTE, this.newFragment);
                this.xml.closeElement();
            }
            catch (IOException ex) {
                throw new SAXException("Failed to output new fragment", ex);
            }
            this.fragmentAdded = true;
        }

        public boolean wasFragmentAdded() {
            return this.fragmentAdded;
        }

        public boolean wasFragmentFound() {
            return this.fragmentToCheckFound;
        }

        public @Nullable String getFragmentSectionID() {
            return this.fragmentSectionID;
        }

        public Map<String, List<String>> getSectionFragments() {
            return this.sectionFragments;
        }
    }

    public static enum MoveResult {
        SUCCESS,
        FRAG_NOT_FOUND,
        TARGET_NOT_FOUND,
        FRAG_AND_TARGET_NOT_FOUND;

    }
}

