/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLContentUtils;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.Structure;
import com.pageseeder.uri.URIEditLock;
import com.pageseeder.uri.URIErrorID;
import com.pageseeder.uri.URIUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true, group=true, member=true, parameters={"fragment", "editid"})
public final class RevertFragment
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)(URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new AddEditXLinksCheck(req.getGroup(), req.getURI())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        String messages;
        URI uri = req.getURI();
        Date previousModified = uri.getLastModified();
        Member author = req.getMember();
        Database db = req.getDatabase();
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        Long editid = req.getParameter((Parameter)StandardParameters.editid, -1L);
        URIEditLock lock = URIEditLock.newInstance(uri.getId());
        if (!lock.lock()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Another edit for this URI is currently being saved.");
            return;
        }
        String new_content = null;
        try {
            Content content;
            XLink edit;
            Locator loc;
            Group group;
            block53: {
                group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
                if (!URIRule.hasFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
                    return;
                }
                loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)fragment);
                edit = null;
                content = null;
                if (editid == 0L) {
                    Iterator lfxi = loc.getXLinksForLocator((Object)Predicates.predicateLocatorForXLinkByContentrolesDescending((Database)db, (String[])new String[]{"Documentation-Original"}));
                    if (lfxi.hasNext()) {
                        edit = ((LocatorForXLink)lfxi.next()).getXLink();
                    }
                } else {
                    edit = DatabaseQuery.getXLinkById((Database)db, (Long)editid);
                    if (edit == null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EDIT_NOT_FOUND);
                        return;
                    }
                    Locator editloc = LocatorRule.getLocatorByXLink((Database)db, (XLink)edit);
                    if (editloc == null || !editloc.equals((Object)loc)) {
                        res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.EDIT_NOT_FOUND, "Edit with this ID not found on URI fragment: " + editid);
                        return;
                    }
                }
                if (edit != null) {
                    Content content2 = content = edit.getContents().hasNext() ? (Content)edit.getContents().next() : null;
                    if (edit.getContentRole() == null || !edit.getContentRole().startsWith("Documentation") || content == null) {
                        res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.EDIT_NOT_FOUND);
                        return;
                    }
                }
                if (PSML.editClash(loc, group, req.getParameter((Parameter)StandardParameters.lastmodified), db, res)) {
                    return;
                }
                if (URIRule.isPSML((URI)uri) && !"default".equals(fragment)) {
                    try {
                        XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null);
                        if (Structure.structureHasFragment(fragment, structure, uri, group, db)) break block53;
                        String[] fragDetails = Structure.findDeletedFragmentLocation(fragment, uri, group, edit == null || "Documentation-Original".equals(edit.getContentRole()), db);
                        try {
                            if (!Structure.addFragmentToStructureXLink(fragDetails, true, structure, uri, group, author, db)) {
                                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.FRAGMENT_NOT_IN_STRUCTURE);
                                return;
                            }
                        }
                        catch (FoundationException ex) {
                            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to update URI's structure: " + ex.getMessage());
                            return;
                        }
                    }
                    catch (FoundationException ex) {
                        res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document structure: " + ex.getMessage());
                        return;
                    }
                }
            }
            FragmentEditor editor = new FragmentEditor(uri, fragment, author, group);
            editor.setHTMLTransform(false);
            String notesContent = req.getParameter((Parameter)StandardParameters.note, "");
            if (notesContent.isEmpty()) {
                notesContent = null;
            }
            String notesTitle = req.getParameter((Parameter)StandardParameters.note_title, "Edit note");
            String nLabels = req.getParameter((Parameter)StandardParameters.note_labels, "");
            String[] notesLabels = nLabels.isEmpty() ? null : nLabels.split(",");
            editor.setNotes(notesContent, notesTitle, notesLabels);
            if (edit == null || "Documentation-Hidden".equals(edit.getContentRole())) {
                editor.delete(db);
            } else {
                String labs = req.getParameter((Parameter)StandardParameters.labels);
                if (!URIUtils.checkLabels(res, labs)) {
                    return;
                }
                String[] labels = labs == null ? Labels.getLabels((XLink)edit) : (labs.isEmpty() ? new String[]{} : labs.split(","));
                String type = content.getType();
                editor.edit(db, (String)(!"application/vnd.pageseeder.psml+xml".equals(type) ? "<media-fragment>" + (RuleUtils.isXMLMediaType((String)type) ? content.getData() : XML.escape((String)content.getData())) + "</media-fragment>" : content.getData()), type, PSMLContentUtils.getFragmentType((XLink)edit), labels, true);
            }
            FragmentEditor.Status status = editor.getStatus();
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            String string = messages = msg.length() > 0 ? msg.substring(1) : "";
            if (status == FragmentEditor.Status.XREF_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.XREF_PROCESSING_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.VALIDATION_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.VALIDATION_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.NOT_MODIFIED) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, "Not modified: " + messages);
                return;
            }
            if (status == FragmentEditor.Status.UNKNOWN_ERROR) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, messages);
                return;
            }
            if (edit != null && "Documentation-Draft".equals(edit.getStatus())) {
                edit.setStatusChangedBy(author);
                XLink current = editor.getCreatedEdit();
                if (current != null) {
                    current.setModifiedBy(edit.getMember());
                    if (edit.getDate() != null) {
                        current.setModifiedDate(new Date(edit.getDate().getTime()));
                    }
                    if (current.getDate() != null) {
                        edit.setStatusChangedDate(new Date(current.getDate().getTime()));
                    }
                    XLinkRule.archiveXLink((XLink)edit);
                }
            }
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            PSML.indexFragmentAndTargetURIs(db, uri, editor, loc, previousModified, "Reverting");
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setFragment(fragment);
            resolver.setFragmentInfo(true);
            resolver.setPSMLFormat(true);
            if (req.getParameter((Parameter)StandardParameters.transclude, false)) {
                UserDetails userdetails = new UserDetailsManager().get(req.getDatabase(), req.getMember().getId(), false);
                resolver.setTransclude(userdetails);
            }
            InputStream in = null;
            try {
                in = resolver.getContent(req.getDatabase());
            }
            catch (URIException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document's content: " + ex.getMessage());
                lock.unlock();
                return;
            }
            try {
                new_content = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            finally {
                in.close();
            }
            new_content = new_content == null || new_content.isEmpty() ? "<document-fragment/>" : new_content.replaceAll("<\\?xml(.*?)\\>", "");
        }
        finally {
            lock.unlock();
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("fragment-creation");
        if (!messages.isEmpty()) {
            xml.attribute("unresolved-xrefs", "true");
        }
        xml.writeXML(new_content);
        xml.closeElement();
    }
}

