/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.io.TemplateFiles;
import com.pageseeder.db.Database;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.publishapi.PageseederException;
import com.pageseeder.validation.SchematronURIResolver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.jdt.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

public class PSMLTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PSMLTransformer.class);
    private final Database db;
    private final URI uri;
    private final Group group;
    private static final Map<String, CachedTemplate> TEMPLATES_CACHE = new HashMap<String, CachedTemplate>();
    private static final TransformerFactory FACTORY = XMLHelpers.safeTransformerFactory();
    private final SchematronURIResolver uriResolver;

    PSMLTransformer(URI uri, Group group, Member member, Database db) {
        this.uri = uri;
        this.group = group;
        this.db = db;
        this.uriResolver = new SchematronURIResolver(group, uri, member, db);
        this.uriResolver.setServerFromURI(uri);
    }

    String transformFragmentContent(String content, File script, @Nullable Map<String, String> parameters) throws PageseederException {
        return this.transformFragmentContent(new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8)), script, parameters);
    }

    String transformFragment(String fragment, File script, @Nullable Map<String, String> parameters) throws PageseederException {
        DocumentContentResolver resolver = new DocumentContentResolver(this.uri.getId(), this.group.getName());
        resolver.setFragment(fragment);
        resolver.setFragmentInfo(false);
        resolver.setPSMLFormat(true);
        try {
            return this.transformFragmentContent(resolver.getContent(this.db), script, parameters);
        }
        catch (URIException ex) {
            throw new PageseederException("Failed to load document's content: " + ex.getMessage());
        }
    }

    private String transformFragmentContent(InputStream fragmentContent, File script, @Nullable Map<String, String> parameters) throws PageseederException {
        Transformer transformer;
        try {
            transformer = PSMLTransformer.loadTransformer(script);
        }
        catch (TransformerConfigurationException ex) {
            throw new PageseederException("Failed to create transformer from script " + script.getName(), (Throwable)ex);
        }
        if (parameters != null) {
            parameters.keySet().forEach(p -> transformer.setParameter((String)p, parameters.get(p)));
        }
        StringWriter out = new StringWriter();
        try {
            transformer.setURIResolver(this.uriResolver);
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new SAXSource(new InputSource(fragmentContent)), new StreamResult(out));
        }
        catch (TransformerException ex) {
            throw new PageseederException("Failed to run transformation: " + ex.getMessage(), (Throwable)ex);
        }
        return out.toString();
    }

    static @Nullable File getTransformationScript(Group group, String scriptName) {
        TemplateFiles resources = new TemplateFiles(group.getOwnerDirectory());
        return resources.findFile("quickfix" + File.separator + scriptName + ".xsl");
    }

    public static void clearCache() {
        TEMPLATES_CACHE.clear();
    }

    private static Transformer loadTransformer(File templates) throws TransformerConfigurationException {
        CachedTemplate t = TEMPLATES_CACHE.get(templates.getAbsolutePath());
        if (t == null || t.lastModified != templates.lastModified()) {
            t = new CachedTemplate(FACTORY.newTemplates(new StreamSource(templates)), templates.lastModified());
            TEMPLATES_CACHE.put(templates.getAbsolutePath(), t);
            LOGGER.debug("Putting XSLT into cache: {}", (Object)templates.getAbsolutePath());
        }
        return t.templates.newTransformer();
    }

    private static class CachedTemplate {
        private Templates templates;
        private long lastModified;

        CachedTemplate(Templates template, long modified) {
            this.templates = template;
            this.lastModified = modified;
        }
    }
}

