/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.StructureBuilder;
import com.pageseeder.base.generator.Cacheable;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

@Requires(group=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListStructureEdits
implements Generator,
SingleCheck,
Cacheable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListStructureEdits.class);

    public String getETag(GeneratorRequest req) {
        return String.valueOf(req.getURI().getLastModified().getTime());
    }

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("structure-edits");
        out.startCollection("structure-edits", OutputPrinter.CollectionOption.JSON_ONLY);
        try {
            if (URIRule.isPSML((URI)uri)) {
                List edits = DatabaseQuery.getXLinksURIStructure((Database)db, (URI)uri, (Group)group);
                if (edits.isEmpty() || !((XLink)edits.get(0)).getDate().equals(uri.getDateCreated())) {
                    StructureBuilder handler = new StructureBuilder();
                    File originalFile = new File(URIRule.getRealPath((String)uri.getPath()));
                    XMLHelpers.parse((InputStream)new FileInputStream(originalFile), (ContentHandler)handler);
                    out.startObject("edit");
                    out.field("id", 0L);
                    if (uri.getDateCreated() != null) {
                        out.field("created", ISO8601.format((long)uri.getDateCreated().getTime(), (ISO8601)ISO8601.DATETIME));
                    }
                    out.field("type", "original");
                    out.startObject("content");
                    out.field("content", handler.getStructureXML(), OutputPrinter.FieldOption.XML_COPY);
                    out.endObject();
                    out.endObject();
                }
                for (XLink edit : edits) {
                    out.startObject("edit");
                    out.field("id", edit.getId().longValue());
                    if (edit.getDate() != null) {
                        out.field("created", ISO8601.format((long)edit.getDate().getTime(), (ISO8601)ISO8601.DATETIME));
                    }
                    String cont_title = edit.getContentTitle();
                    String type = null;
                    if ("Document Create".equals(cont_title)) {
                        type = "create";
                    } else if ("Document Upload".equals(cont_title)) {
                        type = "upload";
                    } else if ("Fragment Add".equals(cont_title)) {
                        type = "add";
                    } else if ("Fragment Remove".equals(cont_title)) {
                        type = "remove";
                    } else if ("Fragment Move".equals(cont_title)) {
                        type = "move";
                    } else if ("Structure Edit".equals(cont_title)) {
                        type = "edit";
                    }
                    if (type != null) {
                        out.field("type", type);
                    }
                    if (edit.getMember() != null) {
                        out.writeMember(edit.getMember(), false, "author", null);
                    } else if (edit.getAuthorName() != null) {
                        out.startObject("author");
                        out.field("fullname", edit.getAuthorName(), OutputPrinter.FieldOption.XML_ELEMENT);
                        out.endObject();
                    }
                    Iterator conti = edit.getContents();
                    if (conti.hasNext()) {
                        Content cont = (Content)conti.next();
                        out.startObject("content");
                        out.field("content", cont.getData(), OutputPrinter.FieldOption.XML_COPY);
                        out.endObject();
                    }
                    out.endObject();
                }
            }
        }
        catch (FoundationException ex) {
            LOGGER.error("Unable to load original structure.", (Throwable)ex);
        }
        finally {
            out.endCollection();
            out.endObject();
            out.flush();
        }
    }
}

