/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewURICheck;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;

@Requires(group=true, uri=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetDraftEdits
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewURICheck(req.getGroup(), req.getURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        boolean contents = "all".equals(req.getParameter((Parameter)StandardParameters.contents));
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        if (fragment != null && !URIRule.hasFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
            return;
        }
        DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
        resolver.setFragmentInfo(true);
        resolver.setPSMLFormat(true);
        if (contents && req.getParameter((Parameter)StandardParameters.transclude, false)) {
            Member auth_mem = req.getAuthenticatedMember();
            UserDetails userdetails = auth_mem == null ? SecurityUtils.getDefaultUserDetails() : new UserDetailsManager().get(db, auth_mem.getId(), false);
            resolver.setTransclude(userdetails);
            String publicationid = req.getParameter((Parameter)StandardParameters.publicationid);
            if (!Strings.isEmpty((String)publicationid)) {
                int position = (int)req.getParameter((Parameter)StandardParameters.position, 1L);
                Publication publication = Publications.findValidURIPublication((Database)req.getDatabase(), (String)publicationid, (boolean)true, (URI)uri);
                if (publication != null) {
                    resolver.setPublication(publication, position, false);
                }
            } else if ("true".equals(req.getParameter((Parameter)StandardParameters.publication))) {
                resolver.setPublication(Publications.blank((URI)uri, (Group)group), 1, true);
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("drafts");
        if (uri.getLastModified() != null) {
            out.field("modified", ISO8601.format((long)uri.getLastModified().getTime(), (ISO8601)ISO8601.DATETIME));
        }
        out.startCollection("drafts", OutputPrinter.CollectionOption.JSON_ONLY);
        try {
            List locators = fragment == null ? uri.getLocatorsList((Object)Predicates.predicateOrderBy((Database)db, (String)"fragment ascending")) : uri.getLocatorsList((Object)Predicates.predicateLocatorFragment((Database)db, (String)fragment));
            if (locators != null) {
                for (Locator locator : locators) {
                    Iterator drafts = DatabaseQuery.getXLinksByDraftGroupLocatorMember((Database)db, (Long)group.getId(), (Long)locator.getId(), null, (boolean)false);
                    while (drafts.hasNext()) {
                        XLink draft = (XLink)drafts.next();
                        out.writeDraftEdit(draft, locator, null, false);
                        try {
                            Member mem = draft.getMember();
                            if (!contents || mem == null) continue;
                            resolver.setFragment(locator.getFragment());
                            resolver.includeDraftContent(mem.getId());
                            out.field("content", IOUtils.toString((InputStream)resolver.getContent(db), (Charset)StandardCharsets.UTF_8), OutputPrinter.FieldOption.XML_COPY);
                        }
                        catch (Exception ex) {
                            res.setError(GeneratorStatus.SERVER_ERROR, "Unable to load content for draft ID " + draft.getId() + ": " + ex.getMessage());
                        }
                        finally {
                            out.endObject();
                        }
                    }
                }
            }
        }
        finally {
            out.endCollection();
            out.endObject();
            out.flush();
        }
    }
}

