/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.uri.URIEditLock;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Requires(uri=true, member=true, parameters={"name", "newvalue"})
public final class EditProperty
implements Generator,
SingleCheck {
    @ContentPermission(value=EditURICheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)(URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new EditURICheck(req.getGroup())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        URI uri = req.getURI();
        Database db = req.getDatabase();
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        String newvalue = req.getParameter((Parameter)StandardParameters.newvalue, "");
        String oldvalue = req.getParameter((Parameter)StandardParameters.oldvalue);
        String propertyName = req.getParameter((Parameter)StandardParameters.name);
        Group group = req.getGroup();
        if (!URIs.isExternal((URI)uri) && group == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing group");
            return;
        }
        if (fragment == null && oldvalue == null || propertyName == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Missing Parameter: fragment=" + fragment + ", oldvalue=" + oldvalue + ", name=" + propertyName);
            return;
        }
        URIEditLock lock = URIEditLock.newInstance(req.getURI().getId());
        if (!lock.lock()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Another edit for this URI is currently being saved.");
            return;
        }
        try {
            String messages;
            InputStream in;
            PropertyReplacer replacer;
            Group editGroup;
            block25: {
                editGroup = GroupRule.getEditGroup((Database)db, (Group)group, (URI)uri);
                if (fragment != null && !URIRule.hasFragment((URI)uri, (Group)editGroup, (String)fragment, (Database)req.getDatabase())) {
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
                    return;
                }
                DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), editGroup.getName());
                resolver.setPSMLFormat(true);
                if (fragment != null) {
                    resolver.setFragment(fragment);
                }
                replacer = new PropertyReplacer(propertyName, oldvalue, newvalue, "default".equalsIgnoreCase(fragment));
                try {
                    in = resolver.getContent(db);
                    if (in.available() != 0) break block25;
                    res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "Fragment was not found with ID " + fragment);
                    return;
                }
                catch (FoundationException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Failed to parse document content: " + ex.getMessage());
                    lock.unlock();
                    return;
                }
            }
            XMLHelpers.parse((InputStream)in, (ContentHandler)replacer);
            fragment = replacer.finalFragmentID;
            if (fragment == null) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "The old value did not match the existing content (it may have been edited by someone else).");
                return;
            }
            String fragmentContent = replacer.finalFragmentContent;
            if (fragmentContent == null) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "Failed to build new content");
                return;
            }
            FragmentEditor editor = new FragmentEditor(uri, fragment, req.getMember(), editGroup);
            editor.edit(db, fragmentContent, "application/vnd.pageseeder.psml+xml", replacer.finalFragmentType, null, !"default".equalsIgnoreCase(fragment));
            FragmentEditor.Status status = editor.getStatus();
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            String string = messages = msg.length() > 0 ? msg.substring(1) : "";
            if (status == FragmentEditor.Status.XREF_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.XREF_PROCESSING_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.VALIDATION_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.VALIDATION_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.UNKNOWN_ERROR) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, messages);
                return;
            }
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            ChangesManager.getInstance().modifyURI(db, uri, editor.getURIGroups());
        }
        finally {
            lock.unlock();
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("property-modification", true);
        xml.attribute("fragment", fragment);
        xml.attribute("uriid", uri.getId().toString());
        xml.openElement("property");
        xml.attribute("name", propertyName);
        xml.attribute("value", newvalue);
        xml.closeElement();
        xml.closeElement();
    }

    private static class PropertyReplacer
    extends DefaultHandler {
        private final String propertyName;
        private final String oldValue;
        private final String newValue;
        private final boolean metadata;
        private String finalFragmentID = null;
        private String finalFragmentType = null;
        private String finalFragmentContent = null;
        private String fragmentID = null;
        private String fragmentType = null;
        private XMLWriter fragmentContent = null;
        private StringBuilder markdown = null;

        public PropertyReplacer(String name, String oldvalue, String newvalue, boolean metadata) {
            this.oldValue = oldvalue;
            this.newValue = newvalue;
            this.propertyName = name;
            this.metadata = metadata;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            boolean replacePropertyValue = false;
            if (this.metadata && "properties".equals(localName)) {
                this.fragmentContent = new XMLStringWriter(XML.NamespaceAware.No);
                this.fragmentID = "default";
            } else if (!this.metadata && "properties-fragment".equals(localName)) {
                if (this.finalFragmentID == null) {
                    this.fragmentContent = new XMLStringWriter(XML.NamespaceAware.No);
                    this.fragmentID = attributes.getValue("id");
                    this.fragmentType = attributes.getValue("type");
                }
            } else if (this.fragmentID != null && "property".equals(localName) && this.propertyName.equals(attributes.getValue("name"))) {
                String value = attributes.getValue("value");
                String datatype = attributes.getValue("datatype");
                String count = attributes.getValue("count");
                String multiple = attributes.getValue("multiple");
                if (!((value == null || !value.equals(this.oldValue)) && !Strings.isEmpty((String)this.oldValue) || "markdown".equals(datatype) || "markup".equals(datatype) || "xref".equals(datatype) || "link".equals(datatype) || count != null && !"1".equals(count) || "true".equals(multiple))) {
                    this.finalFragmentID = this.fragmentID;
                    this.finalFragmentType = this.fragmentType;
                    replacePropertyValue = true;
                } else if ("markdown".equals(datatype)) {
                    this.markdown = new StringBuilder();
                }
            } else if (this.markdown != null && "markdown".equals(localName)) {
                this.markdown = new StringBuilder();
            }
            if (this.fragmentContent != null) {
                try {
                    this.fragmentContent.openElement(localName);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        String name = attributes.getLocalName(i);
                        if (replacePropertyValue && "value".equals(name)) continue;
                        String value = attributes.getValue(i);
                        this.fragmentContent.attribute(name, value);
                    }
                    if (replacePropertyValue) {
                        this.fragmentContent.attribute("value", this.newValue);
                    }
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to open element " + localName);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.fragmentContent != null) {
                try {
                    if (this.markdown != null) {
                        String value = this.markdown.toString();
                        if (value.equals(this.oldValue) || this.oldValue == null) {
                            this.finalFragmentID = this.fragmentID;
                            this.finalFragmentType = this.fragmentType;
                            if ("property".equals(localName)) {
                                this.fragmentContent.openElement("markdown");
                                this.fragmentContent.writeText(this.newValue);
                                this.fragmentContent.closeElement();
                            } else {
                                this.fragmentContent.writeText(this.newValue);
                            }
                        } else {
                            this.fragmentContent.writeText(value);
                        }
                        this.markdown = null;
                    }
                    this.fragmentContent.closeElement();
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to close element " + localName);
                }
            }
            if ("properties-fragment".equals(localName) || "properties".equals(localName)) {
                if (this.fragmentContent != null && this.finalFragmentID != null) {
                    this.finalFragmentContent = this.fragmentContent.toString();
                }
                this.fragmentContent = null;
                this.fragmentID = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.fragmentContent != null) {
                try {
                    if (this.markdown != null) {
                        this.markdown.append(ch, start, length);
                    } else {
                        this.fragmentContent.writeText(ch, start, length);
                    }
                }
                catch (IOException ex) {
                    throw new SAXException("Failed to write text");
                }
            }
        }
    }
}

