/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.psml;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AddEditXLinksCheck;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.psml.FragmentEditor;
import com.pageseeder.psml.PSML;
import com.pageseeder.psml.Structure;
import com.pageseeder.uri.URIEditLock;
import com.pageseeder.uri.URIErrorID;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import org.apache.commons.io.IOUtils;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(uri=true, group=true, member=true, parameters={"fragment"})
public final class DeleteFragment
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)(URIs.isExternal((URI)req.getURI()) ? new EditAllURLsCheck() : new AddEditXLinksCheck(req.getGroup(), req.getURI())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        URI uri = req.getURI();
        Date previousModified = uri.getLastModified();
        String fragment = req.getParameter((Parameter)StandardParameters.fragment);
        if ("default".equalsIgnoreCase(fragment)) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Can not delete the default fragment.");
            return;
        }
        URIEditLock lock = URIEditLock.newInstance(req.getURI().getId());
        if (!lock.lock()) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Another edit for this URI is currently being saved.");
            return;
        }
        String new_content = null;
        try {
            String messages;
            Group group = GroupRule.getEditGroup((Database)db, (Group)req.getGroup(), (URI)uri);
            if (!URIRule.hasFragment((URI)uri, (Group)group, (String)fragment, (Database)req.getDatabase())) {
                res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)URIErrorID.FRAGMENT_NOT_FOUND, "No fragment found with ID: " + fragment);
                return;
            }
            Locator loc = LocatorRule.getLocatorByURIFragment((Database)db, (URI)uri, (String)fragment);
            if (PSML.editClash(loc, group, req.getParameter((Parameter)StandardParameters.lastmodified), db, res)) {
                return;
            }
            if (URIRule.isPSML((URI)uri) && !uri.getExternal().booleanValue()) {
                try {
                    Structure.removeFragmentFromStructureXLink(fragment, uri, group, req.getMember(), db);
                }
                catch (FoundationException ex) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Unable to remove fragment from structure: " + ex.getMessage());
                    lock.unlock();
                    return;
                }
            }
            FragmentEditor editor = new FragmentEditor(uri, fragment, req.getMember(), group);
            String notesContent = req.getParameter((Parameter)StandardParameters.note, "");
            if (notesContent.isEmpty()) {
                notesContent = null;
            }
            String notesTitle = req.getParameter((Parameter)StandardParameters.note_title, "Edit note");
            String nLabels = req.getParameter((Parameter)StandardParameters.note_labels, "");
            String[] notesLabels = nLabels.isEmpty() ? null : nLabels.split(",");
            editor.setNotes(notesContent, notesTitle, notesLabels);
            editor.delete(db);
            FragmentEditor.Status status = editor.getStatus();
            StringBuilder msg = new StringBuilder();
            for (String message : editor.getErrors()) {
                msg.append("\n");
                msg.append(message);
            }
            String string = messages = msg.length() > 0 ? msg.substring(1) : "";
            if (status == FragmentEditor.Status.XREF_ERROR) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)URIErrorID.XREF_PROCESSING_ERROR, messages);
                return;
            }
            if (status == FragmentEditor.Status.NOT_MODIFIED) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, "Not modified: " + messages);
                return;
            }
            if (status == FragmentEditor.Status.UNKNOWN_ERROR) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)URIErrorID.FRAGMENT_CREATION_ERROR, messages);
                return;
            }
            uri.setLastModified(new Date());
            req.getTransaction().commitAndStart();
            PSML.indexFragmentAndTargetURIs(db, uri, editor, loc, previousModified, "Deleting");
            DocumentContentResolver resolver = new DocumentContentResolver(uri.getId(), group.getName());
            resolver.setPSMLFormat(true);
            resolver.setFragment(fragment);
            resolver.setFragmentInfo(true);
            try {
                new_content = IOUtils.toString((InputStream)resolver.getContent(req.getDatabase()), (Charset)StandardCharsets.UTF_8);
            }
            catch (URIException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load document's content: " + ex.getMessage());
                lock.unlock();
                return;
            }
        }
        finally {
            lock.unlock();
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("fragment-delete");
        new_content = new_content == null || new_content.isEmpty() ? "<document-fragment/>" : new_content.replaceAll("<\\?xml(.*?)\\>", "");
        xml.writeXML(new_content);
        xml.closeElement();
    }
}

