/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.organization;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.organization.EmailConfig;
import com.pageseeder.base.organization.OrganizationManager;
import com.pageseeder.base.organization.SecurityConfig;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.db.model.Group;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(database=true, group=true)
public class GetEmailConfig
implements Generator {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        OrganizationManager org_manager = OrganizationManager.instance();
        if (req.getParameter((Parameter)StandardParameters.reload, false) && (org_manager = org_manager.load()).hasError()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Error loading organization config, see general logs for details.");
            return;
        }
        Group group = req.getGroup();
        String globalTemplate = GlobalSettings.getGlobalTemplate();
        String project = group.getOwnerDirectory();
        EmailConfig config = org_manager.getEmailConfig(project);
        if (config == null && globalTemplate != null) {
            project = globalTemplate;
            config = org_manager.getEmailConfig(project);
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("email", true);
        xml.attribute("project", project);
        if (config != null) {
            String email_domain;
            String dkim_domain = config.getDKIMDomain();
            String dkim_selector = config.getDKIMSelector();
            Boolean dkim_disabled = config.getDKIMDisabled();
            if (dkim_domain != null || dkim_selector != null || dkim_disabled != null) {
                xml.openElement("dkim", true);
                if (dkim_domain != null) {
                    xml.attribute("domain", dkim_domain);
                }
                if (dkim_selector != null) {
                    xml.attribute("selector", dkim_selector);
                }
                if (dkim_disabled != null) {
                    xml.attribute("disabled", dkim_disabled.toString());
                }
                xml.closeElement();
            }
            if ((email_domain = config.getEmailDomain()) != null) {
                xml.openElement("emails", true);
                xml.attribute("domain", email_domain);
                xml.closeElement();
            }
            xml.writeXML(config.getNotificationXML());
        }
        SecurityConfig sec_config = org_manager.getSecurityConfig();
        Map tokens = sec_config.getTokenExpirations();
        for (Map.Entry entry : tokens.entrySet()) {
            xml.openElement("token", false);
            xml.attribute("type", ((SecurityConfig.TokenType)entry.getKey()).toString());
            xml.attribute("expiration", ((Duration)entry.getValue()).toString());
            xml.closeElement();
        }
        xml.closeElement();
    }
}

