/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorException;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.db.model.Role;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import com.pageseeder.membership.Memberships;
import java.io.IOException;
import java.util.Date;
import java.util.List;

@Requires(database=true, group=true)
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class InviteMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (!req.getParameter((Parameter)StandardParameters.invitation, true) || req.getParameter((Parameter)StandardParameters.auto_activate) != null) {
            return new ManageAccountCheck();
        }
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws GeneratorException, DatabaseException, IOException {
        MemberForGroup mfg;
        boolean memberHasEmail;
        Role psrole;
        String email = req.getParameter((Parameter)StandardParameters.email, "");
        String username = req.getParameter((Parameter)StandardParameters.member_username);
        String first_name = req.getParameter((Parameter)StandardParameters.firstname, "Member");
        String timestamp = Long.toString(new Date().getTime());
        String surname = req.getParameter((Parameter)StandardParameters.surname, timestamp.substring(timestamp.length() - 4));
        String notification = req.getParameter((Parameter)StandardParameters.notification);
        String role = req.getParameter((Parameter)StandardParameters.role);
        boolean listed = req.getParameter((Parameter)StandardParameters.listed, false);
        boolean sendNewMemberNotification = req.getParameter((Parameter)StandardParameters.welcome_email, true);
        boolean autoActivate = req.getParameter((Parameter)StandardParameters.auto_activate, false);
        Group group = req.getGroup();
        if ("admin".equals(group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.GROUP_NOT_ALLOWED);
            return;
        }
        Database db = req.getDatabase();
        boolean acceptInvitationRequired = GroupRule.acceptInvitationRequired((Database)db, (Group)group);
        if (req.getParameter((Parameter)StandardParameters.invitation) != null) {
            acceptInvitationRequired = req.getParameter((Parameter)StandardParameters.invitation, acceptInvitationRequired);
        }
        MemberDetailsConfig config = null;
        if (group.getDetailsForm() != null) {
            try {
                config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
            }
            catch (FoundationException ex) {
                res.setError(GeneratorStatus.SERVER_ERROR, (ErrorID)MemberErrorID.UNABLE_TO_CONFIGURE_MEMBER_DETAILS);
                return;
            }
        }
        if ((psrole = Role.forAttribute((String)role)) == null) {
            psrole = Role.forTitle((String)role);
        }
        if (role == null) {
            psrole = group.hasFlag('t') ? Role.CONTRIBUTOR : Role.REVIEWER;
        } else if (psrole == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.ILLEGAL_ROLE);
            return;
        }
        boolean isNewMember = false;
        boolean welcomeEmailFailed = false;
        String password = null;
        Member mem = null;
        if (email != null && !email.isEmpty()) {
            mem = DatabaseQuery.getMemberByEmail((Database)db, (String)email);
            if (mem != null && username != null && !username.equals(mem.getUsername())) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_EMAIL_DO_NOT_MATCH);
                return;
            }
        } else if (username != null) {
            mem = DatabaseQuery.getMemberByUsername((Database)db, (String)username);
        }
        boolean bl = memberHasEmail = mem != null && MemberRule.hasEmail((Member)mem) || mem == null && email != null && !email.isEmpty();
        if ((sendNewMemberNotification || acceptInvitationRequired) && !memberHasEmail) {
            String msg = sendNewMemberNotification ? "Cannot send welcome email as member has no email" : "Cannot invite member with no email";
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_HAS_NO_EMAIL, msg);
            return;
        }
        if (mem == null) {
            long nbMembers;
            if (!Members.checkEmailUsername(email, username, null, false, req.getDatabase(), res)) {
                return;
            }
            String max_mem = GlobalSettings.getString((String)"members", (String)"unlimited");
            if (!"unlimited".equals(max_mem) && (nbMembers = DatabaseQuery.getNumberMembers((Database)db).longValue()) >= (long)Integer.parseInt(max_mem)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MORE_MEMBERS);
                return;
            }
            mem = Member.create((Database)db);
            Date now = new Date();
            mem.setCreated(now);
            mem.setFirstName(first_name);
            mem.setSurname(surname);
            mem.setEmail(Strings.isEmpty((String)email) ? "No Email" : email);
            mem.setUsername(Strings.isEmpty((String)username) ? email : username);
            password = RuleUtils.generatePassword();
            try {
                mem.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
            }
            catch (FoundationException e) {
                throw new GeneratorException((Throwable)e);
            }
            if (autoActivate) {
                mem.setActivated(now);
            } else {
                mem.setSubmitPref("up");
            }
            mem = mem.insert(db);
            isNewMember = true;
        }
        if (GroupRule.isPersonalGroup((String)group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_IN_PERSONAL_GROUP);
            return;
        }
        Notification notify = Notification.forType((String)notification);
        if (notify == null) {
            String flags = group.getFlags();
            notify = Notification.forFlags((String)flags);
        }
        if ((mfg = DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)group.getId(), (Long)mem.getId())) != null) {
            if (!MemberForGroupRule.isDeletedMember((MemberForGroup)mfg)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_ALREADY_IN_GROUP);
                return;
            }
        } else {
            mfg = MemberForGroup.create((Database)db);
        }
        mfg.setNotification(notify.type());
        mfg.setListed(Boolean.valueOf(listed));
        mfg.setMember(mem);
        mfg.setEditorFlags(psrole.getFlags());
        mfg.setEditor(Boolean.valueOf(psrole.isEditor()));
        if (psrole == Role.MODERATOR || psrole == Role.MODERATOR_AND_APPROVER) {
            MemberForGroup moderator = Memberships.findModerator(group, db);
            if (moderator != null && !moderator.getId().equals(mfg.getId())) {
                Memberships.removeAsModerator(moderator, db);
            }
            if (mfg.getModerator() == null) {
                Memberships.setAsModerator(mfg, db);
            }
        }
        group.addMembersForGroup(mfg);
        MemberGroupDetails mgd = null;
        if (config != null) {
            List details = MemberGroupDetailsRule.toFieldValues((GeneratorRequest)req);
            mgd = MemberGroupDetailsRule.updateDetails((Database)db, (Member)mem, (List)details, (Group)group, (MemberForGroup)mfg, (boolean)true);
            mfg.setMemberGroupDetails(mgd);
        }
        if (acceptInvitationRequired) {
            mfg.setEditorFlags(Flags.add((String)Flags.add((String)mfg.getEditorFlags(), (char)'d'), (char)'n'));
        } else {
            new UserDetailsManager().remove(mem.getId());
        }
        mfg.insert(db);
        if (sendNewMemberNotification && memberHasEmail) {
            Member inviter = req.getAuthenticatedMember();
            try {
                if (isNewMember || !MemberRule.isMemberActivated((Member)mem)) {
                    Emails.sendNewMembershipMember((Database)db, (MemberForGroup)mfg, (Member)inviter, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                } else if (acceptInvitationRequired) {
                    Emails.sendMembershipConfirm((Database)db, (MemberForGroup)mfg, (Member)inviter, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                } else {
                    Emails.sendMembershipComplete((Database)db, (MemberForGroup)mfg, (Member)inviter, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
            }
            catch (EmailException ex) {
                welcomeEmailFailed = true;
                req.getLogger((Object)this).error("Failed to send new member email", (Throwable)ex);
            }
        }
        req.getTransaction().commit();
        if (isNewMember) {
            ChangesManager.getInstance().createMember(db, mem);
        }
        ChangesManager.getInstance().createMembership(db, mfg);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("membership-creation");
        if (isNewMember) {
            out.field("member-created", true);
        }
        if (welcomeEmailFailed) {
            out.field("welcome-email-failed", true);
        }
        out.writeMembership(new Membership(mfg), config, MemberDetailsConfig.Visibility.MANAGER, db);
        out.endObject();
        out.flush();
    }
}

