/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.Notification;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Role;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.ArrayList;

@Requires(database=true, group=true, parameters={"data"})
@Output(types={OutputType.JSON, OutputType.XML})
public final class ImportGroupMembers
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Database db = req.getDatabase();
        Transaction tr = req.getTransaction();
        Group group = req.getGroup();
        if ("admin".equals(group.getName())) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.GROUP_NOT_ALLOWED);
            return;
        }
        String data = req.getParameter((Parameter)StandardParameters.data);
        boolean createpersonal = req.getParameter((Parameter)StandardParameters.createpersonal, false);
        String notification = req.getParameter((Parameter)StandardParameters.notification);
        String role = req.getParameter((Parameter)StandardParameters.role);
        boolean listed = req.getParameter((Parameter)StandardParameters.listed, false);
        Role psrole = Role.forAttribute((String)role);
        if (role == null) {
            psrole = group.hasFlag('t') ? Role.CONTRIBUTOR : Role.REVIEWER;
        } else if (psrole == null || psrole == Role.MODERATOR || psrole == Role.MODERATOR_AND_APPROVER) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Role not supported: " + role);
            tr.abort();
            return;
        }
        Notification notify = Notification.forType((String)notification);
        if (notification == null) {
            notify = Notification.forFlags((String)group.getFlags());
        } else if (notify == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Notification not supported: " + notification);
            tr.abort();
            return;
        }
        ArrayList<Members.MemberDetails> created = new ArrayList<Members.MemberDetails>();
        ArrayList<Members.MemberDetails> existing = new ArrayList<Members.MemberDetails>();
        ArrayList<Members.MemberDetails> failed = new ArrayList<Members.MemberDetails>();
        try {
            Members.importMembers(db, tr, data, createpersonal, group, psrole, notify, listed, created, existing, failed);
        }
        catch (Exception ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("members-import");
        out.startCollection("imports", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Members.MemberDetails md : created) {
            md.toUniversal(out, "created");
        }
        for (Members.MemberDetails md : existing) {
            md.toUniversal(out, "existing");
        }
        for (Members.MemberDetails md : failed) {
            md.toUniversal(out, "error");
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

