/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.membership;

import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.membership.Memberships;
import java.io.IOException;

@Requires(database=true, member=true, group=true)
@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class DeleteMembership
implements Generator,
SingleCheck {
    @ContentPermission(value=EditGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new EditGroupCheck(req.getGroup());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Member member = req.getMember();
        Database db = req.getDatabase();
        Group group = req.getGroup();
        MemberForGroup mfg = Memberships.getMemberForGroup(member, group);
        if (mfg == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NOT_A_MEMBER, "User '" + member.getUsername() + "' is not a member of " + group.getName());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("membership-delete");
        out.writeMembership(new Membership(mfg), UniversalPrinter.MembershipFormatOption.GROUP_AND_MEMBER, null, MemberDetailsConfig.Visibility.MANAGER, db);
        out.endObject();
        Long mfgid = mfg.getId();
        mfg.delete(req.getDatabase());
        req.getTransaction().commit();
        ChangesManager.getInstance().deleteMembership(req.getDatabase(), mfgid, group);
        out.flush();
        new UserDetailsManager().remove(member.getId());
    }
}

