/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AuthenticatedInternalCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.util.Map;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class SelfMember
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AuthenticatedInternalCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Member mem = req.getAuthenticatedMember();
        UserDetailsManager user_manager = new UserDetailsManager();
        UserDetails userdetails = user_manager.get(req.getDatabase(), mem.getId());
        boolean admin = MemberRule.isAdministrator((Map)userdetails.flags());
        UniversalPrinter out = res.getUniversalWriter();
        out.writeMember(mem, true, true, "member", null, admin);
        out.flush();
    }
}

