/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.mail.EmailException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.security.AccountLockout;
import com.pageseeder.base.security.IdentityConfig;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.db.util.Flags;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class ResetPassword
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResetPassword.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if (req.getParameter((Parameter)StandardParameters.admin, false)) {
            return new ManageAccountCheck();
        }
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Collection members;
        Member member;
        Database db = req.getDatabase();
        String email = req.getParameter((Parameter)StandardParameters.email, "");
        String username = req.getParameter((Parameter)StandardParameters.member_username, "");
        String tokenString = req.getParameter((Parameter)StandardParameters.token);
        String password = req.getParameter((Parameter)StandardParameters.member_password);
        boolean adminChangingAnotherMember = req.getParameter((Parameter)StandardParameters.admin, false);
        if (username.isEmpty() && email.isEmpty()) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.USERNAME_OR_EMAIL_REQUIRED);
            return;
        }
        if (!email.isEmpty()) {
            if (!Emails.isAddress((String)email)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.INVALID_EMAIL);
                return;
            }
            IdentityConfig identityConfig = SecurityUtils.getIdentityConfig();
            if (!identityConfig.allowsPasswordForEmail(email)) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.EXTERNAL_EMAIL_DOMAIN);
                return;
            }
        }
        Member member2 = member = (members = DatabaseQuery.getMembersByUsernameEmailNameList((Database)db, (int)1, (int)1, (String)username, (String)email, (String)"", (String)"")).isEmpty() ? null : (Member)members.iterator().next();
        if (member == null) {
            ResetPassword.logResetPassword(username, email);
            if (adminChangingAnotherMember) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.NO_MATCHING_MEMBER);
            } else {
                this.badAccount(tokenString, res);
            }
            return;
        }
        if (SecurityUtils.checkApiAccount((String)member.getUsername())) {
            ResetPassword.logResetPassword(member);
            if (adminChangingAnotherMember) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.API_ACCOUNT);
            } else {
                this.badAccount(tokenString, res);
            }
            return;
        }
        if (!adminChangingAnotherMember && (AccountLockout.isResetPasswordLocked((String)member.getEmail()) || AccountLockout.isResetPasswordLocked((String)member.getUsername()))) {
            ResetPassword.logResetPassword(member);
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.RESET_PASSWORD_LOCKED);
            return;
        }
        if ("No Email".equals(member.getEmail())) {
            ResetPassword.logResetPassword(member);
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.MEMBER_HAS_NO_EMAIL);
            return;
        }
        if (tokenString == null && password == null) {
            ResetPassword.logResetPassword(member);
            try {
                if (!MemberRule.isMemberActivated((Member)member)) {
                    String newPwd = RuleUtils.generatePassword((int)12);
                    member.setSubmitPref(Flags.add((String)member.getSubmitPref(), (char)'p'));
                    member.setPassword(SecurityUtils.encodeAndSaltPassword((String)newPwd));
                    Member from = adminChangingAnotherMember ? req.getAuthenticatedMember() : null;
                    Emails.sendNewMember((Database)db, (Member)member, (Group)req.getGroup(), (Member)from, (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                } else {
                    HttpServletRequest hreq = req.getHttpServletRequest();
                    Emails.ResetReason reason = adminChangingAnotherMember ? Emails.ResetReason.ADMIN : Emails.ResetReason.MEMBER;
                    Emails.sendResetPasswordEmail((Database)db, (Group)req.getGroup(), (Member)member, (Emails.ResetReason)reason, (String)(hreq == null ? null : hreq.getHeader("User-Agent")), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
                }
            }
            catch (EmailException ex) {
                LOGGER.error("Failed to send reset password confirmation email", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to send reset password confirmation email: " + ex.getMessage());
                return;
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to generate reset password key", (Throwable)ex);
                res.setError(GeneratorStatus.SERVER_ERROR, "Failed to generate reset password key: " + ex.getMessage());
                return;
            }
            this.printResponse(res, "request-successful");
            return;
        }
        PersistentToken token = null;
        if (!adminChangingAnotherMember) {
            if (tokenString != null) {
                token = OAuthQuery.getPersistentToken((Database)db, (String)tokenString, (Member)member);
                if (token == null || !token.hasPurpose(PersistentToken.Purpose.reset_password) || token.hasExpired()) {
                    if (token == null) {
                        AccountLockout.badResetPassword((String)member.getUsername());
                        AccountLockout.badResetPassword((String)member.getEmail());
                    }
                    res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID);
                    return;
                }
            } else {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID, "Token must be specified");
                return;
            }
        }
        if (!Members.checkPassword(password, MemberRule.isAdministrator((Database)db, (Member)member), res)) {
            return;
        }
        try {
            member.setPassword(SecurityUtils.encodeAndSaltPassword((String)password));
            member.setLastPasswordChange(new Date());
            member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'p'));
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to encode new password", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to encode new password: " + ex.getMessage());
            return;
        }
        AccountLockout.unlockLogin((String)member.getUsername());
        AccountLockout.unlockLogin((String)member.getEmail());
        if (token != null) {
            token.delete(db);
        }
        try {
            Emails.sendPasswordChangeEmail((Database)db, (Member)member, (Group)req.getGroup(), (Boolean)Emails.getNotifyAsyncParameter((GeneratorRequest)req));
        }
        catch (EmailException ex) {
            LOGGER.error("Failed to send generate password changed email", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to send generate password changed email: " + ex.getMessage());
            return;
        }
        SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.PASSWORD_CHANGE, (String)"Password changed {}for {}", (Object[])new Object[]{adminChangingAnotherMember ? "by admin " : "", MemberRule.hasEmail((Member)member) ? member.getEmail() : member.getUsername()});
        this.printResponse(res, "password-changed");
        new MembershipCache().remove(member.getId());
    }

    private void badAccount(String token, GeneratorResponse res) throws IOException {
        try {
            Thread.sleep(100L + (long)(Math.random() * 500.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (token != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID);
        } else {
            this.printResponse(res, "request-successful");
        }
    }

    private void printResponse(GeneratorResponse res, String status) throws IOException {
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("reset-password");
        out.field("status", status);
        out.endObject();
        out.flush();
    }

    private static void logResetPassword(String username, String email) {
        LOGGER.info("Reset password requested for {}", (Object)(email == null ? username : email));
    }

    private static void logResetPassword(Member mem) {
        String user = "No Email".equals(mem.getEmail()) ? mem.getUsername() : mem.getEmail();
        LOGGER.info("Reset password requested for {}", (Object)user);
    }
}

