/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.cache.SafeCacheWrapper;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.DeleteFailedException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.display.CustomImage;
import com.pageseeder.display.DefaultProfilePicture;
import com.pageseeder.display.WebImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfilePictureServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfilePictureServlet.class);
    private static final long serialVersionUID = 20220921L;
    private static final String CACHE_NAME = "profile-pictures";
    private static SafeCacheWrapper<Long, WebImage> cache = SafeCacheWrapper.getInstance((String)"profile-pictures");

    public String getServletInfo() {
        return "Handles member profile picture.";
    }

    public static void clearCache() {
        try {
            cache.removeAll();
        }
        catch (Exception ex) {
            LOGGER.error("Unable to clear whole cache", (Throwable)ex);
        }
    }

    public static void clearCache(Long memberId) {
        try {
            cache.remove((Serializable)memberId);
        }
        catch (Exception ex) {
            LOGGER.error("Unable to clear cache for member " + memberId, (Throwable)ex);
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        WebRequest wreq;
        Long memberId;
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((memberId = (wreq = new WebRequest(req, res)).getLongParameter(StandardParameters.member_id.getName(), false, Long.valueOf(-1L))) == -1L) {
            String name = wreq.getParameter(StandardParameters.name.getName());
            DefaultProfilePicture image = DefaultProfilePicture.forName(name);
            res.setStatus(200);
            image.write(res);
            return;
        }
        long start = System.currentTimeMillis();
        WebImage image = (WebImage)cache.get((Serializable)memberId);
        if (image != null && !"no-cache".equals(req.getHeader("Cache-Control"))) {
            res.setHeader("Server-Timing", "cache;desc=hit;dur=" + (System.currentTimeMillis() - start));
            image.write(req, res);
            return;
        }
        try {
            Database db = Database.open();
            Transaction tr = new Transaction(db);
            Member member = DatabaseQuery.getMemberById((Database)db, (Long)memberId);
            if (member == null) {
                image = DefaultProfilePicture.forMemberId(memberId);
                res.setStatus(200);
                res.setHeader("Server-Timing", "cache;desc=miss,db;dur=" + (System.currentTimeMillis() - start));
                image.write(res);
                return;
            }
            image = this.fetchImage(member, db);
            if (image == null) {
                image = DefaultProfilePicture.forMember(member);
            }
            cache.put((Serializable)member.getId(), (Serializable)image);
            res.setStatus(200);
            res.setHeader("Server-Timing", "cache;desc=miss,db;dur=" + (System.currentTimeMillis() - start));
            image.write(req, res);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Unable to query DB for data member XLink", (Throwable)ex);
            image = DefaultProfilePicture.forName("E");
            res.setStatus(502);
            image.write(res);
        }
    }

    private CustomImage fetchImage(Member member, Database db) throws QueryFailedException, DeleteFailedException {
        XLink memberData;
        List memberDatas = DatabaseQuery.getXLinkMemberDataByTypeList((Database)db, (Long)member.getId(), (String)"public-picture");
        XLink xLink = memberData = !memberDatas.isEmpty() ? (XLink)memberDatas.get(0) : null;
        if (memberDatas.size() > 1) {
            for (int i = 1; i < memberDatas.size(); ++i) {
                XLink xl = (XLink)memberDatas.get(i);
                for (Content c : xl.getContentsCol()) {
                    c.delete(db);
                    c = null;
                }
                xl.delete(db);
            }
        }
        if (memberData == null) {
            return null;
        }
        Collection contents = memberData.getContentsCol();
        if (contents.isEmpty()) {
            return null;
        }
        Content content = (Content)contents.iterator().next();
        String mediatype = content.getType();
        byte[] data = content.getBinaryData();
        if (data != null) {
            long lastModified = ProfilePictureServlet.lastModified(memberData);
            return new CustomImage(data, mediatype, lastModified);
        }
        return null;
    }

    private static long lastModified(XLink memberData) {
        Date date = memberData.getModifiedDate();
        if (date == null) {
            date = memberData.getDate();
        }
        return date.getTime() / 1000L * 1000L;
    }
}

