/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.FrameworkErrorID;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.logback.AccessEvent;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.security.CSRF;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.util.ImageThumbnail;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.WebRequest;
import com.pageseeder.base.web.WebUtilities;
import com.pageseeder.common.http.HttpRequests;
import com.pageseeder.common.util.MD5;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.XLink;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.ProfilePictureServlet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

@Output(types={OutputType.XML, OutputType.JSON, OutputType.IMAGE})
@PublicAPI(value=PublicAPI.Support.UNSUPPORTED)
public final class MemberDataServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemberDataServlet.class);
    private static final long serialVersionUID = 1L;
    private static final Pattern PATH_PATTERN = Pattern.compile("^/(\\d{1,19})/data/(.*)$");
    private static final Pattern FILENAME_PATTERN = Pattern.compile("^([a-z0-9\\-_]+)\\.([a-z0-9]+)$");
    private static final Pattern VALID_TEXT_MEDIA_TYPE = Pattern.compile("^application/(.*\\+)?(xml|json)$");
    private static final int THUMBNAIL_SIDE_SIZE = 512;
    private static final int MAX_TEXT_LENGTH = 100000;
    private static final int MAX_IMAGE_LENGTH = 10000000;
    private static final int MAX_DATA_ALLOWED = 16;

    public String getServletInfo() {
        return "Handles member personal data.";
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.process(req, res);
    }

    public void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.process(req, res);
    }

    public void doDelete(HttpServletRequest req, HttpServletResponse res) throws IOException {
        this.process(req, res);
    }

    private void process(HttpServletRequest req, HttpServletResponse res) throws IOException {
        MemberDataRequest request;
        long start = System.currentTimeMillis();
        if (req.getCharacterEncoding() == null) {
            req.setCharacterEncoding("UTF-8");
        }
        if ((request = MemberDataServlet.toRequest(req, res)) == null) {
            return;
        }
        if (!CSRF.validateAntiCSRFToken((HttpServletRequest)req)) {
            res.sendError(419, "Missing correct CSRF token");
            return;
        }
        try {
            String method;
            XLink memberData;
            Database db = Database.open();
            Transaction tr = new Transaction(db);
            Member member = request.getMember(req, res, db);
            if (member == null) {
                return;
            }
            List memberDatas = DatabaseQuery.getXLinkMemberDataByTypeList((Database)db, (Long)member.getId(), (String)request.name);
            XLink xLink = memberData = memberDatas.size() > 0 ? (XLink)memberDatas.get(0) : null;
            if (memberDatas.size() > 1) {
                for (int i = 1; i < memberDatas.size(); ++i) {
                    XLink xl = (XLink)memberDatas.get(i);
                    for (Content c : xl.getContentsCol()) {
                        c.delete(db);
                        c = null;
                    }
                    xl.delete(db);
                }
            }
            if ("GET".equals(method = req.getMethod())) {
                if (memberData == null) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)404, (ErrorID)MemberErrorID.NO_MEMBER_DATA_FOUND);
                    return;
                }
                MemberDataServlet.output(memberData, req, res);
            } else if ("PUT".equals(method)) {
                String mediatype = request.getMediaType(req);
                String title = req.getParameter("title");
                if (!MemberDataServlet.isSupportedMediatype(mediatype)) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)415, (ErrorID)MemberErrorID.MEMBER_DATA_UNSUPPORTED_MEDIA_TYPE);
                    return;
                }
                if (!this.checkPreconditions(req, memberData)) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)412, (ErrorID)MemberErrorID.MEMBER_DATA_PRECONDITION_FAILED);
                    return;
                }
                tr.begin();
                if (memberData == null) {
                    Content data;
                    Long currentCount = DatabaseQuery.getXLinkMemberDataCount((Database)db, (Long)member.getId());
                    if (currentCount >= 16L) {
                        WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)MemberErrorID.MEMBER_DATA_QUOTA_REACHED);
                        return;
                    }
                    memberData = XLink.create((Database)db);
                    memberData.setDate(new Date());
                    memberData.setAccepted(Boolean.TRUE);
                    memberData.setModeratorOnly(Boolean.FALSE);
                    memberData.setContentRole("member-data");
                    memberData.setMember(member);
                    memberData.setType(request.name);
                    if (title != null) {
                        memberData.setContentTitle(title);
                    }
                    if (!MemberDataServlet.setContentData(data = Content.create((Database)db), mediatype, req, res, request.extension)) {
                        tr.abort();
                        return;
                    }
                    memberData.addContents(data);
                    data.insert(db);
                    memberData = memberData.insert(db);
                } else {
                    memberData.setModifiedDate(new Date());
                    Collection contents = memberData.getContentsCol();
                    if (contents.isEmpty()) {
                        Content data = Content.create((Database)db);
                        if (!MemberDataServlet.setContentData(data, mediatype, req, res, request.extension)) {
                            tr.abort();
                            return;
                        }
                        data.insert(db);
                        memberData.addContents(data);
                    } else if (!MemberDataServlet.setContentData((Content)contents.iterator().next(), mediatype, req, res, request.extension)) {
                        tr.abort();
                        return;
                    }
                }
                if (request.isPublicProfile()) {
                    ProfilePictureServlet.clearCache(member.getId());
                }
                tr.commit();
                MemberDataServlet.output(memberData, req, res);
            } else if ("DELETE".equals(method)) {
                if (memberData == null) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)404, (ErrorID)MemberErrorID.NO_MEMBER_DATA_FOUND);
                    return;
                }
                if (!this.checkPreconditions(req, memberData)) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)412, (ErrorID)MemberErrorID.MEMBER_DATA_PRECONDITION_FAILED);
                    return;
                }
                tr.begin();
                memberData.delete(db);
                if (request.isPublicProfile()) {
                    ProfilePictureServlet.clearCache(member.getId());
                }
                tr.commit();
                res.setStatus(204);
            }
            WebUtilities.logAccess((HttpServletRequest)req, (int)200, (String)"member-data", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
        }
        catch (DatabaseException ex) {
            LOGGER.error("Unable to query DB for data member XLink", (Throwable)ex);
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)502, (ErrorID)FrameworkErrorID.DATABASE_ERROR);
            WebUtilities.logAccess((HttpServletRequest)req, (int)502, (String)"member-data", (long)start, (AccessEvent.Permission)AccessEvent.Permission.MEMBER);
        }
    }

    private boolean checkPreconditions(HttpServletRequest req, XLink memberData) {
        String ifMatch = req.getHeader("If-Match");
        if (ifMatch != null) {
            return this.checkIfMatch(ifMatch.replaceFirst("W/", ""), memberData);
        }
        String ifNoneMatch = req.getHeader("If-None-Match");
        if (ifNoneMatch != null) {
            return this.checkIfNoneMatch(ifNoneMatch.replaceFirst("W/", ""), memberData);
        }
        long ifUnmodifiedSince = req.getDateHeader("If-Unmodified-Since");
        if (ifUnmodifiedSince > 0L) {
            return this.checkIfUnmodifiedSince(ifUnmodifiedSince, memberData);
        }
        return true;
    }

    private boolean checkIfMatch(String ifMatch, XLink memberData) {
        if ("*".equals(ifMatch)) {
            return memberData != null;
        }
        String etag = MemberDataServlet.etag(memberData);
        return ifMatch.equals(etag);
    }

    private boolean checkIfNoneMatch(String ifNoneMatch, XLink memberData) {
        if ("*".equals(ifNoneMatch)) {
            return memberData == null;
        }
        String etag = MemberDataServlet.etag(memberData);
        return !ifNoneMatch.equals(etag);
    }

    private boolean checkIfUnmodifiedSince(long unmodifiedSince, XLink memberData) {
        long lastModified = memberData != null ? MemberDataServlet.roundTime(MemberDataServlet.lastModified(memberData)) : 0L;
        return unmodifiedSince >= lastModified;
    }

    private static long lastModified(XLink memberData) {
        Date date = memberData.getModifiedDate();
        if (date == null) {
            date = memberData.getDate();
        }
        return date.getTime();
    }

    private static String etag(XLink memberData) {
        if (memberData == null) {
            return null;
        }
        String etag = MD5.hash((String)(memberData.getId() + 47L + memberData.getType() + "/" + MemberDataServlet.lastModified(memberData)));
        return "\"" + etag.substring(0, 8) + "\"";
    }

    private static MemberDataRequest toRequest(HttpServletRequest req, HttpServletResponse res) {
        Matcher matcher;
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        }
        if (!(matcher = PATH_PATTERN.matcher(pathInfo)).matches()) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)404, (ErrorID)FrameworkErrorID.SERVICE_NOT_FOUND);
            return null;
        }
        Long memberId = Long.parseLong(matcher.group(1));
        String filename = matcher.group(2);
        Matcher fileMatcher = FILENAME_PATTERN.matcher(filename);
        if (!fileMatcher.matches()) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)404, (ErrorID)MemberErrorID.INVALID_MEMBER_DATA_PATH);
            return null;
        }
        String name = fileMatcher.group(1);
        String extension = fileMatcher.group(2);
        if (name.length() >= 250) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)414, (ErrorID)MemberErrorID.MEMBER_DATA_TOO_LONG);
            return null;
        }
        return new MemberDataRequest(memberId, name, extension);
    }

    private static void output(XLink memberData, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (memberData == null) {
            return;
        }
        Collection contents = memberData.getContentsCol();
        if (contents.isEmpty()) {
            return;
        }
        Content content = (Content)contents.iterator().next();
        Object mediatype = content.getType();
        byte[] data = null;
        if (MemberDataServlet.isSupportedTextMediatype((String)mediatype)) {
            mediatype = (String)mediatype + "; charset=utf-8";
            data = content.getData().getBytes(StandardCharsets.UTF_8);
        } else if (MemberDataServlet.isSupportedImageMediatype((String)mediatype)) {
            data = content.getBinaryData();
        }
        if (data != null) {
            String etag = MemberDataServlet.etag(memberData);
            boolean isPublic = MemberDataServlet.isPublic(memberData.getType());
            long lastModified = MemberDataServlet.lastModified(memberData);
            boolean includeContent = true;
            String match = req.getHeader("If-None-Match");
            if (match != null) {
                if (etag.equals(match)) {
                    res.setStatus(304);
                    includeContent = false;
                }
            } else {
                long modifiedSince = req.getDateHeader("If-Modified-Since");
                if (modifiedSince != -1L && lastModified <= modifiedSince + 1000L) {
                    res.setStatus(304);
                    includeContent = false;
                }
            }
            res.setHeader("Cache-Control", isPublic ? "public, max-age=0" : "private, max-age=0");
            res.setDateHeader("Last-Modified", lastModified);
            res.setHeader("ETag", etag);
            res.setContentType((String)mediatype);
            if (includeContent) {
                res.getOutputStream().write(data);
            }
        }
    }

    private static boolean setContentData(Content data, String mediatype, HttpServletRequest req, HttpServletResponse res, String extension) throws IOException {
        data.setType(mediatype);
        if (MemberDataServlet.isSupportedTextMediatype(mediatype)) {
            String s;
            String encoding = req.getCharacterEncoding();
            if (encoding == null) {
                encoding = StandardCharsets.UTF_8.name();
            }
            if ((s = IOUtils.toString((InputStream)req.getInputStream(), (String)encoding)).length() > 100000) {
                LOGGER.debug("Refusing data member content with type {}: length is {}", (Object)mediatype, (Object)s.length());
                WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)413, (ErrorID)MemberErrorID.MEMBER_DATA_TOO_LARGE);
                return false;
            }
            String error = MemberDataServlet.validationError(s, mediatype);
            if (error != null) {
                LOGGER.debug("Refusing invalid data member content: {}", (Object)error);
                WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)MemberErrorID.MEMBER_DATA_INVALID, (String)("Member data is invalid: " + error));
                return false;
            }
            data.setData(s);
        } else if (MemberDataServlet.isSupportedImageMediatype(mediatype)) {
            byte[] image = MemberDataServlet.imageThumbnail(req, res);
            if (image == null) {
                return false;
            }
            data.setBinaryData(image);
        }
        return true;
    }

    private static byte[] imageThumbnail(HttpServletRequest req, HttpServletResponse res) {
        int length = req.getContentLength();
        if (length > 10000000) {
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)413, (ErrorID)MemberErrorID.MEMBER_DATA_TOO_LARGE);
            HttpRequests.consumeInputStream((HttpServletRequest)req);
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ServletInputStream in = req.getInputStream();){
            ImageThumbnail producer = new ImageThumbnail();
            producer.setHeight(512);
            producer.setWidth(512);
            producer.createThumbnail((InputStream)in, (OutputStream)out);
        }
        catch (Exception ex) {
            LOGGER.error("Failed to generate thumbnail for image", (Throwable)ex);
            WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)400, (ErrorID)MemberErrorID.MEMBER_DATA_IMAGE_ERROR);
            return null;
        }
        return out.toByteArray();
    }

    private static boolean isSupportedMediatype(String mediaType) {
        return MemberDataServlet.isSupportedTextMediatype(mediaType) || MemberDataServlet.isSupportedImageMediatype(mediaType);
    }

    private static boolean isSupportedTextMediatype(String mediaType) {
        return mediaType != null && VALID_TEXT_MEDIA_TYPE.matcher(mediaType).matches();
    }

    private static boolean isSupportedImageMediatype(String mediaType) {
        return "image/jpeg".equals(mediaType) || "image/png".equals(mediaType);
    }

    private static boolean isPublic(String name) {
        return name.startsWith("public-");
    }

    private static long roundTime(long time) {
        return time * 1000L / 1000L;
    }

    private static String validationError(String data, String mediatype) {
        if (mediatype != null && mediatype.endsWith("xml")) {
            List errors = null;
            try {
                errors = XMLHelpers.validateWellFormednessReturnErrors((String)data);
            }
            catch (IOException | SAXException ex) {
                LOGGER.error("Failed to validate data \"{}\" with mediatype {}", new Object[]{data, mediatype, ex});
                return "Failed to validate data: " + ex.getMessage();
            }
            return errors.isEmpty() ? null : (String)errors.get(0);
        }
        if (mediatype != null && mediatype.endsWith("json")) {
            try {
                new ObjectMapper().readTree(data);
            }
            catch (IOException ex) {
                return ex.getMessage();
            }
        }
        return null;
    }

    private static class MemberDataRequest {
        public final Long memberId;
        public final String name;
        public final String extension;

        MemberDataRequest(Long memberId, String name, String extension) {
            this.memberId = memberId;
            this.name = name;
            this.extension = extension;
        }

        boolean isPublicProfile() {
            return "public-picture".equals(this.name);
        }

        Member getMember(HttpServletRequest req, HttpServletResponse res, Database db) {
            try {
                NoCheck check;
                Member m = DatabaseQuery.getMemberById((Database)db, (Long)this.memberId);
                if (m == null) {
                    WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)404, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
                    return null;
                }
                Permissions perm = new Permissions();
                boolean isPublicRead = MemberDataServlet.isPublic(this.name) && "GET".equals(req.getMethod());
                Object object = check = isPublicRead ? new NoCheck() : new ViewMemberCheck(m);
                if (!PermissionManager.check((HttpServletRequest)req, (Database)db, (Permissions)perm, (PermissionCheck)check)) {
                    if (perm.isLoggedIn()) {
                        WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)403, (ErrorID)FrameworkErrorID.FAILED_PERMISSION_CHECK, (String)"Access forbidden");
                    } else {
                        WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)401, (ErrorID)FrameworkErrorID.FAILED_PERMISSION_CHECK, (String)"Unauthorized access");
                    }
                    return null;
                }
                return m;
            }
            catch (QueryFailedException ex) {
                LOGGER.error("Unable to find member with ID {}", (Object)this.memberId, (Object)ex);
                WebRequest.sendError((HttpServletRequest)req, (HttpServletResponse)res, (int)502, (ErrorID)FrameworkErrorID.DATABASE_ERROR);
                return null;
            }
        }

        String getMediaType(HttpServletRequest req) {
            String mediatype = req.getContentType();
            if (mediatype != null && mediatype.indexOf(59) >= 0) {
                mediatype = mediatype.substring(0, mediatype.indexOf(59)).trim();
            }
            if (mediatype == null) {
                mediatype = Medias.getMediaType((String)this.extension);
            }
            if ("text/xml".equals(mediatype)) {
                return "application/xml";
            }
            return mediatype;
        }
    }
}

