/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.security.SecurityUtils;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import java.io.IOException;
import org.pageseeder.smith.PasswordConfig;
import org.pageseeder.smith.PasswordMeter;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true, parameters={"member-password"})
@PublicAPI
public final class GetPasswordStrength
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String password = req.getParameter((Parameter)StandardParameters.member_password, "");
        PasswordConfig config = SecurityUtils.getPasswordConfig();
        PasswordMeter meter = new PasswordMeter(config);
        int score = meter.score(password);
        String level = config.getLevel(score);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("password-meter");
        out.field("level", level);
        out.field("score", (long)score);
        out.endObject();
        out.flush();
    }
}

