/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.permission.ViewMembersCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
@PublicAPI
public final class GetMember
implements Generator,
SingleCheck {
    @ContentPermission(value=ViewMembersCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        Member mem;
        String token = req.getParameter((Parameter)StandardParameters.token);
        try {
            mem = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            return new NoCheck();
        }
        if (token != null && mem != null) {
            return new NoCheck();
        }
        return new ViewMemberCheck(mem);
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        PersistentToken token;
        Member mem;
        try {
            mem = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load member from DB");
            return;
        }
        if (mem == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        String tokenString = req.getParameter((Parameter)StandardParameters.token);
        boolean admin = false;
        if (tokenString != null && ((token = OAuthQuery.getPersistentToken((Database)req.getDatabase(), (String)tokenString, (Member)mem)) == null || token.hasExpired() || !token.hasPurpose(PersistentToken.Purpose.activate_member) && !token.hasPurpose(PersistentToken.Purpose.reset_password))) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID);
            return;
        }
        if (tokenString != null || req.getAuthenticatedMember() != null && MemberRule.isAdministrator((Database)req.getDatabase(), (Member)req.getAuthenticatedMember())) {
            admin = MemberRule.isAdministrator((Database)req.getDatabase(), (Member)mem);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.writeMember(mem, true, true, "member", null, admin);
        out.flush();
    }
}

