/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import java.io.IOException;
import java.util.List;

@Requires(database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class FindMembers
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        boolean ignoreGrp = req.getParameter((Parameter)StandardParameters.ignore_group, false);
        boolean extendedmember = req.getParameter((Parameter)StandardParameters.extendedmember, false);
        if (req.getGroup() != null && !extendedmember && !ignoreGrp) {
            return new EditGroupCheck(req.getGroup());
        }
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        List members;
        Database db = req.getDatabase();
        Group group = req.getGroup();
        int pagesize = (int)req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        int page = (int)req.getParameter((Parameter)StandardParameters.page, 1L);
        String prefix = req.getParameter((Parameter)StandardParameters.prefix, "");
        String emaildomain = req.getParameter((Parameter)StandardParameters.emaildomain, "");
        String status = req.getParameter((Parameter)StandardParameters.status, "");
        boolean ignoreGrp = req.getParameter((Parameter)StandardParameters.ignore_group, false);
        boolean extendedmember = req.getParameter((Parameter)StandardParameters.extendedmember, false);
        if (prefix.isEmpty()) {
            prefix = null;
        }
        if (emaildomain.isEmpty()) {
            emaildomain = null;
        }
        if (status.isEmpty()) {
            status = null;
        }
        if (group == null || ignoreGrp) {
            try {
                members = DatabaseQuery.getMembersByPrefixDomain((Database)db, (int)page, (int)pagesize, (String)prefix, (String)emaildomain, (String)status, (boolean)true);
            }
            catch (IllegalArgumentException ex) {
                res.setError(GeneratorStatus.BAD_REQUEST, ex.getMessage());
                return;
            }
        } else {
            String topProject = GroupRule.getTopProjectName((Group)group);
            members = DatabaseQuery.getMembersByPrefixDomainProject((Database)db, (int)page, (int)pagesize, (String)prefix, (String)emaildomain, (String)topProject, (boolean)true);
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("members");
        if (members.size() > pagesize) {
            out.field("limitreached", true);
        }
        out.startCollection("members", OutputPrinter.CollectionOption.JSON_ONLY);
        int nb = 0;
        for (Member m : members) {
            if (nb < pagesize) {
                out.writeMember(m, true, extendedmember, "member", null, extendedmember ? MemberRule.isAdministrator((Database)db, (Member)m) : false);
            }
            ++nb;
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

