/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewGroupCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.psml.Structure;
import com.pageseeder.xref.XRefException;
import com.pageseeder.xref.XRefMediator;
import java.io.IOException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(member=true, database=true)
@Output(types={OutputType.JSON, OutputType.XML})
public final class CreatePersonalGroup
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreatePersonalGroup.class);

    @ContentPermission(value=ViewGroupCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        boolean createdocuments = req.getParameter((Parameter)StandardParameters.createdocuments, true);
        String commenting = req.getParameter((Parameter)StandardParameters.commenting, "reviewer");
        if (!("public".equals(commenting) || "reviewer".equals(commenting) || "contributor".equals(commenting))) {
            res.setError(GeneratorStatus.BAD_REQUEST, "The commenting must be 'public','reviewer' or 'contributor'");
            return;
        }
        Member member = req.getMember();
        Database db = req.getDatabase();
        Group members = GroupRule.getMemberProject((Database)db);
        Group project = GroupRule.createMemberPersonalProject((Database)db, (Member)member, (Group)members);
        Group grp = GroupRule.getMemberPersonalGroup((Database)db, (Member)member);
        if (grp == null) {
            grp = GroupRule.createMemberPersonalGroup((Database)db, (Member)member, (Group)project, (String)commenting);
            GroupURI guri = GroupURIRule.getDefaultGroupURI((Group)grp);
            Collection created = null;
            if (guri != null) {
                if (createdocuments) {
                    try {
                        created = GroupRule.createDefaultDocuments((Group)grp, (Member)member, (Database)db);
                    }
                    catch (FoundationException ex) {
                        LOGGER.error("Failed to create default documents", (Throwable)ex);
                    }
                }
                if (created != null) {
                    for (URI uri : created) {
                        if (!URIRule.isPSML((URI)uri)) continue;
                        XRefMediator mediator = new XRefMediator(grp, uri, member, uri.getDateCreated(), db);
                        mediator.setCreateEdit(true);
                        mediator.setFailOnFirstError(false);
                        mediator.setBuildStructure(true);
                        try (InternalURIFetcher fetcher = new InternalURIFetcher(uri, null);){
                            mediator.mediateNewDocument(fetcher.getContent());
                        }
                        catch (URIException ex) {
                            LOGGER.error("Unable to fetch document", (Throwable)ex);
                        }
                        catch (XRefException ex) {
                            LOGGER.error("Unable to resolve xrefs", (Throwable)ex);
                        }
                        try {
                            Structure.createStructureXLink(mediator.getStructureXML(), uri, grp, member, uri.getDateCreated(), "Document Create", db);
                        }
                        catch (DatabaseException ex) {
                            LOGGER.error("Failed to create structure in DB", (Throwable)ex);
                        }
                    }
                }
                req.getTransaction().commitAndStart();
                ChangesManager changes = ChangesManager.getInstance();
                changes.createGroup(db, grp);
                if (created != null) {
                    for (URI uri : created) {
                        changes.createURI(db, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
                    }
                }
                new UserDetailsManager().remove(member.getId());
            }
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.writeGroup(grp, true, true, true, false);
        out.flush();
    }
}

