/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.ForbiddenCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.oauth.OAuthQuery;
import com.pageseeder.db.oauth.PersistentToken;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true, parameters={"username"})
@PublicAPI
public final class CheckUsername
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckUsername.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws QueryFailedException {
        String tokenString = req.getParameter((Parameter)StandardParameters.token);
        if (tokenString != null && req.getMember() != null) {
            PersistentToken token = OAuthQuery.getPersistentToken((Database)req.getDatabase(), (String)tokenString, (Member)req.getMember());
            if (token == null || token.hasExpired() || !token.hasPurpose(PersistentToken.Purpose.activate_member)) {
                return new ForbiddenCheck();
            }
            return new NoCheck();
        }
        if (tokenString == null) {
            return new ManageAccountCheck();
        }
        return new ForbiddenCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException, DatabaseException {
        Member mem = req.getMember();
        if (mem == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)MemberErrorID.TOKEN_INVALID);
            return;
        }
        Member m = null;
        boolean valid = true;
        String username = req.getParameter((Parameter)StandardParameters.username);
        if (username.length() > 0) {
            if (username.length() > 100) {
                valid = false;
            } else if (!Members.USERNAME.matcher(username).matches()) {
                valid = false;
            }
            m = DatabaseQuery.getMemberByUsername((Database)req.getDatabase(), (String)username);
        } else {
            valid = false;
        }
        LOGGER.warn("Username check by {} for username: {}", (Object)mem.getUsername(), (Object)username);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("username-check");
        out.field("usedby", m == null ? "none" : (m.equals((Object)mem) ? "current" : "other"));
        out.field("valid", valid);
        out.endObject();
        out.flush();
    }
}

