/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.member;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.SecurityLog;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.ManageAccountCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.MembershipCache;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.util.Flags;
import java.io.IOException;
import java.util.Date;

@Output(types={OutputType.JSON, OutputType.XML})
@Requires(database=true, member=true)
@PublicAPI
public final class ActivateMember
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ManageAccountCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Member member = req.getMember();
        boolean alreadyActive = true;
        if (!MemberRule.isMemberActivated((Member)member)) {
            alreadyActive = false;
            member.setSubmitPref(Flags.remove((String)member.getSubmitPref(), (char)'u'));
            member.setActivated(new Date());
            SecurityLog.info((SecurityLog.EventType)SecurityLog.EventType.ACCOUNT_CHANGE, (String)"Member {} ({}) was activated", (Object[])new Object[]{member.getUsername(), member.getId()});
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("member-activation");
        if (alreadyActive) {
            out.field("already-activated", true);
        }
        out.writeMember(member);
        out.endObject();
        out.flush();
        new MembershipCache().remove(member.getId());
    }
}

