/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.mail.EmailSender;
import com.pageseeder.base.mail.EmailTemplate;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Map;
import javax.xml.transform.TransformerException;
import org.pageseeder.xmlwriter.XML;
import org.pageseeder.xmlwriter.XMLStringWriter;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, parameters={"template", "content"})
public class PreviewEmail
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String textOutput;
        String content = req.getParameter((Parameter)StandardParameters.content);
        String templateName = req.getParameter((Parameter)StandardParameters.template);
        String subject = req.getParameter((Parameter)StandardParameters.subject);
        boolean defaultTemplates = req.getParameter((Parameter)StandardParameters.default_, false);
        EmailTemplate template = EmailTemplate.forFilename((String)templateName);
        if (template == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Unknown template: " + templateName);
            return;
        }
        if (req.getParameter((Parameter)StandardParameters.clear_cache, false)) {
            EmailSender.clearCache();
        }
        EmailSender builder = new EmailSender(template);
        builder.setXMLSource(content, true, defaultTemplates);
        try {
            builder.createContent(null, req.getGroup());
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to create email content (" + ex.getMessage() + ")");
        }
        catch (TransformerException ex) {
            XMLWriter xml = res.getXMLWriter();
            xml.writeXML(this.failedTransform(ex));
            res.setStatus(GeneratorStatus.SERVER_ERROR);
            return;
        }
        builder.setFromTemplate(template, req.getMember());
        builder.setDefaultHeaders(req.getDatabase(), req.getGroup());
        builder.setHeadersFromContent(subject);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("email-preview");
        xml.openElement("headers", true);
        Collection recipientTos = builder.getRecipientTos();
        if (!recipientTos.isEmpty()) {
            xml.openElement("header");
            xml.attribute("name", "To");
            Object tos = "";
            for (String email : recipientTos) {
                tos = (String)tos + email + " ,";
            }
            xml.attribute("value", (String)tos);
            xml.closeElement();
        }
        Map headers = builder.getHeaders();
        for (Map.Entry header : headers.entrySet()) {
            xml.openElement("header");
            xml.attribute("name", (String)header.getKey());
            xml.attribute("value", (String)header.getValue());
            xml.closeElement();
        }
        xml.closeElement();
        String htmlOutput = builder.getHTMLContent();
        if (htmlOutput != null) {
            xml.openElement("output", true);
            xml.attribute("format", "html");
            StringBuffer html = new StringBuffer(htmlOutput);
            html = XMLUtils.removeDoctypes((StringBuffer)html);
            xml.writeXML(html.toString());
            xml.closeElement();
        }
        if ((textOutput = builder.getTextContent()) != null) {
            xml.openElement("output", true);
            xml.attribute("format", "text");
            xml.writeText(textOutput);
            xml.closeElement();
        }
        xml.closeElement();
    }

    private String failedTransform(TransformerException ex) {
        XMLStringWriter error = new XMLStringWriter(XML.NamespaceAware.No);
        error.openElement("error");
        error.attribute("type", "xslt");
        error.element("location", ex.getLocationAsString());
        error.element("message", ex.getMessageAndLocation());
        StringWriter st = new StringWriter();
        ex.printStackTrace(new PrintWriter(st));
        error.element("stacktrace", st.toString());
        error.closeElement();
        return error.toString();
    }
}

