/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.mail;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.logback.MailLogHandler;
import com.pageseeder.base.mail.MailLogger;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.util.ISO8601;
import com.pageseeder.db.QueryFailedException;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import org.pageseeder.xmlwriter.XMLWriter;
import org.xml.sax.SAXException;

@PublicAPI
public final class GetDailyLog
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws QueryFailedException {
        return new AdminSystemCheck(req.getHttpServletRequest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        Date date;
        String dateStr = req.getParameter((Parameter)StandardParameters.date);
        long page = req.getParameter((Parameter)StandardParameters.page, 1L);
        long pagesize = req.getParameter((Parameter)StandardParameters.pagesize, 1000L);
        try {
            date = ISO8601.parseAuto((String)dateStr);
        }
        catch (ParseException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid date parameter");
            return;
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("mail-logs");
        try {
            MailLogHandler.parseDayLogs((Date)date, (XMLWriter)xml, (long)page, (long)pagesize);
            MailLogger.logBounces((XMLWriter)xml);
        }
        catch (ParserConfigurationException | SAXException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to parse logs");
        }
        finally {
            xml.closeElement();
        }
    }
}

