/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.generators;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.model.Member;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.load.UnzipThread;
import java.io.IOException;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, member=true, parameters={"path"})
public final class LoadingZoneUnzip
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        boolean isAdministrator;
        String uploadid;
        try {
            uploadid = LoadingZone.getUploadID(req, res);
            if (uploadid != null && uploadid.isEmpty()) {
                return;
            }
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load upload ID: " + ex.getMessage());
            return;
        }
        LoadingZone zone = new LoadingZone(req.getGroup().getName(), req.getGroup().getOwnerDirectory(), req.getMember().getId(), uploadid);
        zone.loadExistingFiles();
        String path = req.getParameter((Parameter)StandardParameters.path);
        IncomingFile zip = zone.existingFile(path);
        if (!zip.exists()) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid zip file " + path);
            return;
        }
        try {
            isAdministrator = MemberRule.isAdministrator((Database)req.getDatabase(), (Member)req.getAuthenticatedMember());
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed check member permission: " + ex.getMessage());
            return;
        }
        UnzipThread thread = UnzipThread.newInstance(req.getMember().getUsername(), req.getGroup(), zip.getFile(), zone, isAdministrator);
        thread.setDeleteOriginal("true".equals(req.getParameter((Parameter)StandardParameters.deleteoriginal)));
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("load-unzip");
        thread.toXML(xml);
        xml.closeElement();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

