/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.generators;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.util.FileAttributes;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingZone;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(group=true, member=true)
public final class LoadingZoneClear
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new ViewMemberCheck(req.getMember(), (PermissionCheck)new EditURICheck(req.getGroup()));
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String uploadid;
        try {
            uploadid = LoadingZone.getUploadID(req, res);
            if (uploadid != null && uploadid.isEmpty()) {
                return;
            }
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load upload ID: " + ex.getMessage());
            return;
        }
        LoadingZone zone = new LoadingZone(req.getGroup().getName(), req.getGroup().getOwnerDirectory(), req.getMember().getId(), uploadid);
        zone.loadExistingFiles();
        int count = 0;
        for (IncomingFile incoming : zone.getIncomingFiles()) {
            boolean deleted = false;
            File file = incoming.getFile();
            if (file.exists()) {
                if (file.isDirectory()) {
                    deleted = FileUtils.deleteQuietly((File)file);
                    --count;
                } else {
                    deleted = FileUtils.deleteQuietly((File)file);
                    FileAttributes.clear((File)file);
                }
                if (!deleted) {
                    res.setError(GeneratorStatus.SERVER_ERROR, "Unable to delete this file: " + incoming.getPath());
                }
            }
            ++count;
        }
        for (IncomingFile incoming : zone.getMetadataFiles()) {
            File file = incoming.getFile();
            if (file.exists()) {
                if (file.isDirectory()) {
                    --count;
                }
                FileUtils.deleteQuietly((File)file);
            }
            ++count;
        }
        XMLWriter xml = res.getXMLWriter();
        xml.openElement("load-clear");
        xml.attribute("filesremoved", count);
        xml.closeElement();
        xml.flush();
    }
}

