/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.edits;

import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.LocatorRule;
import com.pageseeder.base.rule.URIFetcher;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.Immutable;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Locator;
import com.pageseeder.db.model.LocatorForXLink;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.Labels;
import com.pageseeder.db.util.ObjectProperties;
import com.pageseeder.load.edits.BackupFileURIFetcher;
import com.pageseeder.load.edits.Fragment;
import com.pageseeder.load.edits.PSMLFragmentMediatorHandler;
import com.pageseeder.url.URLCreator;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.berlioz.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class FragmentMediator {
    private static final String METADATA_FRAGMENT = "default";
    private static final String DOCUMENT_ORIGINAL_TITLE = "Document Original";
    private static final String DOCUMENTATION_ROLE = "Documentation";
    private static final String DOCUMENTATION_HIDDEN_ROLE = "Documentation-Hidden";
    private static final String DOCUMENTATION_ORIGINAL_ROLE = "Documentation-Original";
    private static final String DOCUMENT_OLD_STATUS = "Documentation-Old";
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentMediator.class);
    private final Group _group;
    private final URI _uri;
    private final File _backup;
    private final File _metadata;
    private final URL _uploadUrl;
    private final Member _author;
    private final @Nullable Member _originalAuthor;
    private final Database _database;
    private PSMLFragmentMediatorHandler newFragments;
    private PSMLFragmentMediatorHandler oldFragments;
    private boolean createXRefs = true;
    private boolean editMetadata = true;
    private final boolean existingURI;
    private boolean modified = false;
    private final Date _uriCreationDate;
    private final Date _editsCreationDate;
    private final List<String> errors = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();
    private final Set<Long> targetTranscludingUris = new HashSet<Long>();
    private final Set<Long> embedTargetUris = new HashSet<Long>();

    public FragmentMediator(Group grp, URI theuri, boolean existing, @Nullable Member origAuthor, File backupFile, File metadataFile, Member theauthor, URL uploadUrl, Database db) throws QueryFailedException {
        if (!URIRule.isPSML((URI)theuri) && metadataFile == null) {
            throw new IllegalArgumentException("Can only mediate PSML and metadata documents!");
        }
        this._group = GroupRule.getEditGroup((Database)db, (Group)grp, (URI)theuri);
        this._author = theauthor;
        this._originalAuthor = origAuthor;
        this._database = db;
        this._uri = theuri;
        this._uriCreationDate = this._uri.getDateCreated() == null ? new Date() : new Date(this._uri.getDateCreated().getTime());
        this._editsCreationDate = backupFile == null && !existing ? new Date(this._uriCreationDate.getTime()) : new Date();
        this._backup = backupFile;
        this.existingURI = existing;
        this._metadata = metadataFile;
        this._uploadUrl = uploadUrl;
    }

    public void setCreateXRefs(boolean create) {
        this.createXRefs = create;
    }

    public void setEditMetadata(boolean edit) {
        this.editMetadata = edit;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public List<String> getWarnings() {
        return this.warnings;
    }

    public Set<Long> getTargetTranscludingUris() {
        return this.targetTranscludingUris;
    }

    public Set<Long> getEmbedTargetUris() {
        return this.embedTargetUris;
    }

    public boolean mediateDocument() {
        if (this.existingURI) {
            this.loadExistingContents();
        }
        this.loadNewContent();
        if (this.createXRefs) {
            this.handleXRefs();
        }
        this.createEdits();
        if (this._backup != null && URIRule.isPSML((URI)this._uri)) {
            File newOne = new File(URIRule.getRealPath((String)this._uri.getPath()));
            FileUtils.deleteQuietly((File)newOne);
            try {
                FileUtils.moveFile((File)this._backup, (File)newOne);
            }
            catch (IOException ex) {
                this.errors.add("Failed to move backup to original location: " + ex.getMessage());
            }
        }
        this.newFragments = null;
        this.oldFragments = null;
        if (!this.errors.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Errors found while creating edits:");
            for (String err : this.errors) {
                LOGGER.debug(err);
            }
        }
        return this.modified;
    }

    private void loadNewContent() {
        try {
            URLCreator creator = null;
            if (this.createXRefs) {
                UserDetails userdetails = new UserDetailsManager().get(this._database, this._author.getId(), false);
                boolean uriOwner = PermissionManager.check((Long)this._author.getId(), (UserDetails)userdetails, (Database)this._database, (Permissions)new Permissions(), (PermissionCheck)new EditAllURLsCheck());
                creator = new URLCreator(this._author, uriOwner);
                creator.setTimeout(15000);
            }
            this.newFragments = new PSMLFragmentMediatorHandler(this._uri, this._database, creator, this._uploadUrl);
            if (URIRule.isPSML((URI)this._uri)) {
                List frags;
                File originalFile = new File(URIRule.getRealPath((String)this._uri.getPath()));
                this.newFragments.setBuildStructure();
                if (this.oldFragments != null) {
                    this.newFragments.setOldStructure(this.oldFragments.getStructureXML());
                }
                if ((frags = URIRule.loadFragments((URI)this._uri, (Group)this._group, (boolean)false, (Database)this._database)) != null) {
                    for (String frag : frags) {
                        this.newFragments.addExistingFragmentID(frag);
                    }
                }
                this.newFragments.parse(new FileInputStream(originalFile));
            } else {
                this.newFragments.parse(new FileInputStream(this._metadata));
            }
            this.errors.addAll(this.newFragments.getErrors());
            this.warnings.addAll(this.newFragments.getWarnings());
            for (Pair renamed : this.newFragments.getRenamedFragmentIDs()) {
                this.warnings.add("Fragment ID " + (String)renamed.first() + " was renamed to " + (String)renamed.second());
            }
        }
        catch (IOException | SAXException ex) {
            LOGGER.error("Failed to read the new PSML contents", (Throwable)ex);
            this.errors.add("Failed to read the new PSML contents: " + ex.getMessage());
        }
    }

    private void loadExistingContents() {
        this.oldFragments = new PSMLFragmentMediatorHandler(this._uri, this._database, null, this._uploadUrl);
        if (URIRule.isPSML((URI)this._uri)) {
            this.oldFragments.setBuildStructure();
        }
        try {
            DocumentContentResolver resolver = new DocumentContentResolver(this._uri.getId(), this._group.getName());
            if (this._backup != null) {
                resolver.setFetcher((URIFetcher)new BackupFileURIFetcher(this._backup));
            }
            resolver.setPSMLFormat(true);
            this.oldFragments.parse(resolver.getContent(this._database));
        }
        catch (URIException | IOException | SAXException ex) {
            LOGGER.error("Failed to read the previous XML contents", ex);
            this.errors.add("Failed to read the previous XML contents: " + ex.getMessage());
        }
        this.errors.addAll(this.oldFragments.getErrors());
    }

    private void createEdits() {
        for (String newFrag : this.newFragments.getFragments()) {
            if (this.existingURI && !this.editMetadata && newFrag.equals(METADATA_FRAGMENT)) continue;
            Fragment newOne = this.newFragments.getFragment(newFrag);
            Fragment oldOne = this.oldFragments == null ? null : this.oldFragments.getFragment(newFrag);
            String fragmentID = oldOne == null ? newOne.getFragment() : oldOne.getFragment();
            boolean existingContent = this._backup != null || this.existingURI;
            try {
                XLink xl;
                String[] labels;
                if (newOne.isDeleted() && oldOne != null && !oldOne.isDeleted()) continue;
                boolean canOverwrite = this.newFragments.allowsOverwrite(newOne);
                boolean canCreateNewFragments = this.newFragments.canCreateNewFragments();
                if (existingContent && !canOverwrite && !canCreateNewFragments) continue;
                if (existingContent && (canOverwrite || oldOne == null) && !this.matchContents(newOne, oldOne)) {
                    XLink xl2;
                    String contentType;
                    String content;
                    String role;
                    String[] labels2;
                    XLink lastEdit = DatabaseQuery.getXLinkByURIGroupLastEditFragmentDraftCreationBeforeStatusChangedAfter((Database)this._database, (URI)this._uri, (Group)this._group, (String)fragmentID, (boolean)true, (boolean)true, (boolean)true, null, null, null);
                    if (lastEdit == null && oldOne != null) {
                        labels2 = Strings.isEmpty((String)oldOne.getLabels()) ? null : oldOne.getLabels().split(",");
                        role = oldOne.isDeleted() ? DOCUMENTATION_HIDDEN_ROLE : DOCUMENTATION_ORIGINAL_ROLE;
                        content = oldOne.isDeleted() ? "Content Deleted" : oldOne.getContents().toString();
                        contentType = oldOne.isDeleted() ? "text/plain" : oldOne.getContentType();
                        xl2 = XLinkRule.createEditXLink((URI)this._uri, (String)fragmentID, (String)DOCUMENT_ORIGINAL_TITLE, (String)role, (String)DOCUMENT_OLD_STATUS, (boolean)true, (Group)this._group, null, (String[])labels2, (String)content, (String)contentType, (Member)this._originalAuthor, null, null, null, (Date)this._uriCreationDate, (Database)this._database);
                        this.addEditNotes(oldOne, xl2, this._uriCreationDate);
                    } else if (lastEdit != null) {
                        lastEdit.setStatus(DOCUMENT_OLD_STATUS);
                        if (DOCUMENT_ORIGINAL_TITLE.equals(lastEdit.getContentTitle())) {
                            lastEdit.setDate(this._uriCreationDate);
                        }
                    }
                    labels2 = Strings.isEmpty((String)newOne.getLabels()) ? null : newOne.getLabels().split(",");
                    role = newOne.isDeleted() ? DOCUMENTATION_HIDDEN_ROLE : DOCUMENTATION_ROLE;
                    content = newOne.isDeleted() ? "Content Deleted" : newOne.getContents().toString();
                    contentType = newOne.isDeleted() ? "text/plain" : newOne.getContentType();
                    xl2 = XLinkRule.createEditXLink((URI)this._uri, (String)fragmentID, (String)"Document Upload Change", (String)role, null, (boolean)false, (Group)this._group, null, (String[])labels2, (String)content, (String)contentType, (Date)this._editsCreationDate, (Member)this._author, (Database)this._database);
                    this.addEditNotes(newOne, xl2, this._editsCreationDate);
                    this.modified = true;
                    Locator loc = LocatorRule.getLocatorByURIFragment((Database)this._database, (URI)this._uri, (String)fragmentID);
                    List turis = DatabaseQuery.getURIsByLocatorTranscludedAllGroups((Database)this._database, (Locator)loc);
                    for (URI turi : turis) {
                        this.targetTranscludingUris.add(turi.getId());
                    }
                    continue;
                }
                if (!existingContent && (this.createXRefs && newOne.hasModifiedXRefs() || !URIRule.isPSML((URI)this._uri))) {
                    labels = Strings.isEmpty((String)newOne.getLabels()) ? null : newOne.getLabels().split(",");
                    xl = XLinkRule.createEditXLink((URI)this._uri, (String)fragmentID, (String)DOCUMENT_ORIGINAL_TITLE, (String)DOCUMENTATION_ORIGINAL_ROLE, null, (boolean)true, (Group)this._group, null, (String[])labels, (String)newOne.getContents().toString(), (String)newOne.getContentType(), (Member)this._originalAuthor, null, null, null, (Date)this._uriCreationDate, (Database)this._database);
                    this.addEditNotes(newOne, xl, this._uriCreationDate);
                    this.modified = true;
                    continue;
                }
                if (existingContent || !METADATA_FRAGMENT.equals(newFrag)) continue;
                labels = Strings.isEmpty((String)newOne.getLabels()) ? null : newOne.getLabels().split(",");
                xl = XLinkRule.createEditXLink((URI)this._uri, (String)fragmentID, (String)DOCUMENT_ORIGINAL_TITLE, (String)DOCUMENTATION_ORIGINAL_ROLE, null, (boolean)true, (Group)this._group, null, (String[])labels, (String)newOne.getContents().toString(), (String)newOne.getContentType(), (Member)this._originalAuthor, null, null, null, (Date)this._uriCreationDate, (Database)this._database);
                this.addEditNotes(newOne, xl, this._uriCreationDate);
                this.modified = true;
            }
            catch (DatabaseException ex) {
                LOGGER.error("Failed to create edit for fragment {}", (Object)fragmentID, (Object)ex);
                this.errors.add("Failed to create edit for fragment " + fragmentID);
            }
        }
        if (this.oldFragments != null) {
            for (String oldFrag : this.oldFragments.getFragments()) {
                if (this.existingURI && !this.editMetadata && oldFrag.equals(METADATA_FRAGMENT)) continue;
                Fragment oldFragObj = this.oldFragments.getFragment(oldFrag);
                Fragment newFragObj = this.newFragments.getFragment(oldFrag);
                if (!this.newFragments.allowsOverwrite(newFragObj == null ? oldFragObj : newFragObj) || newFragObj != null && !newFragObj.isDeleted() || oldFragObj.isDeleted()) continue;
                try {
                    XLink lastEdit = DatabaseQuery.getXLinkByURIGroupLastEditFragmentDraftCreationBeforeStatusChangedAfter((Database)this._database, (URI)this._uri, (Group)this._group, (String)oldFragObj.getFragment(), (boolean)true, (boolean)true, (boolean)true, null, null, null);
                    if (lastEdit == null) {
                        XLinkRule.createEditXLink((URI)this._uri, (String)oldFragObj.getFragment(), (String)DOCUMENT_ORIGINAL_TITLE, (String)DOCUMENTATION_ORIGINAL_ROLE, (String)DOCUMENT_OLD_STATUS, (boolean)true, (Group)this._group, null, null, (String)oldFragObj.getContents().toString(), (String)oldFragObj.getContentType(), (Member)this._originalAuthor, null, null, null, (Date)this._uriCreationDate, (Database)this._database);
                    } else {
                        lastEdit.setStatus(DOCUMENT_OLD_STATUS);
                        if (DOCUMENT_ORIGINAL_TITLE.equals(lastEdit.getContentTitle())) {
                            lastEdit.setDate(this._uriCreationDate);
                        }
                    }
                    if (METADATA_FRAGMENT.equals(oldFrag)) {
                        XLinkRule.createEditXLink((URI)this._uri, (String)METADATA_FRAGMENT, (String)"Document Upload Change", (String)DOCUMENTATION_ROLE, null, (boolean)false, (Group)this._group, null, null, (String)"<properties />", (String)oldFragObj.getContentType(), (Date)this._editsCreationDate, (Member)this._author, (Database)this._database);
                    } else {
                        XLinkRule.createEditXLink((URI)this._uri, (String)oldFragObj.getFragment(), (String)"Document Upload Change", (String)DOCUMENTATION_HIDDEN_ROLE, null, (boolean)false, (Group)this._group, null, null, (String)"Content Deleted", (String)"text/plain", (Date)this._editsCreationDate, (Member)this._author, (Database)this._database);
                        XLinkRule.archiveReverseXRefsForFragment((Database)this._database, (URI)this._uri, (String)oldFrag, (Group)this._group, (Date)this._editsCreationDate);
                        Locator loc = LocatorRule.getLocatorByURIFragment((Database)this._database, (URI)this._uri, (String)oldFrag);
                        List turis = DatabaseQuery.getURIsByLocatorTranscludedAllGroups((Database)this._database, (Locator)loc);
                        for (URI turi : turis) {
                            this.targetTranscludingUris.add(turi.getId());
                        }
                    }
                    this.modified = true;
                }
                catch (DatabaseException ex) {
                    LOGGER.error("Failed to delete fragment {}", (Object)oldFragObj.getFragment(), (Object)ex);
                    this.errors.add("Failed to delete fragment " + oldFragObj.getFragment());
                }
            }
        }
    }

    private void addEditNotes(Fragment fragment, XLink xl, Date date) throws DatabaseException {
        if (fragment == null) {
            return;
        }
        int i = 0;
        Fragment.Note note;
        while ((note = fragment.getNote(i++)) != null) {
            XLink notes = XLink.create((Database)this._database);
            notes.setContentRole("Documentation-Note");
            notes.setContentTitle(note.title() == null ? "Edit note" : note.title());
            notes.setAccepted(Boolean.TRUE);
            notes.setModeratorOnly(Boolean.FALSE);
            notes.setMember(this._author);
            notes.setDate(date);
            XLinkRule.addGroups((Database)this._database, (XLink)notes, Collections.singleton(this._group));
            if (!Strings.isEmpty((String)note.labels())) {
                Labels.setLabels((XLink)notes, (String[])note.labels().split(","));
            }
            Content cont = Content.create((Database)this._database);
            cont.setType("text/plain");
            if (note.content() != null) {
                cont.setData(note.content());
            }
            notes.addContents(cont);
            notes = notes.insert(this._database);
            xl.addReplies(notes);
        }
        return;
    }

    private boolean matchContents(Fragment newOne, Fragment oldOne) {
        String nl;
        String n;
        String o = oldOne == null || oldOne.isDeleted() || oldOne.getComparisonContents() == null ? null : oldOne.getComparisonContents().toString().trim();
        String string = n = newOne == null || newOne.isDeleted() || newOne.getComparisonContents() == null ? null : newOne.getComparisonContents().toString().trim();
        if (!(n == null && o == null || n != null && o != null && n.length() == o.length() && o.equals(n))) {
            return false;
        }
        String ol = oldOne == null ? null : oldOne.getLabels();
        String string2 = nl = newOne == null ? null : newOne.getLabels();
        if (ol == null ? nl != null : !ol.equals(nl)) {
            return false;
        }
        if (oldOne != null && newOne != null) {
            int i = 0;
            while (true) {
                Fragment.Note oldNote = oldOne.getNote(i);
                Fragment.Note newNote = newOne.getNote(i);
                if (oldNote == null && newNote == null) break;
                if (newNote != null && !oldOne.hasNote(newNote)) {
                    return false;
                }
                if (oldNote != null && !newOne.hasNote(oldNote)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private void handleXRefs() {
        Collection locs = this._uri.getLocatorsCol();
        HashMap<String, Locator> locatorsMap = new HashMap<String, Locator>();
        for (Locator loc : locs) {
            locatorsMap.put(loc.getFragment(), loc);
        }
        for (String fragment : this.newFragments.getFragments()) {
            boolean canDelete;
            Fragment fragObject;
            if (this.existingURI && !this.editMetadata && fragment.equals(METADATA_FRAGMENT) || !"application/vnd.pageseeder.psml+xml".equals((fragObject = this.newFragments.getFragment(fragment)).getContentType())) continue;
            boolean newFragment = this.oldFragments == null || this.oldFragments.getFragment(fragment) == null;
            boolean bl = canDelete = newFragment || this.newFragments.allowsOverwrite(fragObject);
            if (!canDelete && !this.newFragments.canCreateNewFragments()) continue;
            this.removeExistingXRefs(fragObject, (Locator)locatorsMap.get(fragment), canDelete);
            this.createRemainingXRefs(fragObject, newFragment);
        }
        if (this.oldFragments != null) {
            for (String fragment : this.oldFragments.getFragments()) {
                Fragment oldFrag;
                if (this.existingURI && !this.editMetadata && fragment.equals(METADATA_FRAGMENT) || this.newFragments.getFragment(fragment) != null || !this.newFragments.allowsOverwrite(oldFrag = this.oldFragments.getFragment(fragment))) continue;
                this.removeExistingXRefs(oldFrag, (Locator)locatorsMap.get(fragment), true);
            }
        }
    }

    private void removeExistingXRefs(Fragment fragment, Locator loc, boolean deleteOldOnes) {
        if (fragment == null || loc == null || !this.createXRefs || this.existingURI && !this.editMetadata && fragment.getFragment().equals(METADATA_FRAGMENT)) {
            return;
        }
        Predicate pred = Predicates.predicateXLinkForLocatorRoleContains((Database)this._database, (String[])new String[]{"xref-source"});
        pred.addPredicate(Predicates.predicateXLinkForLocatorByGroupStatusContentRoleLike((Database)this._database, (Long)this._group.getId(), (String)DOCUMENT_OLD_STATUS, (boolean)false, (String[])new String[]{"XRef%"}));
        Iterator xlfs = loc.getXLinksForLocator((Object)pred);
        ArrayList<XLink> todelete = new ArrayList<XLink>();
        Date changedDate = new Date();
        while (xlfs.hasNext()) {
            LocatorForXLink lfx = (LocatorForXLink)xlfs.next();
            FoundXRef found = this.findXRefForXLink(fragment, lfx);
            if (found.xref() != null) {
                fragment.removeXRef(found.xref());
                continue;
            }
            if (!deleteOldOnes) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("XRef exists in database but not content: xlink is {}", (Object)lfx.getXLink().getId());
            }
            todelete.add(lfx.getXLink());
            if (!"xref-source-manual-link".equals(lfx.getRole())) continue;
            URI turi = found.targetURI();
            turi.setLastModified(changedDate);
            this.targetTranscludingUris.add(turi.getId());
            if (!"embed".equals(lfx.getLabel()) || !URIRule.isPSML((URI)turi)) continue;
            this.embedTargetUris.add(turi.getId());
        }
        for (XLink oldOne : todelete) {
            oldOne.setStatus(DOCUMENT_OLD_STATUS);
            oldOne.setStatusChangedDate(changedDate);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Removed XRef: XLinkId={}", (Object)oldOne.getId());
        }
    }

    private void createRemainingXRefs(Fragment fragment, boolean isNewFragment) {
        if (this.existingURI && !this.editMetadata && fragment.getFragment().equals(METADATA_FRAGMENT)) {
            return;
        }
        for (XRef tempXRef : fragment.getXRefs()) {
            try {
                if (tempXRef.getUriid() == null) continue;
                URI target_uri = DatabaseQuery.getURIById((Database)this._database, (Long)tempXRef.getUriid());
                if (target_uri == null) {
                    this.errors.add("Failed to create a Cross-Reference as there is no URI with ID " + tempXRef.getUriid());
                    continue;
                }
                String contentrole = tempXRef.getDisplay() != null && !tempXRef.getDisplay().isEmpty() ? "XRef-" + tempXRef.getDisplay() : "XRef";
                XLink xl = XLinkRule.createXRefXLink((Group)this._group, (String)contentrole, (String)tempXRef.getTitle(), (Member)this._author, (String[])tempXRef.getLabels(), (String)tempXRef.getType(), (boolean)tempXRef.getReverseLink(), (String)tempXRef.getReverseTitle(), (String)tempXRef.getReverseType(), (URI)this._uri, (String)tempXRef.getSourceFragment(), (URI)target_uri, (String)tempXRef.getTargetFragment(), (Date)this._editsCreationDate, (Database)this._database);
                tempXRef.setXLink(xl);
                if (!this.existingURI || isNewFragment) {
                    fragment.setHasModifiedXRefs(true);
                }
                this.modified = true;
                if (tempXRef.getLevel() != null) {
                    ObjectProperties.setXLinkProperty((XLink)xl, (String)"level", Collections.singletonList(tempXRef.getLevel()));
                }
                if (tempXRef.getConfig() != null) {
                    ObjectProperties.setXLinkProperty((XLink)xl, (String)"config", Collections.singletonList(tempXRef.getConfig()));
                }
                if (tempXRef.getReverseLink()) {
                    target_uri.setLastModified(this._editsCreationDate);
                    this.targetTranscludingUris.add(target_uri.getId());
                    if ("embed".equals(tempXRef.getType()) && URIRule.isPSML((URI)target_uri)) {
                        this.embedTargetUris.add(target_uri.getId());
                    }
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("New XRef has been added: XLinkId={}\n{}", (Object)xl.getId(), (Object)tempXRef.toString());
            }
            catch (DatabaseException e) {
                LOGGER.error("Failed to create XRef: {}", (Object)e.getMessage());
                this.errors.add(e.getMessage());
            }
        }
    }

    private FoundXRef findXRefForXLink(Fragment fragment, LocatorForXLink lfxFrom) {
        XLink from = lfxFrom.getXLink();
        boolean from_reverselink = false;
        String from_dbl_title = null;
        String from_reverse_type = null;
        URI from_uri = null;
        String from_title = null;
        String from_loc_frag = null;
        Iterator temp_lfxs = from.getLocatorsForXLink();
        while (temp_lfxs.hasNext()) {
            LocatorForXLink temp_lfx = (LocatorForXLink)temp_lfxs.next();
            if (temp_lfx.equals((Object)lfxFrom) || temp_lfx.getRole() != null && temp_lfx.getRole().startsWith("xref-source")) continue;
            from_reverselink = "xref-source-link".equals(lfxFrom.getRole()) || "xref-source-manual-link".equals(lfxFrom.getRole());
            from_dbl_title = lfxFrom.getTitle();
            from_reverse_type = temp_lfx.getLabel();
            from_title = temp_lfx.getTitle();
            Locator temp_lfx_locator = temp_lfx.getLocator();
            if (temp_lfx_locator == null) {
                LOGGER.warn("Couldn't find locator.");
                continue;
            }
            from_uri = temp_lfx_locator.getURI();
            from_loc_frag = temp_lfx_locator.getFragment();
            break;
        }
        for (XRef newXRef : fragment.getXRefs()) {
            if (newXRef.getTargetFragment() == null || from_loc_frag == null ? newXRef.getTargetFragment() != null || from_loc_frag != null : !newXRef.getTargetFragment().equals(from_loc_frag)) continue;
            String from_role = from.getContentRole();
            String from_display = null;
            if (from_role.contains("XRef-")) {
                from_display = from_role.substring(5);
            }
            if (newXRef.getDisplay() != null && from_display != null ? !newXRef.getDisplay().equals(from_display) : newXRef.getDisplay() != null || from_display != null) continue;
            if (newXRef.getUriid() != null && from_uri != null && from_uri.getId() != null ? !newXRef.getUriid().equals(from_uri.getId()) : newXRef.getUriid() != null || from_uri != null && from_uri.getId() != null) continue;
            if (newXRef.getTitle() != null && from_title != null ? !newXRef.getTitle().equals(from_title) : newXRef.getTitle() != null || from_title != null) continue;
            if (newXRef.getType() != null && lfxFrom.getLabel() != null ? !newXRef.getType().equals(lfxFrom.getLabel()) : newXRef.getType() != null || lfxFrom.getLabel() != null) continue;
            if (from_reverselink && !newXRef.getReverseLink() || !from_reverselink && newXRef.getReverseLink()) continue;
            if (from_reverselink) {
                if (newXRef.getReverseTitle() != null && from_dbl_title != null ? !newXRef.getReverseTitle().equals(from_dbl_title) : newXRef.getReverseTitle() != null || from_dbl_title != null) continue;
                if (newXRef.getReverseType() != null && from_reverse_type != null ? !newXRef.getReverseType().equals(from_reverse_type) : newXRef.getReverseType() != null || from_reverse_type != null) continue;
            }
            if (Labels.labelsAreDifferent((String[])Labels.getLabels((XLink)from), (String[])newXRef.getLabels())) continue;
            String from_level = XRef.getLevelFromXlink((XLink)from);
            if (newXRef.getLevel() == null || from_level == null ? newXRef.getLevel() != null || from_level != null : !from_level.equals(newXRef.getLevel())) continue;
            String from_config = XRef.getConfigFromXlink((XLink)from);
            if (newXRef.getConfig() == null || from_config == null ? newXRef.getConfig() != null || from_config != null : !from_config.equals(newXRef.getConfig())) continue;
            return new FoundXRef(newXRef, from_uri);
        }
        return new FoundXRef(null, from_uri);
    }

    @Immutable
    private static final class FoundXRef {
        private final XRef _xref;
        private final URI _targeturi;

        FoundXRef(XRef xref, URI targeturi) {
            this._xref = xref;
            this._targeturi = targeturi;
        }

        URI targetURI() {
            return this._targeturi;
        }

        public XRef xref() {
            return this._xref;
        }
    }
}

