/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load.edits;

import com.pageseeder.base.xref.XRef;
import com.pageseeder.common.Immutable;
import com.pageseeder.common.util.Strings;
import com.pageseeder.load.edits.ContentPart;
import java.util.ArrayList;
import java.util.List;

public final class Fragment {
    private String sectionId = null;
    private final String fragment;
    private String contentType;
    private final List<ContentPart> parts = new ArrayList<ContentPart>();
    private StringBuffer contents = null;
    private StringBuffer comparisonContents = null;
    private final List<XRef> xrefs = new ArrayList<XRef>();
    private Long editXLinkID = null;
    private boolean isDeleted = false;
    private boolean hasModifiedXRefs = false;
    private String labels = null;
    private final List<Note> notes = new ArrayList<Note>();

    public Fragment(String frag, String ctype) {
        this.fragment = frag;
        this.contentType = ctype;
    }

    public void setSectionId(String sectId) {
        this.sectionId = sectId;
    }

    public void setEditXLinkID(String xlinkid) {
        try {
            this.editXLinkID = Long.parseLong(xlinkid);
        }
        catch (NumberFormatException ex) {
            this.editXLinkID = null;
        }
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labs) {
        if (!Strings.isEmpty((String)labs)) {
            this.labels = labs;
        }
    }

    public void addNote(String title, String content, String labs) {
        Note note = new Note(title, content, labs);
        this.notes.add(note);
    }

    public Note getNote(int index) {
        if (index >= this.notes.size()) {
            return null;
        }
        return this.notes.get(index);
    }

    public boolean hasNote(Note note) {
        if (note == null) {
            return false;
        }
        return this.notes.contains(note);
    }

    public String sectionId() {
        return this.sectionId;
    }

    public boolean hasEditXLink() {
        return this.editXLinkID != null;
    }

    public Long getEditXlinkID() {
        return this.editXLinkID;
    }

    public void setDeleted(boolean deleted) {
        this.isDeleted = deleted;
    }

    public void setContentType(String contenttype) {
        this.contentType = contenttype;
        this.unescapeXML(this.contents);
        this.unescapeXML(this.comparisonContents);
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public void addContents(List<ContentPart> allparts) {
        this.parts.addAll(allparts);
    }

    public void addXref(XRef xref) {
        this.xrefs.add(xref);
    }

    public StringBuffer getContents() {
        if (this.contents == null) {
            this.computeContents();
        }
        return this.contents;
    }

    public StringBuffer getComparisonContents() {
        if (this.comparisonContents == null) {
            this.computeContents();
        }
        return this.comparisonContents;
    }

    private void computeContents() {
        this.contents = new StringBuffer();
        this.comparisonContents = new StringBuffer();
        for (ContentPart part : this.parts) {
            this.contents.append(part.toString());
            this.comparisonContents.append(part.toComparisonString());
        }
        this.unescapeXML(this.contents);
        this.unescapeXML(this.comparisonContents);
    }

    public void setHasModifiedXRefs(boolean hasXRefs) {
        this.hasModifiedXRefs = hasXRefs;
    }

    public boolean hasModifiedXRefs() {
        return this.hasModifiedXRefs;
    }

    public void removeXRef(XRef xref) {
        this.xrefs.remove(xref);
    }

    public List<XRef> getXRefs() {
        return this.xrefs;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toString() {
        return this.contents == null ? "" : this.contents.toString();
    }

    private void unescapeXML(StringBuffer xml) {
        if (xml != null && "text/plain".equals(this.contentType)) {
            int max = xml.length();
            for (int i = 0; i < max; ++i) {
                char c = xml.charAt(i);
                if (c != '&') continue;
                if (xml.length() >= i + 5 && "&amp;".equals(xml.substring(i, i + 5))) {
                    xml.replace(i, i + 5, "&");
                    max -= 4;
                    continue;
                }
                if (xml.length() >= i + 4 && "&lt;".equals(xml.substring(i, i + 4))) {
                    xml.replace(i, i + 4, "<");
                    max -= 3;
                    continue;
                }
                if (xml.length() < i + 4 || !"&gt;".equals(xml.substring(i, i + 4))) continue;
                xml.replace(i, i + 4, ">");
                max -= 3;
            }
        }
    }

    @Immutable
    protected static final class Note {
        private final String _title;
        private final String _content;
        private final String _labels;
        private int hash = 0;

        public Note(String title, String content, String labels) {
            this._title = title;
            this._content = content;
            this._labels = labels;
        }

        public String title() {
            return this._title;
        }

        public String content() {
            return this._content;
        }

        public String labels() {
            return this._labels;
        }

        public int hashCode() {
            if (this.hash == 0) {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this._content == null ? 0 : this._content.hashCode());
                result = 31 * result + (this._labels == null ? 0 : this._labels.hashCode());
                this.hash = result = 31 * result + (this._title == null ? 0 : this._title.hashCode());
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Note n = (Note)obj;
            if (this._title != null ? !this._title.equals(n._title) : n._title != null) {
                return false;
            }
            if (this._content != null ? !this._content.equals(n._content) : n._content != null) {
                return false;
            }
            return !(this._labels != null ? !this._labels.equals(n._labels) : n._labels != null);
        }
    }
}

