/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.mail.Emails;
import com.pageseeder.base.rule.Notify;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.common.properties.GlobalSettings;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.Labels;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.pageseeder.xmlwriter.XMLWriter;

public final class SendNotification
implements LoadingThreadAction {
    private static final int MAX_UPLOAD_NOTIFICATION_ATTACHMENTS = 20;
    private final LoadingThread _parent;
    private boolean _cancelled = false;
    private StringBuilder _message = new StringBuilder("The file has been uploaded.");
    private final List<String> _warnings = new ArrayList<String>();
    private String _subject = "File Upload";
    private String _status = null;
    private String[] _labels = null;
    private Notify _notify = Notify.SILENT;
    private boolean _done = false;
    private Long _destinationFolderURIID = -1L;

    public SendNotification(LoadingThread thread) {
        this._parent = thread;
    }

    public void setDestinationFolderURIID(Long destinationFolderURIID) {
        this._destinationFolderURIID = destinationFolderURIID;
    }

    @Override
    public void cancel() {
        this._cancelled = true;
    }

    public void setMessage(String message) {
        this._message = new StringBuilder(message);
    }

    public void setLabels(String[] labels) {
        this._labels = labels;
    }

    public void setStatus(String status) {
        this._status = status;
    }

    public void setSubject(String subject) {
        this._subject = Strings.isEmpty((String)subject) ? "File Upload" : subject;
    }

    public void setNotify(String notify) {
        this._notify = Notify.fromString((String)notify);
    }

    public String[] getLabels() {
        return this._labels;
    }

    @Override
    public String name() {
        return "Notification";
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", this._done ? 1L : 0L);
        out.field("total", 1L);
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    public void addWarning(String warning) {
        this._warnings.add(warning);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send(Collection<IncomingFile> files) {
        try {
            Database db;
            block26: {
                db = Database.open();
                if (!this._cancelled) break block26;
                if (db == null) return;
                db.close();
                return;
            }
            try {
                Group grp;
                Member member;
                boolean linkURIs;
                ArrayList<URI> attachments;
                Transaction tr;
                block27: {
                    tr = new Transaction(db);
                    tr.begin();
                    attachments = new ArrayList<URI>();
                    int maxAttachments = GlobalSettings.getInt((String)"maxUploadNotificationAttachments", (int)20);
                    boolean bl = linkURIs = files.size() <= maxAttachments;
                    if (!linkURIs) {
                        this._message.append("\n\nThere were ").append(files.size());
                        this._message.append(" files which is too many to attach.");
                        if (!this._warnings.isEmpty()) {
                            this._message.append("\n\nThe upload succeeded with ").append(this._warnings.size()).append(" warnings.\n");
                        }
                    }
                    try {
                        member = DatabaseQuery.getMemberByUsername((Database)db, (String)this._parent.getUsername());
                        grp = DatabaseQuery.getGroupById((Database)db, (Long)this._parent.getGroupID());
                        if (linkURIs) {
                            for (IncomingFile file : files) {
                                attachments.add(DatabaseQuery.getURIById((Database)db, (Long)file.getUriID()));
                            }
                        }
                    }
                    catch (QueryFailedException e) {
                        tr.abort();
                        this._parent.fail("Failed to load database object: " + e.getMessage());
                        if (db == null) return;
                        db.close();
                        return;
                    }
                    if (!this._cancelled) break block27;
                    tr.abort();
                    if (db == null) return;
                    db.close();
                    return;
                }
                if (!this._warnings.isEmpty() && linkURIs) {
                    this._message.append("\n\nThe upload succeeded with the following warnings:\n");
                    for (String warning : this._warnings) {
                        this._message.append(warning).append('\n');
                    }
                }
                try {
                    if (this._notify == Notify.NORMAL || this._notify == Notify.ANNOUNCE) {
                        Emails.sendNewURI((Database)db, (Member)member, (String)this._subject, (String)this._message.toString(), (String)"File Upload", (String[])this._labels, attachments, (Group)grp, (this._notify == Notify.ANNOUNCE ? 1 : 0) != 0, (Boolean)false);
                    }
                    this._done = true;
                    Object status = this._notify == Notify.NORMAL ? "Notification message sent: " : "Notification message attached: ";
                    String labels = Labels.labelsToCommaSeparated((String[])this._labels);
                    status = (String)status + this._subject + (String)(labels != null ? " - " + labels : "");
                    this._parent.updateStatus(ProcessStage.Status.INPROGRESS, (String)status);
                }
                catch (FoundationException ex) {
                    tr.abort();
                    this._parent.fail(ex.getMessage());
                    if (db == null) return;
                    db.close();
                    return;
                }
                try {
                    tr.commit();
                    return;
                }
                catch (Exception ex) {
                    tr.abort();
                    this._parent.fail("Failed to send notification: " + ex.getMessage());
                    return;
                }
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        catch (OpenDatabaseException e) {
            this._parent.fail("Failed to open the database:" + e.getMessage());
        }
    }
}

