/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.document.StructureBuilder;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.permission.EditAllURLsCheck;
import com.pageseeder.base.permission.EditURICheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.PermissionManager;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.publication.Publications;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.rule.XLinkRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.util.Medias;
import com.pageseeder.base.util.RuleUtils;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.common.util.Rules;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.ObjectStateException;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Content;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.GroupURIs;
import com.pageseeder.db.util.Labels;
import com.pageseeder.load.IncomingFile;
import com.pageseeder.load.LoadingThread;
import com.pageseeder.load.LoadingThreadAction;
import com.pageseeder.load.LoadingZone;
import com.pageseeder.load.OverwriteSummary;
import com.pageseeder.url.URLCreator;
import com.pageseeder.url.URLException;
import com.pageseeder.utils.MemberTempFiles;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.process.ProcessException;
import org.pageseeder.psml.process.util.XMLUtils;
import org.pageseeder.xmlwriter.XMLWriter;
import org.pageseeder.xmlwriter.XMLWriterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class Register
implements LoadingThreadAction {
    private static final Logger GENERAL_LOGGER = LoggerFactory.getLogger(Register.class);
    private static final String STAR = "*";
    private static final String SLASH = "/";
    private static final char SLASH_CHAR = '/';
    public static final String MANIFEST_FILE_NAME = "uploaded-uris.xml";
    private final List<IncomingFile> filesToRegister = new ArrayList<IncomingFile>();
    private final List<IncomingFile> urlsToRegister = new ArrayList<IncomingFile>();
    private final Map<Long, IncomingFile> toRevert = new HashMap<Long, IncomingFile>();
    private final List<PublicationUpdate> publicationUpdates = new ArrayList<PublicationUpdate>();
    private final LoadingThread parent;
    private final LoadingZone loadingZone;
    private final URL url;
    private final LoadingThread.OverwriteBehavior overwrite;
    private final String[] uriHistoryEventLabels;
    private boolean overwriteProperties = false;
    private boolean createManifest = true;
    private final List<GroupURI> guris = new ArrayList<GroupURI>();
    private final Map<String, File> backups = new HashMap<String, File>();
    private final List<File> stored = new ArrayList<File>();
    private int currentFile = 0;
    private boolean cancelled = false;
    private boolean overwriteChecked = false;
    private final List<IncomingFile> filesWithMetadataCreated = new ArrayList<IncomingFile>();
    private final List<Long> createdFolderURIID = new ArrayList<Long>();
    private Long destinationFolderURIID = null;
    private XMLWriter urisOutput = null;
    private final Collection<Long> created = new ArrayList<Long>();
    private final Map<String, String> realPaths = new HashMap<String, String>();
    private final Set<Long> xrefUris = new HashSet<Long>();
    private final Set<Long> commentUris = new HashSet<Long>();
    private final Set<Long> publicationUpdateUris = new HashSet<Long>();

    public Register(LoadingThread dad, LoadingZone zone, URL folderurl, LoadingThread.OverwriteBehavior behavior, boolean manifest, String[] eventLabels) {
        this.parent = dad;
        this.loadingZone = zone;
        this.url = folderurl;
        this.overwrite = behavior;
        this.createManifest = manifest;
        this.uriHistoryEventLabels = eventLabels;
    }

    public void setOverwriteProperties(boolean overwriteProp) {
        this.overwriteProperties = overwriteProp;
    }

    @Override
    public String name() {
        return "Register";
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", (long)this.currentFile);
        out.field("total", (long)(this.filesToRegister.size() + this.urlsToRegister.size()));
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public boolean wasCreated(Long uriid) {
        return this.created.contains(uriid);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public OverwriteSummary checkOverwrite() {
        if (this.overwriteChecked) {
            return new OverwriteSummary(null, null);
        }
        try (Database db = Database.open();){
            if (this.cancelled) {
                OverwriteSummary overwriteSummary2 = null;
                return overwriteSummary2;
            }
            Transaction tr = new Transaction(db);
            try {
                tr.begin();
                OverwriteSummary summary = this.checkOverwrite(db);
                this.overwriteChecked = true;
                if (summary == null || summary == OverwriteSummary.CONFLICT_SUMMARY) {
                    tr.abort();
                } else {
                    summary.printToXML(db);
                    tr.commit();
                }
                OverwriteSummary overwriteSummary = summary;
                return overwriteSummary;
            }
            catch (Exception e) {
                OverwriteSummary overwriteSummary3;
                block16: {
                    this.parent.fail("Failed to check for overwrite: " + e.getMessage());
                    tr.abort();
                    overwriteSummary3 = null;
                    if (db == null) break block16;
                    db.close();
                }
                return overwriteSummary3;
            }
        }
        catch (OpenDatabaseException e2) {
            this.parent.fail("Failed to open the database:" + e2.getMessage());
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public void perform() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 21[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addFiles(Collection<IncomingFile> files) {
        this.filesToRegister.addAll(files);
    }

    public void addURL(IncomingFile aurl) {
        if (!this.urlsToRegister.contains(aurl)) {
            this.urlsToRegister.add(aurl);
        }
    }

    public File getBackupFile(IncomingFile original) {
        return this.backups.get(original.getPath());
    }

    public List<IncomingFile> getFilesWithMetadataCreated() {
        return this.filesWithMetadataCreated;
    }

    public List<PublicationUpdate> getPublicationUpdates() {
        return this.publicationUpdates;
    }

    public Map<Long, IncomingFile> getReverts() {
        return this.toRevert;
    }

    private FileOutputStream prepareManifestFile(Member author, Group group) throws IOException {
        if (author == null || group == null || !this.createManifest) {
            return null;
        }
        File tempFolder = MemberTempFiles.getTempFolder(author, group);
        String uploadid = this.loadingZone.uploadID();
        String manifestName = (String)(uploadid != null ? uploadid + "-" : "") + MANIFEST_FILE_NAME;
        File outputFile = new File(tempFolder, manifestName);
        try {
            if (outputFile.exists() || outputFile.createNewFile()) {
                FileOutputStream urisOutputStream = new FileOutputStream(outputFile);
                this.urisOutput = new XMLWriterImpl((Writer)new OutputStreamWriter((OutputStream)urisOutputStream, StandardCharsets.UTF_8));
                this.urisOutput.openElement("uris");
                return urisOutputStream;
            }
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to create manifest file " + outputFile.getAbsolutePath());
        }
        catch (IOException e) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to create/write to manifest file: " + e.getMessage());
        }
        return null;
    }

    private void addURLToManifestFile(URI uri) {
        if (this.urisOutput != null && uri != null) {
            try (UniversalPrinter p = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
                p.writeExternalURI(uri);
                this.urisOutput.writeXML(p.toString());
            }
            catch (IOException e) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to write URL " + uri.getId() + " to manifest file: " + e.getMessage());
            }
        }
    }

    private void addURIToManifestFile(URI uri) {
        if (this.urisOutput != null && uri != null) {
            try (UniversalPrinter p = UniversalPrinter.newWriter((OutputType)OutputType.XML);){
                p.writeURI(uri);
                this.urisOutput.writeXML(p.toString());
            }
            catch (IOException e) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to write URI " + uri.getId() + " to manifest file: " + e.getMessage());
            }
        }
    }

    private void closeManifestFile(FileOutputStream stream) {
        if (this.urisOutput != null && stream != null) {
            try {
                this.urisOutput.closeElement();
                this.urisOutput.close();
                stream.close();
            }
            catch (IOException e) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to close manifest file: " + e.getMessage());
            }
        }
    }

    private OverwriteSummary checkOverwrite(Database db) throws QueryFailedException, IOException {
        URI uri;
        String destinationFolder = this.url.getPath();
        File afolder = new File(URIRule.getRealPath((String)destinationFolder));
        OverwriteSummary summary = new OverwriteSummary(afolder, destinationFolder);
        boolean foundExisting = false;
        for (IncomingFile file : this.filesToRegister) {
            boolean found;
            File destination = this.computeDestination(file, db);
            if (this.overwrite == LoadingThread.OverwriteBehavior.OVERWRITE || this.overwrite == LoadingThread.OverwriteBehavior.RENAME || this.overwrite == LoadingThread.OverwriteBehavior.FAIL || this.overwrite == LoadingThread.OverwriteBehavior.SUMMARY_IF_NEEDED) {
                if ((this.overwriteProperties || !destination.exists()) && file.checkMetadataFile(this.loadingZone)) {
                    this.filesWithMetadataCreated.add(file);
                }
                if (this.overwrite == LoadingThread.OverwriteBehavior.OVERWRITE || this.overwrite == LoadingThread.OverwriteBehavior.RENAME) continue;
            }
            if (!(found = destination.exists()) && URIRule.isPSML((File)destination) && destination.getParentFile().exists()) {
                uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)this.url.getProtocol(), (String)this.url.getHost(), (Integer)(this.url.getPort() == -1 ? Rules.getDefaultPort((String)this.url.getProtocol()) : this.url.getPort()), (String)this.buildPath(file.getPath()));
                boolean bl = found = uri != null;
            }
            if (found) {
                if (this.overwrite == LoadingThread.OverwriteBehavior.FAIL) {
                    this.parent.fail("Document " + file.getPath() + " already exists and overwrite is disabled.");
                    return OverwriteSummary.CONFLICT_SUMMARY;
                }
                summary.addExistingObject(file);
                foundExisting = true;
                continue;
            }
            summary.addObjectToCreate(file);
        }
        if (this.overwrite != LoadingThread.OverwriteBehavior.OVERWRITE) {
            for (IncomingFile toRegister : this.urlsToRegister) {
                URL url;
                String urlString = toRegister.getAttribute("url");
                if (urlString == null) {
                    this.parent.fail("Missing URL for url " + toRegister.getPath());
                    return null;
                }
                try {
                    url = RuleUtils.urlEncodeNormalize((String)urlString);
                }
                catch (MalformedURLException ex) {
                    this.parent.fail("Failed to compute normalized URL for url " + toRegister.getPath() + ": " + ex.getMessage());
                    return null;
                }
                try {
                    uri = URIRule.getURIByURL((Database)db, (URL)url);
                }
                catch (DatabaseException ex) {
                    this.parent.fail("Failed to check for existing URI for url " + toRegister.getPath() + ": " + ex.getMessage());
                    return null;
                }
                if (uri != null) {
                    if (this.overwrite == LoadingThread.OverwriteBehavior.FAIL) {
                        this.parent.fail("URL " + toRegister.getPath() + " already exists and overwrite is disabled.");
                        return OverwriteSummary.CONFLICT_SUMMARY;
                    }
                    summary.addExistingObject(toRegister);
                    foundExisting = true;
                    continue;
                }
                summary.addObjectToCreate(toRegister);
            }
        }
        if (!(this.overwrite != LoadingThread.OverwriteBehavior.SUMMARY_IF_NEEDED && this.overwrite != LoadingThread.OverwriteBehavior.FAIL || foundExisting)) {
            return new OverwriteSummary(afolder, destinationFolder);
        }
        return summary;
    }

    private boolean createStructure(File file, URI uri, Group group, Member author, Database db) {
        try {
            group = GroupRule.getEditGroup((Database)db, (Group)group, (URI)uri);
            XLink structure = DatabaseQuery.getXLinkURIStructure((Database)db, (URI)uri, (Group)group, null);
            @Nullable String existingStructure = structure == null ? null : ((Content)structure.getContents().next()).getData();
            StructureBuilder builder = new StructureBuilder();
            List frags = URIRule.loadFragments((URI)uri, (Group)group, (boolean)false, (Database)db);
            if (frags != null) {
                for (String frag : frags) {
                    builder.addExistingFragmentID(frag);
                }
            }
            builder.setOldStructure(existingStructure);
            XMLUtils.parse((InputStream)new FileInputStream(file), (ContentHandler)builder);
            String newStructure = builder.getStructureXML();
            if (existingStructure == null || !existingStructure.equals(newStructure)) {
                boolean justCreated = this.created.contains(uri.getId());
                Date creationDate = justCreated ? new Date(uri.getDateCreated().getTime()) : null;
                XLinkRule.createStructureXLink((URI)uri, (Group)group, (Database)db, (String)newStructure, (Member)author, (Date)creationDate, (String)"Document Upload", (!justCreated ? 1 : 0) != 0);
            }
            return true;
        }
        catch (DatabaseException | IOException | ProcessException ex) {
            this.parent.fail("Failed to create structure: " + ex.getMessage() + ".");
            return false;
        }
    }

    private File computeDestination(IncomingFile file, Database db) {
        String filepath = file.getPath();
        String realpath = this.realPath(filepath, db);
        file.updatePath(realpath);
        File afolder = new File(URIRule.getRealPath((String)RuleUtils.urlEncodeFilepath((String)this.url.getPath())));
        File destination = new File(afolder, realpath);
        if (destination.exists() && (this.overwrite == LoadingThread.OverwriteBehavior.RENAME || this.overwrite == LoadingThread.OverwriteBehavior.SUMMARY_RENAME)) {
            String extension;
            String originalPath;
            int lastDot = filepath.lastIndexOf(46);
            if (lastDot > 0) {
                originalPath = filepath.substring(0, lastDot);
                extension = filepath.substring(lastDot);
            } else {
                originalPath = filepath;
                extension = "";
            }
            String newpath = null;
            int counter = 1;
            while (destination.exists()) {
                newpath = originalPath + "-" + counter++ + extension;
                destination = new File(afolder, this.realPath(newpath, db));
            }
            file.updatePath(newpath);
        }
        return destination;
    }

    private void cleanupFolders() {
        File[] remainings = this.loadingZone.baseDirectory().listFiles();
        if (remainings != null) {
            for (File file : remainings) {
                if (file.delete()) continue;
                file.deleteOnExit();
            }
        }
    }

    public void cleanup() {
        while (!this.backups.isEmpty()) {
            File backup = this.backups.remove(this.backups.keySet().iterator().next());
            this.cleanBackup(backup);
        }
        for (File file : this.stored) {
            if (!file.exists() || file.delete()) continue;
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to delete old file: " + file.getAbsolutePath());
            file.deleteOnExit();
        }
    }

    public void cleanBackup(File backup) {
        if (backup.exists()) {
            if (backup.getName().toLowerCase().endsWith(".psml.bak")) {
                String path = backup.getAbsolutePath();
                File newOne = new File(path.substring(0, path.length() - 4));
                FileUtils.deleteQuietly((File)newOne);
                try {
                    FileUtils.moveFile((File)backup, (File)newOne);
                }
                catch (IOException ex) {
                    this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to move backup to original location: " + ex.getMessage());
                }
            } else if (!backup.delete()) {
                backup.deleteOnExit();
            }
        }
    }

    public List<Long> getCreatedFolderURIIDs() {
        return this.createdFolderURIID;
    }

    public Set<Long> getXRefUris() {
        return this.xrefUris;
    }

    public Set<Long> getCommentUris() {
        return this.commentUris;
    }

    public Set<Long> getPublicationUpdateUris() {
        return this.publicationUpdateUris;
    }

    public Long getDestinationFolderURIID() {
        return this.destinationFolderURIID;
    }

    public void revert() {
        HashMap<String, File> folders = new HashMap<String, File>();
        for (IncomingFile toRegister : this.toRevert.values()) {
            File original;
            String parentPath;
            String path = toRegister.getPath();
            if (toRegister.getFile().isDirectory()) {
                folders.put(path, toRegister.getFile());
                continue;
            }
            if (path.indexOf(47) != -1 && !folders.containsKey(parentPath = path.substring(0, path.lastIndexOf(47)))) {
                folders.put(parentPath, toRegister.getFile().getParentFile());
            }
            if ((original = new File(this.loadingZone.baseDirectory(), path)).exists()) continue;
            if (!this.moveFile(toRegister.getFile(), original)) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to revert to original file " + original.getAbsolutePath());
            }
            if (!this.backups.containsKey(path)) continue;
            File backup = this.backups.get(path);
            if (!backup.renameTo(new File(toRegister.getFile().getAbsolutePath()))) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to revert backup file " + backup.getAbsolutePath());
            }
            this.backups.remove(path);
        }
        ArrayList paths = new ArrayList(folders.keySet());
        paths.sort(Comparator.comparing(String::length).reversed());
        for (String path : paths) {
            File dir = (File)folders.get(path);
            dir.delete();
        }
    }

    private String realPath(String filepath, Database db) {
        Object realDestination = "";
        String[] folders = filepath.split(SLASH);
        for (int i = 0; i < folders.length; ++i) {
            if (folders[i].isEmpty()) continue;
            String subfolder = Register.join(folders, 0, i);
            String path = this.buildPath(subfolder);
            String realPath = this.realPaths.get(path);
            if (realPath == null) {
                URI uri = null;
                try {
                    int port = this.url.getPort();
                    if (port == -1) {
                        port = Rules.getDefaultPort((String)this.url.getProtocol());
                    }
                    uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)this.url.getProtocol(), (String)this.url.getHost(), (Integer)port, (String)path);
                }
                catch (QueryFailedException e) {
                    this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to retrieve URI for file " + subfolder);
                }
                realPath = uri != null ? this.buildPathFromURI(subfolder, uri) : STAR;
                this.realPaths.put(path, realPath);
            }
            if (STAR.equals(realPath)) {
                realDestination = (String)realDestination + (i == 0 ? "" : SLASH) + Register.join(folders, i, folders.length - 1);
                break;
            }
            realDestination = realPath;
        }
        return realDestination;
    }

    private static String join(String[] strings, int from, int until) {
        StringBuilder s = new StringBuilder();
        for (int i = from; i <= until; ++i) {
            s.append(i == from ? "" : SLASH).append(strings[i]);
        }
        return s.toString();
    }

    private boolean ensureValidParentGroupURIs(Database db) {
        String scheme = this.url.getProtocol();
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (port == -1) {
            port = Rules.getDefaultPort((String)scheme);
        }
        String newPath = RuleUtils.replaceNonFolderCharsKeepSlashes((String)this.url.getPath());
        String encodedPath = RuleUtils.urlEncodeFilepath((String)newPath);
        try {
            this.guris.addAll(URIRule.matchGroupURIs((Database)db, (String)scheme, (String)host, (Integer)port, (String)encodedPath));
            this.guris.addAll(DatabaseQuery.getGroupURIsBySchemeHostPortSubpathCol((Database)db, (String)scheme, (String)host, (Integer)port, (String)encodedPath));
            if (this.guris.isEmpty()) {
                this.parent.fail("Invalid destination URL: no parent group folders found.");
            }
            return !this.guris.isEmpty();
        }
        catch (DatabaseException ex) {
            this.parent.fail("Failed to load parent group folders: " + ex.getMessage() + ".");
            return false;
        }
    }

    private List<GroupURI> filterGroupURIs(String path) {
        ArrayList<GroupURI> filtered = new ArrayList<GroupURI>();
        if (path == null) {
            return filtered;
        }
        for (GroupURI guri : this.guris) {
            if (!path.toLowerCase().startsWith(GroupURIs.truncatePath((String)guri.getPath().toLowerCase()))) continue;
            filtered.add(guri);
        }
        return filtered;
    }

    private boolean ensureFolderURIExists(Database db, Transaction tr, Member member) {
        String scheme = this.url.getProtocol();
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (port == -1) {
            port = Rules.getDefaultPort((String)scheme);
        }
        String destinationFolder = this.url.getPath();
        while (true) {
            int slash;
            block8: {
                try {
                    String newPath = RuleUtils.replaceNonFolderCharsKeepSlashes((String)destinationFolder);
                    String encodedPath = RuleUtils.urlEncodeFilepath((String)newPath);
                    URI folderURI = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)encodedPath);
                    if (folderURI == null) {
                        String usertitle = newPath.equals(destinationFolder) ? null : URIRule.getFilenameAsString((String)newPath);
                        folderURI = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabelsGroupURIs((Database)db, (Transaction)tr, (String)scheme, (String)host, (Integer)port, (String)encodedPath, null, null, (String)usertitle, (String)"folder", null, (boolean)false, this.filterGroupURIs(newPath));
                        URIRule.addURIHistoryXLink((URI)folderURI, (Member)member, (Date)folderURI.getDateCreated(), (String)"upload", null, (Database)db);
                        this.createdFolderURIID.add(folderURI.getId());
                        if (this.destinationFolderURIID == null) {
                            this.destinationFolderURIID = folderURI.getId();
                        }
                        boolean foundGURI = false;
                        for (GroupURI guri : this.guris) {
                            if (!GroupURIs.truncatePath((String)guri.getPath()).equals(encodedPath.toLowerCase())) continue;
                            foundGURI = true;
                            break;
                        }
                        if (foundGURI) {
                            break;
                        }
                        break block8;
                    }
                    if (this.destinationFolderURIID != null) break;
                    this.destinationFolderURIID = folderURI.getId();
                    break;
                }
                catch (DatabaseException ex) {
                    if (ex.getMessage() != null && ex.getMessage().startsWith("URI already exist:")) break block8;
                    this.parent.fail("Failed to create URI for folder " + destinationFolder + ": " + ex.getMessage());
                    return false;
                }
            }
            if ((slash = destinationFolder.lastIndexOf(SLASH)) == -1) break;
            destinationFolder = destinationFolder.substring(0, slash);
        }
        return true;
    }

    private boolean invalidDocID(IncomingFile file, Database db, boolean isUrl, Member author) {
        String docid = file.getDocumentid();
        if (docid != null) {
            boolean different;
            URI otherURI;
            try {
                otherURI = DatabaseQuery.getUriByHostDocumentID((Database)db, (String)this.url.getHost(), (String)docid);
            }
            catch (QueryFailedException e) {
                this.parent.fail("Failed to connect to database: " + e.getMessage());
                return true;
            }
            boolean bl = different = otherURI != null;
            if (isUrl && different) {
                String urlString = file.getAttribute("url");
                different = urlString != null && !urlString.equals(URIRule.getURIString((URI)otherURI));
            } else if (different) {
                String path = this.buildPath(file.getPath());
                boolean bl2 = different = !path.equals(otherURI.getPath());
            }
            if (different) {
                Permissions perm = new Permissions();
                UserDetails details = new UserDetailsManager().get(db, author.getId(), false);
                if (!PermissionManager.check((Long)author.getId(), (UserDetails)details, (Database)db, (Permissions)perm, (PermissionCheck)new EditURICheck(otherURI))) {
                    this.parent.fail("There is already a URI with the Document ID " + docid + " (" + otherURI.getDecodedPath() + ")");
                    return true;
                }
            }
            if (!URIRule.isValidDocumentID((String)docid)) {
                this.parent.fail("Invalid Document ID " + docid);
                return true;
            }
        }
        return false;
    }

    private boolean moveFile(IncomingFile file, Database db) {
        File destination = this.computeDestination(file, db);
        if (!destination.getParentFile().exists() && !destination.getParentFile().mkdirs()) {
            this.parent.fail("Failed to create parent directory " + destination.getParent());
            return false;
        }
        if (file.getFile().isDirectory()) {
            file.setFile(destination);
            if (destination.exists() || destination.mkdir()) {
                return true;
            }
            this.parent.fail("Failed to create directory " + file.getPath());
            return false;
        }
        if (destination.exists()) {
            String absPath = destination.getAbsolutePath();
            File backup = new File(absPath + ".bak");
            this.cleanBackup(backup);
            if (!this.moveFile(destination, backup)) {
                this.parent.fail("Failed to save backup file " + backup.getAbsolutePath());
                return false;
            }
            this.backups.put(file.getPath(), backup);
            destination = new File(absPath);
        } else if (URIRule.isPSML((File)destination)) {
            this.stored.add(destination);
        }
        if (!this.moveFile(file.getFile(), destination)) {
            this.parent.fail("Failed to move file " + file.getPath());
            return false;
        }
        file.setFile(destination);
        return true;
    }

    private boolean moveFile(File source, File target) {
        int tries = 1;
        while (true) {
            try {
                FileUtils.moveFile((File)source, (File)target);
            }
            catch (IOException ex) {
                if (tries > 3) {
                    return false;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex1) {
                    this.parent.updateStatus(ProcessStage.Status.ERROR, "Failed to wait after trying to move file " + ex1.getMessage());
                    return false;
                }
                ++tries;
                continue;
            }
            break;
        }
        return true;
    }

    private URI registerFile(Database db, IncomingFile toRegister, Group group, Member author) throws DatabaseException, IOException {
        String scheme = this.url.getProtocol();
        String host = this.url.getHost();
        int port = this.url.getPort();
        if (port == -1) {
            port = Rules.getDefaultPort((String)scheme);
        }
        String path = this.buildPath(this.realPath(toRegister.getPath(), db));
        URI uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)path);
        String type = toRegister.getMediatype();
        if (type == null) {
            type = Medias.getMediaType((String)toRegister.getExtension());
        }
        String behavior = toRegister.getBehavior();
        boolean overwriteProps = this.overwriteProperties && ("psml".equalsIgnoreCase(toRegister.getExtension()) || toRegister.hasMetadataFile(this.loadingZone) && !this.filesWithMetadataCreated.contains(toRegister));
        boolean changed = false;
        boolean created = false;
        if (uri == null) {
            try {
                uri = URIRule.createURIForSchemeHostPortPathBehaviorDescUserTitleTypeLabelsGroupURIs((Database)db, null, (String)scheme, (String)host, (Integer)port, (String)path, (String)behavior, (String)toRegister.getDescription(), (String)toRegister.getUsertitle(), (String)type, (String[])toRegister.getLabels(), (boolean)false, this.filterGroupURIs(path));
                changed = true;
                created = true;
            }
            catch (DatabaseException e) {
                if (e.getMessage() != null && e.getMessage().startsWith("URI already exist:")) {
                    uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)scheme, (String)host, (Integer)port, (String)path);
                }
                throw e;
            }
            this.created.add(uri.getId());
        } else {
            boolean newDescriptionSpecified;
            boolean newTitleSpecified;
            boolean oldTitleSpecified = !Strings.isEmpty((String)uri.getUserTitle());
            boolean bl = newTitleSpecified = !Strings.isEmpty((String)toRegister.getUsertitle());
            if (newTitleSpecified && !oldTitleSpecified || overwriteProps && (!newTitleSpecified && oldTitleSpecified || newTitleSpecified && !toRegister.getUsertitle().equals(uri.getUserTitle()))) {
                uri.setUserTitle(toRegister.getUsertitle());
                changed = true;
            }
            if (type != null && !type.equals(uri.getType())) {
                changed = true;
            }
            if (changed) {
                this.commentUris.add(uri.getId());
            }
            String[] existingLabels = Labels.getLabels((URI)uri);
            if (toRegister.getLabels() != null && (existingLabels == null || existingLabels.length == 0) || overwriteProps && Labels.labelsAreDifferent((String[])existingLabels, (String[])toRegister.getLabels())) {
                Labels.setLabels((URI)uri, (String[])toRegister.getLabels());
                changed = true;
            }
            if (changed) {
                this.xrefUris.addAll(URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db));
            }
            boolean oldDescriptionSpecified = !Strings.isEmpty((String)uri.getDescription());
            boolean bl2 = newDescriptionSpecified = !Strings.isEmpty((String)toRegister.getDescription());
            if (newDescriptionSpecified && !oldDescriptionSpecified || overwriteProps && (!newDescriptionSpecified && oldDescriptionSpecified || newDescriptionSpecified && !toRegister.getDescription().equals(uri.getDescription()))) {
                uri.setDescription(toRegister.getDescription());
                changed = true;
            }
        }
        if (type != null && !type.equals(uri.getType())) {
            uri.setType(type);
            changed = true;
        }
        if (behavior != null && !behavior.equals(uri.getBehavior())) {
            uri.setBehavior(behavior);
            changed = true;
        }
        if (!URIRule.isPSML((URI)uri) && !"folder".equals(type)) {
            long size = toRegister.getFile().length();
            if (uri.getSize() == null || uri.getSize() != size) {
                uri.setSize(Long.valueOf(size));
            }
            changed = true;
        }
        changed = this.setDocumentID(toRegister, uri, author, overwriteProps, db) || changed;
        boolean bl = changed = this.setPublication(toRegister, uri, author, group, overwriteProps, db) || changed;
        if (changed) {
            uri.setLastModified(new Date());
            this.publicationUpdateUris.add(uri.getId());
        }
        return uri;
    }

    private boolean setDocumentID(IncomingFile toRegister, URI uri, Member author, boolean overwriteProps, Database db) {
        block16: {
            String docid = toRegister.getDocumentid();
            if (docid == null && !overwriteProps) {
                return false;
            }
            if (!URIRule.isValidDocumentID((String)docid)) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Ignoring invalid document ID \"" + docid + "\"");
                return false;
            }
            try {
                URI otherURI;
                String oldDocID = uri.getDocID();
                if (oldDocID != null && (!overwriteProps || oldDocID.equals(docid))) break block16;
                try {
                    otherURI = docid == null ? null : DatabaseQuery.getUriByHostDocumentID((Database)db, (String)uri.getHost().getName(), (String)docid);
                }
                catch (QueryFailedException ex) {
                    this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to set document ID: " + ex.getMessage());
                    return false;
                }
                if (overwriteProps || otherURI == null && oldDocID == null) {
                    boolean allowed = true;
                    if (otherURI != null) {
                        UserDetails details = new UserDetailsManager().get(db, author.getId(), false);
                        allowed = MemberRule.isContributorForURIIdFlag((Database)db, (Map)details.flags(), (Long)otherURI.getId(), (String)"c");
                        if (!allowed) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Invalid access to move existing Document ID (" + docid + ") of document \"" + otherURI.getDisplayTitle() + "\" to document \"" + uri.getDisplayTitle() + "\"");
                        } else {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Removing existing Document ID (" + docid + ") of document \"" + otherURI.getDecodedPath() + "\"");
                            otherURI.setDocID(null);
                            otherURI.setLastModified(new Date());
                        }
                    }
                    if (allowed) {
                        uri.setDocID(docid);
                        if (oldDocID != null && docid == null) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Removing existing Document ID (" + oldDocID + ") of document \"" + uri.getDisplayTitle() + "\"");
                        } else if (oldDocID != null && !docid.equals(oldDocID)) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Changing the existing Document ID (" + oldDocID + ") of document \"" + uri.getDisplayTitle() + "\" to the new Document ID \"" + docid + "\"");
                        }
                        return true;
                    }
                } else if (otherURI != null && oldDocID == null) {
                    this.parent.updateStatus(ProcessStage.Status.WARNING, "Ignoring Document ID (" + docid + ") as it's already used by document \"" + otherURI.getDecodedPath() + "\" and overwrite-properties is false");
                }
            }
            catch (DatabaseException ex) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to handle document ID: " + ex.getMessage());
            }
        }
        return false;
    }

    private boolean setPublication(IncomingFile toRegister, URI uri, Member author, Group group, boolean overwriteProps, Database db) {
        String publicationtype;
        String publicationid = toRegister.getAttribute("publication-id");
        if (publicationid == null) {
            return false;
        }
        if (!Publications.isValidPublicationID((String)publicationid)) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Ignoring invalid publication ID \"" + publicationid + "\"");
            return false;
        }
        String attributeType = toRegister.getAttribute("publication-type");
        String string = publicationtype = attributeType == null || attributeType.isEmpty() ? "default" : attributeType;
        if (!Publications.isValidPublicationType((String)publicationtype)) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Invalid publication type \"" + publicationtype + "\", using \"default\" instead");
            publicationtype = "default";
        }
        try {
            URI otherURI;
            Publication otherPub;
            Publication existingPub = DatabaseQuery.getPublicationByRootURI((Database)db, (URI)uri, (boolean)true);
            try {
                otherPub = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)publicationid, (Host)uri.getHost());
            }
            catch (ObjectStateException ex) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Cannot set publication " + publicationid + " on document \"" + uri.getDisplayTitle() + "\" as it was already used by another document in this upload");
                return false;
            }
            URI uRI = otherURI = otherPub == null ? null : DatabaseQuery.getURIById((Database)db, (Long)otherPub.getRootURIId());
            if (otherPub != null && existingPub != null && !publicationid.equals(existingPub.getId())) {
                this.parent.updateStatus(ProcessStage.Status.WARNING, "Cannot set publication " + publicationid + " on document \"" + uri.getDisplayTitle() + "\" as it is already used by document \"" + otherURI.getDecodedPath() + "\", existing publication must be removed first");
            } else if (otherPub != null && existingPub != null && publicationid.equals(existingPub.getId()) && !publicationtype.equals(existingPub.getType()) && overwriteProps) {
                Publications.edit((Database)db, (Publication)existingPub, (String)publicationid, (String)publicationtype);
                this.publicationUpdates.add(new PublicationUpdate(existingPub, UpdateType.MODIFIED));
            } else if (existingPub == null || overwriteProps && !publicationid.equals(existingPub.getId())) {
                if (!overwriteProps && otherPub != null) {
                    this.parent.updateStatus(ProcessStage.Status.WARNING, "Cannot set publication " + publicationid + " on document \"" + uri.getDisplayTitle() + "\" as it is already used by document \"" + otherURI.getDecodedPath() + "\" and overwrite-properties is false");
                } else if (overwriteProps || existingPub == null) {
                    boolean allowed = true;
                    if (otherPub != null) {
                        UserDetails details = new UserDetailsManager().get(db, author.getId(), false);
                        boolean bl = allowed = details == null || MemberRule.isContributorForURIIdFlag((Database)db, (Map)details.flags(), (Long)otherPub.getRootURIId(), (String)"c");
                        if (!allowed) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Invalid access to move existing publication (" + publicationid + ") of document \"" + otherURI.getDecodedPath() + "\" to document \"" + uri.getDisplayTitle() + "\"");
                        } else {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Moving existing publication (" + publicationid + ") of document \"" + otherURI.getDecodedPath() + "\" to document \"" + uri.getDisplayTitle() + "\"");
                        }
                    }
                    if (allowed) {
                        Publication newPub;
                        if (existingPub != null) {
                            newPub = Publications.edit((Database)db, (Publication)existingPub, (String)publicationid, (String)publicationtype);
                            this.publicationUpdates.add(new PublicationUpdate(existingPub, UpdateType.DELETED));
                            this.publicationUpdates.add(new PublicationUpdate(newPub, UpdateType.MODIFIED_ID));
                        } else {
                            newPub = Publications.create((Database)db, (Member)author, (String)publicationid, (URI)uri, (Group)group, (String)publicationtype);
                            if (otherPub != null) {
                                this.publicationUpdates.add(new PublicationUpdate(newPub, UpdateType.MODIFIED));
                            } else {
                                this.publicationUpdates.add(new PublicationUpdate(newPub, UpdateType.CREATED));
                            }
                        }
                        if (existingPub != null && !publicationid.equals(existingPub.getId())) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Changing the existing publication (" + existingPub.getId() + ") of document \"" + uri.getDisplayTitle() + "\" to the new publication \"" + publicationid + "\"");
                        }
                        return true;
                    }
                }
            }
        }
        catch (URIException ex) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Can't move a publication onto an existing one: " + ex.getMessage());
        }
        catch (DatabaseException ex) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to handle publication: " + ex.getMessage());
        }
        return false;
    }

    private URI registerURL(Database db, IncomingFile toRegister, Member author) throws DatabaseException {
        String urlString = toRegister.getAttribute("url");
        if (urlString == null) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Ignoring URL " + toRegister.getPath() + " with missing/invalid scheme, host, port or decodedpath");
            return null;
        }
        String sizeString = toRegister.getAttribute("size");
        long size = sizeString == null || sizeString.isEmpty() ? -1L : Long.parseLong(sizeString, 10);
        UserDetails userdetails = new UserDetailsManager().get(db, author.getId(), false);
        boolean uriOwner = PermissionManager.check((Long)author.getId(), (UserDetails)userdetails, (Database)db, (Permissions)new Permissions(), (PermissionCheck)new EditAllURLsCheck());
        String mediatype = toRegister.getMediatype();
        if ("application/vnd.pageseeder.psml+xml".equals(mediatype)) {
            mediatype = null;
        }
        URLCreator creator = new URLCreator(author, uriOwner);
        creator.setOverwrite(true, this.overwriteProperties && uriOwner);
        creator.setFromUpload(true, this.uriHistoryEventLabels);
        creator.setDetails(toRegister.getUsertitle(), toRegister.getDescription(), toRegister.getAttribute("document-type"), mediatype, size, toRegister.getLabels());
        try {
            URI uri = creator.create(urlString, db, false);
            if (!creator.wasExistingURI()) {
                this.created.add(uri.getId());
            }
            if (creator.propertiesChanged()) {
                this.xrefUris.addAll(URIRule.updateLastModifedForXRefs((URI)uri, (Date)new Date(), (Database)db));
                this.commentUris.add(uri.getId());
            }
            return uri;
        }
        catch (URLException ex) {
            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to create URL " + toRegister.getPath() + ": " + ex.getMessage());
            return null;
        }
    }

    private String buildPath(String filepath) {
        Object path = this.url.getPath();
        if (((String)path).charAt(0) != '/') {
            path = SLASH + (String)path;
        }
        if (filepath.charAt(0) != '/') {
            path = (String)path + SLASH;
        }
        path = (String)path + filepath;
        return RuleUtils.urlEncodeFilepath((String)path);
    }

    private String buildPathFromURI(String filepath, URI uri) {
        if (uri == null) {
            return filepath;
        }
        Object path = this.url.getPath();
        if (((String)path).charAt(0) != '/') {
            path = SLASH + (String)path;
        }
        if (filepath.charAt(0) != '/') {
            path = (String)path + SLASH;
        }
        return uri.getDecodedPath().substring(((String)path).length());
    }

    public static final class PublicationUpdate {
        public final Publication publication;
        public final UpdateType type;

        public PublicationUpdate(Publication pub, UpdateType t) {
            this.publication = pub;
            this.type = t;
        }
    }

    public static enum UpdateType {
        CREATED,
        DELETED,
        MODIFIED,
        MODIFIED_ID;

    }
}

