/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.db.model.Group;
import com.pageseeder.load.AntScript;
import com.pageseeder.load.LoadingZone;

public final class PreviewThread
extends ProcessThread {
    private AntScript _script;

    PreviewThread(String username, Group group, LoadingZone zone) {
        super(username, "Preview", group);
    }

    public void setAntScript(AntScript script) {
        this._script = script;
    }

    public void cancel() {
        super.cancel();
        if (this._script != null) {
            this._script.cancel();
        }
    }

    public void process() {
        if (this._script == null) {
            this.fail("No preview script to run!");
        } else {
            try {
                this.setName("Preview of " + this._script.getProcessedFile().getPath());
                this._script.run();
            }
            catch (Exception ex) {
                this.fail("Loading Thread failed: " + ex.getMessage());
            }
        }
        this.complete("Success!!");
    }

    public void writeThreadElements(OutputPrinter out) {
        if (this._script != null) {
            this._script.print(out);
        }
    }
}

