/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.load.IncomingFile;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class OverwriteSummary {
    private static final FileFilter VISIBLE_FOLDERS = f -> f.isDirectory() && f.getName().charAt(0) != '.';
    public static final OverwriteSummary CONFLICT_SUMMARY = new OverwriteSummary(null, null);
    private static final int MAX_PER_FOLDER = 100;
    private static final int MAX_TOTAL = 1000;
    private int totalOverwritesAdded = 0;
    private int totalNewAdded = 0;
    private int totalExistingAdded = 0;
    private final File destinationFolder;
    private final String destinationPath;
    private final Map<String, IncomingFile> filesToOverwrite = new HashMap<String, IncomingFile>();
    private final Map<String, File> existingFiles = new HashMap<String, File>();
    private final Map<String, IncomingFile> filesToCreate = new HashMap<String, IncomingFile>();
    private final Set<String> urlFolders = new HashSet<String>();
    private final Collection<IncomingFile> urlsToOverwrite = new ArrayList<IncomingFile>();
    private final Collection<IncomingFile> urlsToCreate = new ArrayList<IncomingFile>();
    private final Map<String, List<String>> paths = new HashMap<String, List<String>>();
    private String xml = "";

    public OverwriteSummary(File destinationfolder, String destinationpath) {
        this.destinationPath = destinationpath;
        this.destinationFolder = destinationfolder;
        if (this.destinationFolder != null) {
            ArrayList<String> subpaths = new ArrayList<String>();
            File[] children = this.destinationFolder.listFiles(VISIBLE_FOLDERS);
            if (children != null) {
                for (File f : children) {
                    this.existingFiles.put(f.getName(), f);
                    subpaths.add(f.getName());
                }
            }
            this.paths.put("/", subpaths);
        }
    }

    public void addExistingObject(IncomingFile f) {
        f.setAttribute("overwrite", "true");
        boolean isUrl = f.getPath().startsWith("META-INF/_urls/");
        if (isUrl) {
            this.urlsToOverwrite.add(f);
            this.storeUrlPath(f.getPath());
        } else {
            this.filesToOverwrite.put(f.getPath(), f);
            this.existingFiles.remove(f.getPath());
            this.storePath(f.getPath());
        }
    }

    public void addObjectToCreate(IncomingFile f) {
        f.setAttribute("create", "true");
        boolean isUrl = f.getPath().startsWith("META-INF/_urls/");
        if (isUrl) {
            this.urlsToCreate.add(f);
            this.storeUrlPath(f.getPath());
        } else {
            this.filesToCreate.put(f.getPath(), f);
            this.storePath(f.getPath());
        }
    }

    private void storeUrlPath(String path) {
        String relative = path.substring(15);
        int slash = relative.indexOf(47);
        Object current = "META-INF/_urls";
        while (slash != -1) {
            current = (String)current + "/" + relative.substring(0, slash);
            this.urlFolders.add((String)current);
            relative = relative.substring(slash + 1);
            slash = relative.indexOf(47);
        }
    }

    private void storePath(String path) {
        int slash = -1;
        String before = "/";
        do {
            File target;
            List<String> thissubpaths;
            List<String> subpaths;
            if ((subpaths = this.paths.get(before)) == null) {
                subpaths = new ArrayList<String>();
                this.paths.put(before, subpaths);
            }
            String string = before = (slash = path.indexOf(47, slash + 1)) == -1 ? path : path.substring(0, slash);
            if (!subpaths.contains(before)) {
                subpaths.add(before);
            }
            if ((thissubpaths = this.paths.get(before)) != null || !(target = new File(this.destinationFolder, before)).isDirectory()) continue;
            thissubpaths = new ArrayList<String>();
            this.paths.put(before, thissubpaths);
            File[] children = target.listFiles(VISIBLE_FOLDERS);
            if (children == null) continue;
            for (File f : children) {
                String thispath = (String)("/".equals(before) ? "" : before + "/") + f.getName();
                this.existingFiles.put(thispath, f);
                if (thissubpaths.contains(thispath)) continue;
                thissubpaths.add(thispath);
            }
        } while (slash != -1);
    }

    public boolean isEmpty() {
        return this.filesToCreate.isEmpty() && this.filesToOverwrite.isEmpty() && this.urlsToOverwrite.isEmpty() && this.urlsToCreate.isEmpty();
    }

    public String getXML() {
        return this.xml;
    }

    public void printToXML(Database db) throws QueryFailedException {
        XMLOutputPrinter out = new XMLOutputPrinter();
        this.print((OutputPrinter)out, db);
        this.xml = out.toString();
    }

    public void print(OutputPrinter out, Database db) throws QueryFailedException {
        if (!this.isEmpty()) {
            out.startObject("overwrite-summary");
            out.field("destination", this.destinationPath);
            int nbOverwrites = 0;
            for (IncomingFile f : this.filesToOverwrite.values()) {
                if ("folder".equals(f.getMediatype())) continue;
                ++nbOverwrites;
            }
            out.field("file-overwrites", (long)nbOverwrites);
            int nbNew = 0;
            for (IncomingFile f : this.filesToCreate.values()) {
                if ("folder".equals(f.getMediatype())) continue;
                ++nbNew;
            }
            out.field("file-new", (long)nbNew);
            out.field("url-overwrites", (long)this.urlsToOverwrite.size());
            out.field("url-new", (long)this.urlsToCreate.size());
            out.startObject("files");
            if (nbNew > 0 || nbOverwrites > 0) {
                out.startObject("file");
                out.field("name", this.destinationFolder.getName());
                out.field("path", "/");
                out.field("type", "folder");
                this.printFolder("/", out, db);
                out.endObject();
            }
            out.endObject();
            out.startObject("urls");
            if (!this.urlsToOverwrite.isEmpty() || !this.urlsToCreate.isEmpty()) {
                out.startObject("file");
                out.field("name", "URLs");
                out.field("path", "/META-INF/_urls");
                out.field("type", "folder");
                this.printUrlsFolder("META-INF/_urls", out);
                out.endObject();
            }
            out.endObject();
            out.endObject();
        }
    }

    private void printUrlsFolder(String path, OutputPrinter out) {
        int nbOverwrites = 0;
        ArrayList<IncomingFile> overwriteChildren = new ArrayList<IncomingFile>();
        for (IncomingFile f : this.urlsToOverwrite) {
            String sub;
            if (!f.getPath().startsWith(path + "/") || (sub = f.getPath().substring(path.length() + 1)).indexOf(47) != -1) continue;
            ++nbOverwrites;
            if (overwriteChildren.size() >= 100 || this.totalOverwritesAdded >= 1000) continue;
            ++this.totalOverwritesAdded;
            overwriteChildren.add(f);
        }
        int nbCreate = 0;
        ArrayList<IncomingFile> createChildren = new ArrayList<IncomingFile>();
        for (IncomingFile f : this.urlsToCreate) {
            String sub;
            if (!f.getPath().startsWith(path + "/") || (sub = f.getPath().substring(path.length() + 1)).indexOf(47) != -1) continue;
            ++nbCreate;
            if (createChildren.size() >= 100 || this.totalNewAdded >= 1000) continue;
            ++this.totalNewAdded;
            createChildren.add(f);
        }
        out.field("overwrites", (long)nbOverwrites);
        out.field("new", (long)nbCreate);
        for (String subpath : this.urlFolders) {
            if (!subpath.startsWith(path + "/") || subpath.substring(path.length() + 1).indexOf(47) != -1) continue;
            String[] elems = subpath.split("/");
            out.startObject("file");
            out.field("name", elems[elems.length - 1]);
            out.field("path", subpath);
            out.field("type", "folder");
            this.printUrlsFolder(subpath, out);
            out.endObject();
        }
        for (IncomingFile f : overwriteChildren) {
            if (f.getFile().isDirectory()) continue;
            f.print(out);
        }
        for (IncomingFile f : createChildren) {
            if (f.getFile().isDirectory()) continue;
            f.print(out);
        }
    }

    private void printFolder(String path, OutputPrinter out, Database db) throws QueryFailedException {
        List<String> subpaths;
        File target = new File(this.destinationFolder, path);
        int children = DatabaseQuery.getNumberURIFilesByParentPath((Database)db, (String)(this.destinationPath + (String)("/".equals(path) ? "" : "/" + path)));
        if (children > 0) {
            out.field("existing", (long)children);
        }
        if ((subpaths = this.paths.get(path)) != null) {
            IncomingFile f;
            boolean overwrite;
            int nbOverwrites = 0;
            int nbNew = 0;
            for (String subpath : subpaths) {
                if (this.filesToCreate.containsKey(subpath) && !"folder".equals(this.filesToCreate.get(subpath).getMediatype())) {
                    ++nbNew;
                    continue;
                }
                if (!this.filesToOverwrite.containsKey(subpath) || "folder".equals(this.filesToOverwrite.get(subpath).getMediatype())) continue;
                ++nbOverwrites;
            }
            out.field("overwrites", (long)nbOverwrites);
            out.field("new", (long)nbNew);
            Collections.sort(subpaths);
            int overwritesAdded = 0;
            int newAdded = 0;
            int existingAdded = 0;
            for (String subpath : subpaths) {
                overwrite = this.filesToOverwrite.containsKey(subpath);
                if (!"/".equals(path) && (!overwrite || overwritesAdded >= 100 || this.totalOverwritesAdded >= 1000) && (overwrite || newAdded >= 100 || this.totalNewAdded >= 1000)) continue;
                f = this.filesToCreate.get(subpath);
                if (f == null) {
                    f = this.filesToOverwrite.get(subpath);
                }
                if (f != null) {
                    if (!f.getFile().isDirectory()) continue;
                    f.print(out, false);
                    this.printFolder(f.getPath(), out, db);
                    out.endObject();
                    if (overwrite) {
                        ++overwritesAdded;
                        ++this.totalOverwritesAdded;
                        continue;
                    }
                    ++newAdded;
                    ++this.totalNewAdded;
                    continue;
                }
                File folder = this.existingFiles.get(subpath);
                if (folder == null || existingAdded >= 100 || this.totalExistingAdded >= 1000) continue;
                new UniversalPrinter(out).writeFile(folder, this.destinationFolder, 0, false, null);
                ++existingAdded;
                ++this.totalExistingAdded;
            }
            for (String subpath : subpaths) {
                overwrite = this.filesToOverwrite.containsKey(subpath);
                if ((!overwrite || overwritesAdded >= 100 || this.totalOverwritesAdded >= 1000) && (overwrite || newAdded >= 100 || this.totalNewAdded >= 1000)) continue;
                f = this.filesToCreate.get(subpath);
                if (f == null) {
                    f = this.filesToOverwrite.get(subpath);
                }
                if (f == null || f.getFile().isDirectory()) continue;
                f.print(out);
                if (overwrite) {
                    ++overwritesAdded;
                    ++this.totalOverwritesAdded;
                    continue;
                }
                ++newAdded;
                ++this.totalNewAdded;
            }
        }
    }
}

