/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.load;

import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.comment.Comments;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.model.XLink;
import com.pageseeder.db.util.URIs;
import com.pageseeder.load.LoadingThreadAction;
import com.pageseeder.load.Register;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pageseeder.xmlwriter.XMLWriter;

public final class Index
implements LoadingThreadAction {
    private final Map<Long, Boolean> uriids = new HashMap<Long, Boolean>();
    private final Map<Long, Long> workflowids = new HashMap<Long, Long>();
    private Set<Long> commentUris = new HashSet<Long>();
    private List<Register.PublicationUpdate> publicationUpdates = new ArrayList<Register.PublicationUpdate>();
    private int alreadyProcessed = 0;
    private boolean cancelled = false;
    private final ProcessThread parent;

    public Index(ProcessThread dad) {
        this.parent = dad;
    }

    public void addWorkflow(Long uriid, Long workflowid) {
        if (uriid != null && workflowid != null) {
            this.workflowids.put(uriid, workflowid);
        }
    }

    public void addURI(Long uriid, boolean created) {
        if (uriid != null) {
            this.uriids.put(uriid, created);
        }
    }

    public void addURIs(Map<Long, Boolean> uids) {
        if (uids != null) {
            this.uriids.putAll(uids);
        }
    }

    public void setPublicationUpdates(List<Register.PublicationUpdate> updates) {
        this.publicationUpdates = updates;
    }

    public void setCommentUris(Set<Long> uriids) {
        this.commentUris = uriids;
    }

    public void toXML(XMLWriter xml) {
        this.print((OutputPrinter)new XMLOutputPrinter(xml));
    }

    public void print(OutputPrinter out) {
        out.startObject("action");
        out.field("current", (long)this.alreadyProcessed);
        out.field("total", (long)(this.uriids.size() + this.publicationUpdates.size()));
        out.field("name", this.name(), OutputPrinter.FieldOption.XML_TEXT);
        out.endObject();
    }

    @Override
    public String name() {
        return "Index";
    }

    @Override
    public void cancel() {
        this.cancelled = true;
    }

    public void run() {
        ChangesManager changes = ChangesManager.getInstance();
        String batchName = "Indexing " + this.uriids.size() + " URIs modified by upload";
        ChangesBatch batch = new ChangesBatch(batchName);
        try (Database db = Database.open();){
            Transaction tr;
            block35: {
                if (this.cancelled) {
                    return;
                }
                changes.startBatch(db, batch);
                tr = new Transaction(db);
                tr.begin();
                for (Long uriid : this.uriids.keySet()) {
                    if (this.cancelled) break;
                    try {
                        XLink xl;
                        Collection<Object> grps;
                        URI uri = DatabaseQuery.getURIById((Database)db, (Long)uriid);
                        if (uri == null) {
                            this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to index URI: Invalid URI ID " + uriid);
                            ++this.alreadyProcessed;
                            continue;
                        }
                        boolean external = URIs.isExternal((URI)uri);
                        Collection<Object> collection = grps = external ? Collections.emptyList() : DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId());
                        if (this.uriids.get(uriid).booleanValue()) {
                            changes.createURI(db, batch, uri, grps);
                        } else {
                            changes.modifyURI(db, batch, uri, grps);
                        }
                        Long workflowid = this.workflowids.get(uri.getId());
                        if (workflowid != null && (xl = DatabaseQuery.getXLinkById((Database)db, (Long)workflowid)) != null) {
                            if (external) {
                                grps = Collections.singleton(DatabaseQuery.getGroupById((Database)db, (Long)this.parent.getGroupID()));
                            }
                            changes.createWorkflow(db, batch, xl, grps);
                        }
                        if (this.commentUris.contains(uriid)) {
                            Comments.indexCommentsTasksWorkflows(db, uri, changes, batch);
                        }
                        ++this.alreadyProcessed;
                        this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "Indexed URI " + uriid);
                    }
                    catch (DatabaseException ex) {
                        this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to index URI " + uriid + ": " + ex.getMessage());
                    }
                }
                for (Register.PublicationUpdate update : this.publicationUpdates) {
                    if (this.cancelled) break;
                    Publication pub = update.publication;
                    try {
                        if (update.type == Register.UpdateType.CREATED) {
                            changes.createPublication(db, batch, pub, Collections.emptyList());
                        } else if (update.type == Register.UpdateType.DELETED) {
                            changes.deletePublication(db, batch, pub, Collections.emptyList());
                        } else if (update.type == Register.UpdateType.MODIFIED) {
                            URI uri = DatabaseQuery.getURIById((Database)db, (Long)pub.getRootURIId());
                            if (uri == null) {
                                this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to index publication: Invalid URI ID " + pub.getRootURIId());
                            } else {
                                changes.modifyPublication(db, batch, pub, Collections.emptyList(), Collections.singleton(uri), Collections.emptyList(), Collections.emptyList());
                            }
                        } else if (update.type == Register.UpdateType.MODIFIED_ID) {
                            XLink pub_xlink = DatabaseQuery.getXLinkById((Database)db, (Long)pub.getXLinkId());
                            Collection publicationURIs = DatabaseQuery.getURIsForPublication((Database)db, (XLink)pub_xlink);
                            changes.createPublication(db, batch, pub, publicationURIs);
                        }
                        ++this.alreadyProcessed;
                        this.parent.updateStatus(ProcessStage.Status.INPROGRESS, "Indexed publication " + pub.getId());
                    }
                    catch (DatabaseException ex) {
                        this.parent.updateStatus(ProcessStage.Status.WARNING, "Failed to index publication " + pub.getId() + ": " + ex.getMessage());
                    }
                }
                changes.completeBatch(db, batch);
                if (!this.cancelled) break block35;
                tr.abort();
                return;
            }
            try {
                tr.commit();
            }
            catch (DatabaseException ex) {
                this.parent.fail("Failed to index : " + ex.getMessage());
                tr.abort();
            }
        }
        catch (OpenDatabaseException e) {
            this.parent.fail("Failed to open the database:" + e.getMessage());
        }
    }
}

