/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.thread.ProcessManager;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.PublicAPI;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.thread.HostModifyURIsThread;
import java.io.IOException;

@Requires(member=true, parameters={"host"})
@Output(types={OutputType.XML, OutputType.JSON})
@PublicAPI
public final class ModifyURIs
implements Generator,
SingleCheck {
    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        HostModifyURIsThread thread = new HostModifyURIsThread(req.getMember().getUsername(), req.getParameter((Parameter)StandardParameters.host));
        thread.setNewScheme(req.getParameter((Parameter)StandardParameters.scheme));
        long port = req.getParameter((Parameter)StandardParameters.port, -1L);
        if (port != -1L) {
            thread.setNewPort((int)port);
        }
        ProcessManager manager = ProcessManager.getInstance();
        manager.start((ProcessThread)thread);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("host-update");
        thread.print((OutputPrinter)out);
        out.endObject();
        res.setStatus(GeneratorStatus.ACCEPTED);
    }
}

