/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.ContentPermission;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.model.Host;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;

@Requires(database=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetExternalHosts
implements Generator,
SingleCheck {
    private static final int MAX_NB_RESULTS = 200;

    @ContentPermission(value=AdminSystemCheck.class)
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        List hosts;
        Logger logger = req.getLogger((Object)this);
        int page = Long.valueOf(req.getParameter((Parameter)StandardParameters.page, 1L)).intValue();
        int pagesize = Long.valueOf(req.getParameter((Parameter)StandardParameters.pagesize, 200L)).intValue();
        try {
            hosts = DatabaseQuery.getAllHostsAlpha((Database)req.getDatabase(), (boolean)true, (int)page, (int)pagesize, (boolean)false);
        }
        catch (QueryFailedException ex) {
            logger.error("Failed to load all hosts", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load external hosts from DB: " + ex.getMessage());
            return;
        }
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("hosts");
        out.startCollection("hosts", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Host host : hosts) {
            out.writeHost(host);
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }
}

