/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.host;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.AdminSystemCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.HostAlias;
import com.pageseeder.host.HostErrorID;
import com.pageseeder.host.Hosts;
import java.io.IOException;

@Requires(parameters={"hostname", "aliasname"})
@Output(types={OutputType.XML, OutputType.JSON})
public class CreateHostalias
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new AdminSystemCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Database db = req.getDatabase();
        String hostName = req.getParameter((Parameter)StandardParameters.hostname);
        String aliasName = req.getParameter((Parameter)StandardParameters.aliasname);
        hostName = hostName.toLowerCase();
        aliasName = aliasName.toLowerCase();
        Host host = DatabaseQuery.getHostByName((Database)db, (String)hostName);
        if (host == null) {
            res.setError(GeneratorStatus.NOT_FOUND, "Host " + hostName + " was not found.");
            return;
        }
        if (!Hosts.checkHostName(aliasName, res)) {
            return;
        }
        if (DatabaseQuery.getHostByName((Database)db, (String)aliasName) != null || DatabaseQuery.getHostAliasByName((Database)db, (String)aliasName) != null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)HostErrorID.NAME_ALREADY_EXISTS, "The host alias name is already in use.");
            return;
        }
        HostAlias alias = HostAlias.create((Database)db);
        alias.setName(aliasName);
        host.addHostAliases(alias);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject("alias-creation");
        out.startObject("alias");
        out.field("id", alias.getId().longValue());
        out.field("name", alias.getName());
        out.endObject();
        out.endObject();
        out.flush();
    }
}

