/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.help;

import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.common.properties.Settings;
import com.pageseeder.common.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import org.pageseeder.xmlwriter.XMLWriter;

@Requires(parameters={"path"})
public final class GetHelpContent
implements Generator,
SingleCheck {
    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        return new NoCheck();
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws IOException {
        String path = req.getParameter((Parameter)StandardParameters.path);
        File helpFile = new File(Settings.getContextPath() + "weborganic" + File.separator + "help" + File.separator + path + ".psml");
        try {
            Path filePath = helpFile.toPath();
            if (Files.isReadable(filePath)) {
                byte[] helpBytes = Files.readAllBytes(filePath);
                StringBuffer psml = new StringBuffer(new String(helpBytes, StandardCharsets.UTF_8));
                String helpContent = XMLUtils.removeXMLDeclaration((StringBuffer)psml).toString();
                XMLWriter xml = res.getXMLWriter();
                xml.openElement("help-file");
                xml.attribute("path", path);
                xml.writeXML(helpContent);
                xml.closeElement();
                xml.flush();
            } else {
                res.setError(GeneratorStatus.NOT_FOUND, "Unable to find readable help file at this location");
            }
        }
        catch (InvalidPathException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, "Invalid path for help file");
        }
    }
}

