/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.groupfolder;

import com.pageseeder.base.generator.ErrorID;

public enum GroupFolderErrorID implements ErrorID
{
    DEFAULT_GROUP_FOLDER_MISSING(25601, "There is no default group folder for the group."),
    INVALID_URL(5121, "Invalid URL."),
    UNKNOWN_HOST(5122, "Unknown host."),
    GROUP_FOLDER_EXISTS(5123, "Group folder already exists."),
    GROUP_FOLDER_NOT_FOUND(5124, "Group folder not found."),
    GROUP_FOLDER_NOT_IN_GROUP(5125, "Group folder not in group."),
    INVALID_ID(5126, "Invalid group folder ID."),
    IN_ANOTHER_DEFAULT_GROUP_FOLDER(5127, "Group folder is in the default group folder for another group."),
    ID_NOT_IN_GROUP(5128, "Group folder ID not in group."),
    PUBLIC_OR_GROUPS_REQUIRED(5130, "A valid public, groups or editgroups parameter is required."),
    INVALID_PATH(5131, "Invalid path."),
    PATH_NOT_IN_GROUP(5132, "Group folder path not in group."),
    INVALID_GROUP(5133, "Invalid group."),
    GROUP_FOLDER_NOT_OWNED(5134, "Group folder not owned by group."),
    GROUPS_REQUIRED(5135, "A valid groups parameter is required."),
    OWNER_GROUP(5136, "The groups parameter can not contain the owner group."),
    GROUP_IN_GROUPS_AND_EDITGROUPS(5137, "A group can not be in both the groups and editgroups parameters."),
    DESCENDANT_SHARED_GROUP_FOLDER(5138, "Cannot create a group folder as there is already a descendant shared group folder."),
    ANCESTOR_SHARED_GROUP_FOLDER(5139, "Cannot create a group folder as there is already an ancestor shared group folder.");

    private final int _id;
    private final String _message;

    private GroupFolderErrorID(int id, String message) {
        if (id < 0) {
            throw new IndexOutOfBoundsException("Error ID must be >= 0");
        }
        this._id = id;
        this._message = message;
    }

    public int id() {
        return this._id;
    }

    public String message() {
        return this._message;
    }
}

