/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.MemberForGroupRule;
import com.pageseeder.base.rule.Membership;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.Predicate;
import com.pageseeder.db.Predicates;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.group.GroupErrorID;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Requires(database=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class ListProjectsAsTree
implements Generator,
SingleCheck {
    private static final long DEFAULT_MAX_NB = 1000L;
    private static final String NO_PROJECT = "";
    private static final Comparator<Group> SORT_BY_GROUP_NAME = new Comparator<Group>(){

        @Override
        public int compare(Group g1, Group g2) {
            return g1.getName().compareTo(g2.getName());
        }
    };
    private static final Comparator<Membership> SORT_BY_MEMBERSHIP_GROUP_NAME = new Comparator<Membership>(){

        @Override
        public int compare(Membership m1, Membership m2) {
            return m1.getGroup().getName().compareTo(m2.getGroup().getName());
        }
    };

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        if ("server".equals(req.getParameter((Parameter)StandardParameters.for_))) {
            return new CreateProjectCheck();
        }
        return new ViewMemberCheck(req.getMember());
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Group context;
        Database db = req.getDatabase();
        Member m = req.getMember();
        int results = (int)req.getParameter((Parameter)StandardParameters.resultsize, 1000L);
        Object nameprefix = req.getParameter((Parameter)StandardParameters.nameprefix);
        String relationship = req.getParameter((Parameter)StandardParameters.relationship, "descendants");
        boolean include_groups = req.getParameter((Parameter)StandardParameters.groups, true);
        boolean server = "server".equals(req.getParameter((Parameter)StandardParameters.for_));
        boolean archived = req.getParameter((Parameter)StandardParameters.archived, false);
        boolean children = relationship.equals("children");
        HashMap<String, Group> registered = new HashMap<String, Group>();
        HashMap<Group, String> subgroups = new HashMap<Group, String>();
        Group group = context = req.getParameter((Parameter)StandardParameters.allprojects, false) ? null : req.getGroup();
        if (context != null) {
            if (nameprefix == null || context.getName().startsWith((String)nameprefix)) {
                nameprefix = context.getName() + "-";
            } else if (!((String)nameprefix).startsWith(context.getName() + "-")) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_NAMEPREFIX_PARAMETER, "The nameprefix parameter is not valid for project: " + context.getName());
                return;
            }
        }
        if (server) {
            List grps = DatabaseQuery.getGroupsByNameprefix((Database)db, (int)1, (int)results, (String)nameprefix, (boolean)archived, (!children ? 1 : 0) != 0, (boolean)include_groups, (boolean)false);
            for (Group group2 : grps) {
                registered.put(group2.getName(), group2);
            }
        } else {
            Predicate p = Predicates.predicateMemberForGroupRegistered((Database)db, (boolean)archived);
            p.setOrdering("this.group.name ascending");
            Iterator memberships = MemberForGroupRule.getMemberMemberships((Collection)m.getGroupsForMemberCol((Object)p), (boolean)true, (Database)db);
            if (memberships.size() > results) {
                memberships.sort(SORT_BY_MEMBERSHIP_GROUP_NAME);
            }
            int total = 0;
            Iterator iterator = memberships.iterator();
            while (iterator.hasNext()) {
                Membership membership = (Membership)iterator.next();
                Group group3 = membership.getGroup();
                if (ListProjectsAsTree.isGroupVisible(group3, (String)nameprefix, archived)) {
                    if (total < results) {
                        registered.put(group3.getName(), group3);
                    }
                    ++total;
                }
                if (!membership.isSubGroupMember()) continue;
                subgroups.put(membership.getGroup(), membership.getSubgroupsAsString());
            }
        }
        if (!server || nameprefix != null || archived) {
            HashSet<String> parents = new HashSet<String>();
            for (String name : registered.keySet()) {
                ListProjectsAsTree.addMissingParents(name, registered, parents);
            }
            for (String parent : parents) {
                Group group4 = DatabaseQuery.getGroupByName((Database)db, (String)parent);
                if (group4 == null) continue;
                registered.put(group4.getName(), group4);
            }
        }
        ArrayList groups = new ArrayList(registered.values());
        groups.sort(SORT_BY_GROUP_NAME);
        HashMap<String, List<Group>> projects = new HashMap<String, List<Group>>();
        int project_len = context != null ? context.getName().length() + 1 : 0;
        ArrayList<Group> top_level = new ArrayList<Group>();
        for (Group g : groups) {
            if (context != null && !g.getName().startsWith(context.getName() + "-")) continue;
            if (g.getName().indexOf(45, project_len) == -1) {
                top_level.add(g);
            } else if (children) continue;
            if (GroupRule.isProject((Group)g)) {
                projects.put(g.getName(), new ArrayList());
            }
            if (g.getName().indexOf(45) == -1 || !include_groups && !GroupRule.isProject((Group)g)) continue;
            String project = ListProjectsAsTree.getParentName(g);
            ArrayList<Group> sub = (ArrayList<Group>)projects.get(project);
            if (sub == null) {
                sub = new ArrayList<Group>();
                projects.put(project, sub);
            }
            sub.add(g);
        }
        UniversalPrinter out = res.getUniversalWriter();
        if (context != null) {
            out.startObject("project");
            out.fields(context, false, false);
        } else {
            out.startObject("projects");
            if (!server) {
                out.field("for", m.getUsername());
            }
        }
        out.startCollection("groups", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Group g : top_level) {
            if (GroupRule.isProject((Group)g)) {
                ListProjectsAsTree.print(out, g, (List)projects.get(g.getName()), projects, subgroups);
                continue;
            }
            out.startObject("group");
            out.fields(g, false, false);
            String sg = (String)subgroups.get(g);
            if (sg != null) {
                out.field("subgroups", sg);
            }
            out.endObject();
        }
        out.endCollection();
        out.endObject();
        out.flush();
    }

    private static void print(UniversalPrinter out, Group project, List<Group> groups, Map<String, List<Group>> projects, Map<Group, String> subgroups) {
        out.startObject("project");
        out.fields(project, false, false);
        out.startCollection("groups", OutputPrinter.CollectionOption.JSON_ONLY);
        for (Group g : groups) {
            if (GroupRule.isProject((Group)g)) {
                ListProjectsAsTree.print(out, g, projects.get(g.getName()), projects, subgroups);
                continue;
            }
            out.startObject("group");
            out.fields(g, false, false);
            String sg = subgroups.get(g);
            if (sg != null) {
                out.field("subgroups", sg);
            }
            out.endObject();
        }
        out.endCollection();
        out.endObject();
    }

    private static boolean isGroupVisible(Group group, String nameprefix, boolean archived) {
        return !"admin".equals(group.getName()) && !"public".equals(group.getName()) && archived == GroupRule.isArchived((Group)group) && (nameprefix == null || group.getName().startsWith(nameprefix));
    }

    private static String getParentName(Group group) {
        if (group == null) {
            return null;
        }
        String name = group.getName();
        int dash = name.lastIndexOf(45);
        return dash != -1 ? name.substring(0, dash) : NO_PROJECT;
    }

    private static void addMissingParents(String name, Map<String, Group> groups, Set<String> parents) {
        String parent;
        int dash = name.lastIndexOf(45);
        if (dash != -1 && !groups.containsKey(parent = name.substring(0, dash))) {
            parents.add(parent);
            ListProjectsAsTree.addMissingParents(parent, groups, parents);
        }
    }
}

