/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.generator.ErrorID;

public enum GroupErrorID implements ErrorID
{
    ILLEGAL_GROUPNAME(4353, "Illegal character in group name."),
    FOLDER_EXISTS(4354, "Folder already exists on file system."),
    GROUPNAME_EXISTS(4355, "Group name already in use."),
    DEFAULT_GROUPURI_EXISTS(4356, "Default group URI already in use."),
    PARENT_GROUPURI(4357, "There is a parent Group URI."),
    PROJECT_MISSING(4358, "Parent project missing."),
    FAILED_DELETE_GROUPURI(4359, "Failed to delete a group URI."),
    INVALID_GROUP_PARAMETER(4360, "Invalid group parameter."),
    INVALID_NOTIFICATION_PARAMETER(4361, "Invalid notification parameter."),
    INVALID_ROLE_PARAMETER(4362, "Invalid role parameter."),
    INVALID_SUBGROUP_PARAMETER(4363, "Invalid subgroup parameter."),
    INVALID_GROUP_SETTING_PARAMETER(4364, "One of the group setting parameters is invalid."),
    SUBGROUP_ALREADY_EXISTS(4365, "The subgroup already exists."),
    INVALID_NAMEPREFIX_PARAMETER(4366, "Invalid nameprefix parameter for this project."),
    GROUP_TO_PROJECT(4367, "Cannot change a group to a project or a project to a group."),
    CONFIG_FOLDER_EXISTS(4368, "Config folder already exists on file system."),
    GROUP_ARCHIVED(4369, "Group is archived.");

    private final int _id;
    private final String _message;

    private GroupErrorID(int id, String message) {
        if (id < 0) {
            throw new IndexOutOfBoundsException("Error ID must be >= 0");
        }
        this._id = id;
        this._message = message;
    }

    public int id() {
        return this._id;
    }

    public String message() {
        return this._message;
    }
}

