/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.EditGroupCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.permission.ViewMemberCheck;
import com.pageseeder.base.rule.MemberDetailsConfig;
import com.pageseeder.base.rule.MemberGroupDetailsRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.MemberForGroup;
import com.pageseeder.db.model.MemberGroupDetails;
import com.pageseeder.group.GroupErrorID;
import com.pageseeder.group.Groups;
import com.pageseeder.member.MemberErrorID;
import com.pageseeder.member.Members;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(database=true, member=true)
@Output(types={OutputType.XML, OutputType.JSON})
public final class GetGroupMemberDetails
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetGroupMemberDetails.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) {
        try {
            if ("manager".equals(req.getParameter((Parameter)StandardParameters.role)) || req.getParameter((Parameter)StandardParameters.member) != null) {
                return new EditGroupCheck(Groups.getGroup(req));
            }
            return new ViewMemberCheck(Members.getMember(req));
        }
        catch (DatabaseException ex) {
            return new NoCheck();
        }
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        MemberDetailsConfig config;
        Member member;
        Group group;
        try {
            group = Groups.getGroup(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load group from DB");
            return;
        }
        if (group == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_PARAMETER);
            return;
        }
        try {
            member = Members.getMember(req);
        }
        catch (DatabaseException ex) {
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load member from DB");
            return;
        }
        if (member == null) {
            res.setError(GeneratorStatus.NOT_FOUND, (ErrorID)MemberErrorID.MEMBER_NOT_FOUND);
            return;
        }
        try {
            config = MemberGroupDetailsRule.getMemberDetailsConfig((Group)group);
        }
        catch (FoundationException ex) {
            LOGGER.error("Failed to load group details config from DB", (Throwable)ex);
            res.setError(GeneratorStatus.SERVER_ERROR, "Failed to load config from DB: " + ex.getMessage());
            return;
        }
        MemberGroupDetails details = null;
        if (config != null) {
            boolean shared = config.isShared();
            if (shared) {
                details = DatabaseQuery.getMemberGroupDetailsByMemberIdOwnerForm((Database)req.getDatabase(), (Long)member.getId(), (String)group.getOwner(), (String)group.getDetailsForm());
            } else {
                MemberForGroup membership = null;
                for (MemberForGroup mfg : member.getGroupsForMemberCol()) {
                    if (!mfg.getGroup().getId().equals(group.getId())) continue;
                    membership = mfg;
                    break;
                }
                if (membership != null) {
                    details = membership.getMemberGroupDetails();
                }
            }
        }
        MemberDetailsConfig.Visibility visibility = "manager".equals(req.getParameter((Parameter)StandardParameters.role)) ? MemberDetailsConfig.Visibility.MANAGER : MemberDetailsConfig.Visibility.MEMBER;
        UniversalPrinter out = res.getUniversalWriter();
        out.writeMembershipDetails(config, details, visibility);
        out.flush();
    }
}

