/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.group;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.changes.ChangesBatch;
import com.pageseeder.base.changes.ChangesManager;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.generator.ErrorID;
import com.pageseeder.base.generator.Generator;
import com.pageseeder.base.generator.GeneratorRequest;
import com.pageseeder.base.generator.GeneratorResponse;
import com.pageseeder.base.generator.GeneratorStatus;
import com.pageseeder.base.generator.Output;
import com.pageseeder.base.generator.Parameter;
import com.pageseeder.base.generator.Requires;
import com.pageseeder.base.generator.SingleCheck;
import com.pageseeder.base.permission.CreateGroupCheck;
import com.pageseeder.base.permission.CreateProjectCheck;
import com.pageseeder.base.permission.NoCheck;
import com.pageseeder.base.permission.PermissionCheck;
import com.pageseeder.base.rule.GroupMediator;
import com.pageseeder.base.rule.GroupRule;
import com.pageseeder.base.rule.GroupURIRule;
import com.pageseeder.base.rule.InternalURIFetcher;
import com.pageseeder.base.rule.MemberRule;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputType;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.web.StandardParameters;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.base.web.UserDetailsManager;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.GroupURI;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.URI;
import com.pageseeder.group.GroupErrorID;
import com.pageseeder.psml.Structure;
import com.pageseeder.xref.XRefException;
import com.pageseeder.xref.XRefMediator;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(member=true, parameters={"shortname", "description"})
@Output(types={OutputType.XML, OutputType.JSON})
public final class CreateGroup
implements Generator,
SingleCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateGroup.class);

    public PermissionCheck getPermissionCheck(GeneratorRequest req) throws DatabaseException {
        boolean project = req.getParameter((Parameter)StandardParameters.project, false);
        String projectname = req.getParameter((Parameter)StandardParameters.projectname);
        Object check = project ? new CreateProjectCheck(req.getHttpServletRequest()) : (projectname != null ? new CreateGroupCheck(DatabaseQuery.getGroupByName((Database)req.getDatabase(), (String)projectname)) : new NoCheck());
        return check;
    }

    public void process(GeneratorRequest req, GeneratorResponse res) throws DatabaseException, IOException {
        Group group;
        String projectname = req.getParameter((Parameter)StandardParameters.projectname);
        String shortname = req.getParameter((Parameter)StandardParameters.shortname);
        String description = req.getParameter((Parameter)StandardParameters.description);
        String title = req.getParameter((Parameter)StandardParameters.title);
        boolean project = req.getParameter((Parameter)StandardParameters.project, false);
        boolean addmember = req.getParameter((Parameter)StandardParameters.addmember, true);
        boolean createdocuments = req.getParameter((Parameter)StandardParameters.createdocuments, true);
        String owner = req.getParameter((Parameter)StandardParameters.owner);
        String visibility = req.getParameter((Parameter)StandardParameters.visibility);
        String template = req.getParameter((Parameter)StandardParameters.template);
        String detailstype = req.getParameter((Parameter)StandardParameters.detailstype);
        String relatedurl = req.getParameter((Parameter)StandardParameters.relatedurl);
        String hosturl = req.getParameter((Parameter)StandardParameters.hosturl);
        String host = req.getParameter((Parameter)StandardParameters.host);
        String message = req.getParameter((Parameter)StandardParameters.message);
        String access = req.getParameter((Parameter)StandardParameters.access, "member");
        String commenting = req.getParameter((Parameter)StandardParameters.commenting, "reviewer");
        String moderation = req.getParameter((Parameter)StandardParameters.moderation, "reviewer");
        String registration = req.getParameter((Parameter)StandardParameters.registration, "normal");
        String defaultrole = req.getParameter((Parameter)StandardParameters.defaultrole, project ? "contributor" : "reviewer");
        String defaultnotify = req.getParameter((Parameter)StandardParameters.defaultnotify, "immediate");
        boolean common = req.getParameter((Parameter)StandardParameters.common, false);
        boolean editurls = req.getParameter((Parameter)StandardParameters.editurls, false);
        if (host == null && hosturl != null) {
            try {
                host = new URL(hosturl).getHost();
            }
            catch (MalformedURLException e) {
                res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_SETTING_PARAMETER, "The hosturl is not a valid URL.");
                return;
            }
        }
        if (!project && projectname == null) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_SETTING_PARAMETER, "The projectname must be specified if creating a group");
            return;
        }
        Database db = req.getDatabase();
        Member mem = req.getAuthenticatedMember();
        UserDetails userdetails = new UserDetailsManager().get(db, mem.getId());
        boolean admin = MemberRule.isAdministrator((Map)userdetails.flags());
        boolean projectManager = projectname == null ? false : MemberRule.isProjectManager((String)projectname, (Map)userdetails.flags());
        try {
            GroupMediator mediator = new GroupMediator(db, projectname, shortname, description, host, addmember ? req.getMember() : null);
            mediator.setProject(project);
            mediator.setTitle(title);
            mediator.setOwner(owner);
            mediator.setVisibility(visibility);
            mediator.setTemplate(template);
            mediator.setDetailstype(detailstype);
            mediator.setRelatedurl(relatedurl);
            mediator.setMessage(message);
            mediator.setAccess(access);
            mediator.setCommenting(commenting);
            mediator.setModeration(moderation);
            mediator.setRegistration(registration);
            mediator.setDefaultrole(defaultrole);
            mediator.setDefaultnotify(defaultnotify);
            mediator.setCommon(Boolean.valueOf(common));
            mediator.setEditURLs(Boolean.valueOf(editurls));
            Set pnames = req.getParameters().keySet();
            for (String pname : pnames) {
                if (!pname.startsWith("property.")) continue;
                String propName = pname.substring(9);
                String propValue = req.getParameter(pname);
                mediator.setProperty(propName, propValue);
            }
            group = mediator.create(admin, projectManager);
        }
        catch (FoundationException ex) {
            res.setError(GeneratorStatus.BAD_REQUEST, (ErrorID)GroupErrorID.INVALID_GROUP_SETTING_PARAMETER, ex.getMessage());
            return;
        }
        Collection uris = new ArrayList();
        GroupURI guri = GroupURIRule.getDefaultGroupURI((Group)group);
        if (guri != null && !project) {
            uris = GroupURIRule.checkForFolderURIs((GroupURI)guri, (Member)mem, (Database)db);
        }
        if (!project && createdocuments) {
            Collection created = null;
            try {
                created = GroupRule.createDefaultDocuments((Group)group, (Member)req.getMember(), (Database)db);
            }
            catch (FoundationException ex) {
                LOGGER.error("Failed to create default documents: {}", (Throwable)ex);
            }
            if (created != null) {
                for (Object uri : created) {
                    if (!URIRule.isPSML((URI)uri)) continue;
                    XRefMediator mediator = new XRefMediator(group, (URI)uri, req.getMember(), uri.getDateCreated(), db);
                    mediator.setCreateEdit(true);
                    mediator.setFailOnFirstError(false);
                    mediator.setBuildStructure(true);
                    try (InternalURIFetcher fetcher = new InternalURIFetcher((URI)uri, null);){
                        mediator.mediateNewDocument(fetcher.getContent());
                    }
                    catch (URIException ex) {
                        LOGGER.error("Unable to fetch document", (Throwable)ex);
                    }
                    catch (XRefException ex) {
                        LOGGER.error("Unable to resolve xrefs", (Throwable)ex);
                    }
                    try {
                        Structure.createStructureXLink(mediator.getStructureXML(), (URI)uri, group, req.getMember(), uri.getDateCreated(), "Document Create", db);
                    }
                    catch (DatabaseException ex) {
                        LOGGER.error("Failed to create structure in DB", (Throwable)ex);
                    }
                }
                uris.addAll(created);
            }
        }
        req.getTransaction().commitAndStart();
        ChangesManager changes = ChangesManager.getInstance();
        ChangesBatch batch = new ChangesBatch("Create " + (project ? "project " : "group ") + group.getName());
        changes.startBatch(db, batch);
        if (project) {
            changes.createProject(db, batch, group);
        } else {
            changes.createGroup(db, batch, group);
        }
        if (uris != null && !uris.isEmpty()) {
            for (URI uri : uris) {
                changes.createURI(db, batch, uri, DatabaseQuery.getGroupsByURIIdCol((Database)db, (Long)uri.getId()));
            }
        }
        if (addmember) {
            changes.createMembership(db, batch, DatabaseQuery.getMemberForGroupByGroupIdMemberId((Database)db, (Long)group.getId(), (Long)req.getMember().getId()));
            UserDetailsManager user_manager = new UserDetailsManager();
            user_manager.remove(req.getMember().getId());
        }
        changes.completeBatch(db, batch);
        UniversalPrinter out = res.getUniversalWriter();
        out.startObject(project ? "project-creation" : "group-creation");
        out.writeGroup(group, true, true, false, false);
        out.endObject();
        out.flush();
    }
}

