/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.export;

import java.util.ArrayList;
import java.util.List;

public final class URIPathPatternFilter {
    private final List<String> excludePatterns = new ArrayList<String>();
    private final List<String> includePatterns = new ArrayList<String>();
    private final String rootPath;

    public URIPathPatternFilter(String rootpath) {
        this.rootPath = rootpath;
    }

    public void addExcludePatterns(String[] patterns) {
        if (patterns == null) {
            return;
        }
        for (String exc : patterns) {
            if (exc.length() <= 0) continue;
            this.excludePatterns.add(this.createRegex(exc));
            if (exc.indexOf(42) != -1) continue;
            this.excludePatterns.add(this.createRegex(exc + "/**"));
        }
    }

    public boolean isExcluded(String path) {
        if (path == null) {
            return false;
        }
        for (String exc : this.excludePatterns) {
            if (!path.matches(exc)) continue;
            return true;
        }
        return false;
    }

    public boolean isIncluded(String path) {
        if (path == null) {
            return false;
        }
        if (this.includePatterns.isEmpty()) {
            return true;
        }
        for (String inc : this.includePatterns) {
            if (!path.matches(inc)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPatterns() {
        return !this.includePatterns.isEmpty() || !this.excludePatterns.isEmpty();
    }

    public void addIncludePatterns(String[] patterns) {
        if (patterns == null) {
            return;
        }
        for (String inc : patterns) {
            if (inc.length() <= 0) continue;
            this.includePatterns.add(this.createRegex(inc));
            if (inc.indexOf(42) != -1) continue;
            this.excludePatterns.add(this.createRegex(inc + "/**"));
        }
    }

    private String createRegex(String pattern) {
        return "^" + (this.rootPath + "/" + pattern).replaceAll("[.()\\[\\]^$+]", "\\\\$0").replaceAll("\\?", ".").replaceAll("\\*\\*", "[psdoublestar]").replaceAll("\\*", "([^/]*?)").replaceAll("\\[psdoublestar]", "(.*?)") + "$";
    }
}

