/*
 * Decompiled with CFR 0.152.
 */
package com.pageseeder.export;

import com.pageseeder.base.FoundationException;
import com.pageseeder.base.document.DocumentContentResolver;
import com.pageseeder.base.document.PSMLCompareHandler;
import com.pageseeder.base.document.URIException;
import com.pageseeder.base.permission.Permissions;
import com.pageseeder.base.publication.ContentAdjustor;
import com.pageseeder.base.publication.NumberedTOC;
import com.pageseeder.base.rule.URIRule;
import com.pageseeder.base.serial.OutputPrinter;
import com.pageseeder.base.serial.UniversalPrinter;
import com.pageseeder.base.serial.XMLOutputPrinter;
import com.pageseeder.base.thread.ProcessStage;
import com.pageseeder.base.thread.ProcessThread;
import com.pageseeder.base.util.XMLHelpers;
import com.pageseeder.base.web.UserDetails;
import com.pageseeder.common.util.Strings;
import com.pageseeder.db.CommitTransactionException;
import com.pageseeder.db.Database;
import com.pageseeder.db.DatabaseException;
import com.pageseeder.db.DatabaseQuery;
import com.pageseeder.db.OpenDatabaseException;
import com.pageseeder.db.QueryFailedException;
import com.pageseeder.db.StartTransactionException;
import com.pageseeder.db.Transaction;
import com.pageseeder.db.model.Group;
import com.pageseeder.db.model.Host;
import com.pageseeder.db.model.Member;
import com.pageseeder.db.model.Publication;
import com.pageseeder.db.model.URI;
import com.pageseeder.db.util.URIs;
import com.pageseeder.export.ExportException;
import com.pageseeder.export.URIExportProcessor;
import com.pageseeder.export.URIToProcess;
import com.pageseeder.utils.MemberTempFiles;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.Nullable;
import org.pageseeder.psml.toc.PublicationConfig;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;

public final class ExportThread
extends ProcessThread {
    private boolean metadataOnly = false;
    private boolean binaryMetadataOnly = false;
    private boolean failOnError = true;
    private boolean allUrls = false;
    private boolean interpublicationXrefs = false;
    private int independent = 0;
    private String publicationid = null;
    private int position = 1;
    private boolean processPublication = false;
    private String release = null;
    private String compare = null;
    private final String context;
    private String zipName = null;
    private final List<ToExport> toExport = new ArrayList<ToExport>();
    private URIExportProcessor processor;
    private final UserDetails userDetails;
    private int currentProcessing = -1;
    private int totalProcessing = -1;
    private int currentPackaging = -1;
    private int totalPackaging = -1;

    public ExportThread(String username, Group group, String ctxt, UserDetails details) {
        super(username, "Export within group " + (group == null ? "unknown" : group.getName()), group);
        this.context = ctxt;
        this.processor = new URIExportProcessor(this, ctxt);
        this.userDetails = details;
    }

    public void setXRefFilter(int forwarddepth, int reversedepth, String[] types) {
        this.processor.setXRefDepths(forwarddepth, reversedepth);
        if (types != null && types.length > 0) {
            this.processor.addTypes(Arrays.asList(types));
        }
    }

    public void setRelease(String value) {
        this.release = value;
        this.processor.setRelease(value);
    }

    public void setLoadDetails(boolean images, boolean alternate) {
        this.processor.setLoadDetails(images, alternate);
    }

    public void setCompare(String value) {
        this.compare = value;
        this.processor.setCompare(value);
    }

    public void setPublication(String id, boolean process, int pos) {
        this.publicationid = id;
        this.processor.setPublicationID(id);
        this.processPublication = process;
        this.position = pos;
    }

    public void setFailOnError(boolean fail) {
        this.failOnError = fail;
    }

    public void setAllUrls(boolean allurls) {
        this.allUrls = allurls;
    }

    public void setInterpublicationXrefs(boolean resolve) {
        this.interpublicationXrefs = resolve;
    }

    public void setIndependent(int ind) {
        this.independent = ind;
    }

    public void setMetadataOnly(boolean metadataonly, boolean binaryMetadataonly) {
        this.metadataOnly = metadataonly;
        this.binaryMetadataOnly = binaryMetadataonly;
    }

    public void addURIToExport(String scheme, String host, int port, String path) {
        this.toExport.add(new ToExport(scheme, host, port, path));
    }

    public void addURIToExport(Long id) {
        this.toExport.add(new ToExport(id));
    }

    public void writeThreadElements(OutputPrinter out) {
        if (this.totalProcessing > 0) {
            out.startObject("processing");
            out.field("current", (long)this.currentProcessing);
            out.field("total", (long)this.totalProcessing);
            out.endObject();
        }
        if (this.totalPackaging > 0) {
            out.startObject("packaging");
            out.field("current", (long)this.currentPackaging);
            out.field("total", (long)this.totalPackaging);
            out.endObject();
        }
        if (this.zipName != null) {
            out.field("zip", this.zipName, OutputPrinter.FieldOption.XML_ELEMENT);
        }
    }

    public void process() {
        this.export(null, null, -1);
    }

    public boolean processURIs(Database database, Transaction transaction, int max) {
        this.updateStatus(ProcessStage.Status.INITIALISED, "Computing objects to export");
        if (!this.export(database, transaction, max)) {
            return false;
        }
        return this.processor.getURIs().size() > max;
    }

    public boolean run(Database database, Transaction transaction) {
        return this.export(database, transaction, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean export(Database database, Transaction transaction, int maxURIs) {
        Transaction tr = transaction;
        Database db = database;
        boolean newTransaction = false;
        if (db == null && tr == null) {
            try {
                db = Database.open();
                tr = new Transaction(db);
                newTransaction = true;
            }
            catch (OpenDatabaseException e) {
                this.fail("Failed to open database");
                this.complete("Failed to open database");
                return false;
            }
        }
        boolean complete = maxURIs <= 0;
        try {
            Member author;
            if (newTransaction) {
                tr.begin();
            }
            if ((author = DatabaseQuery.getMemberByUsername((Database)db, (String)this.getUsername())) == null) {
                this.fail("Failed to load author " + this.getUsername());
                complete = true;
                boolean bl = false;
                return bl;
            }
            Group group = (Group)db.getPersistenceManager().detachCopy((Object)DatabaseQuery.getGroupByName((Database)db, (String)this.getGroup()));
            if (this.allUrls) {
                Collection urlids = DatabaseQuery.getExternalURIsUsedOrCommentsInGroupByType((Database)db, (Long)group.getId(), null);
                for (Long l : urlids) {
                    this.toExport.add(new ToExport(l));
                }
            }
            if (maxURIs > 0) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, (String)(this.toExport.size() == 1 ? "Found 1 document/URL/folder in src" : "Found " + this.toExport.size() + " documents/URLs/folders in src"));
            }
            this.processor.setPermissions(db, group, new Permissions(), author.getId(), this.userDetails);
            this.totalProcessing = this.toExport.size();
            this.currentProcessing = 0;
            Publication publication = null;
            for (ToExport toExport : this.toExport) {
                URI uri;
                block67: {
                    if (++this.currentProcessing % 2000 == 0) {
                        this.updateStatus(ProcessStage.Status.INPROGRESS, "Restarting DB Persistence Manager!");
                        db.restartPersistenceManager();
                    }
                    uri = toExport.resolve(db);
                    if (this.wasCancelled() || this.hasError()) {
                        if (!this.hasError()) break;
                        this.fail("Failed due to error");
                        break;
                    }
                    if (uri == null) continue;
                    if (this.processPublication && !Strings.isEmpty((String)this.publicationid) && publication == null && (publication = DatabaseQuery.getPublicationByPublicationIDHost((Database)db, (String)this.publicationid, (Host)uri.getHost())) == null) {
                        this.publicationid = null;
                    }
                    if (URIs.isExternal((URI)uri)) {
                        this.updateStatus(ProcessStage.Status.INPROGRESS, "Adding URL " + uri.getDecodedPath());
                    } else if (!URIRule.isFolder((URI)uri)) {
                        this.updateStatus(ProcessStage.Status.INPROGRESS, "Adding document " + uri.getDecodedPath());
                    }
                    this.processor.process(uri, maxURIs);
                    if (this.wasCancelled() || this.hasError()) break;
                    List<String> image_errors = this.processor.getResolveImageErrors();
                    if (image_errors.size() > 0 && this.failOnError) {
                        if (image_errors.size() == 1) {
                            this.fail(image_errors.get(0));
                        } else {
                            for (String error : image_errors) {
                                this.error(error, null);
                            }
                            this.fail("Failed due to error resolving images: found " + image_errors.size() + " invalid images");
                        }
                        if (newTransaction) {
                            tr.abort();
                        }
                        complete = true;
                        boolean bl = false;
                        return bl;
                    }
                    if (maxURIs <= 0 || this.processor.getURIs().size() <= maxURIs) break block67;
                    complete = false;
                    boolean bl = true;
                    return bl;
                }
                try {
                    complete = true;
                }
                catch (DatabaseException e) {
                    this.error("Database error when processing URI " + uri.getPath(), (Exception)((Object)e));
                }
                catch (URIException e) {
                    this.error("Failed to process URI " + uri.getPath(), (Exception)((Object)e));
                }
                catch (ExportException e) {
                    this.error("You don't have access to document " + e.getURIPath() + " (URIID " + e.getURIID() + ")", e);
                }
            }
            if (this.wasCancelled() || this.hasError()) {
                if (this.wasCancelled()) {
                    this.fail("Export was cancelled");
                }
                if (newTransaction) {
                    tr.abort();
                }
                complete = true;
                boolean bl = false;
                return bl;
            }
            this.totalProcessing = -1;
            this.currentProcessing = -1;
            List<String> image_errors = this.processor.getResolveImageErrors();
            if (image_errors.size() > 0) {
                for (String error : image_errors) {
                    this.error(error, null);
                }
            }
            File file = MemberTempFiles.getTempFolder(author, group);
            String exportID = "export-" + System.nanoTime();
            File zip = new File(file, exportID + ".zip");
            try {
                if (!zip.createNewFile()) {
                    this.fail("Failed to create destination ZIP file");
                    if (newTransaction) {
                        tr.abort();
                    }
                    complete = true;
                    boolean bl = false;
                    return bl;
                }
            }
            catch (IOException e) {
                this.fail("Failed to create destination ZIP file: " + e.getMessage());
                if (newTransaction) {
                    tr.abort();
                }
                complete = true;
                boolean bl = false;
                return bl;
            }
            if (this.wasCancelled() || this.hasError()) {
                if (this.wasCancelled()) {
                    this.fail("Export was cancelled");
                }
                if (newTransaction) {
                    tr.abort();
                }
                complete = true;
                boolean e = false;
                return e;
            }
            int size = this.zipContents(zip, group, db, publication);
            if (size >= 0) {
                this.updateStatus(ProcessStage.Status.INPROGRESS, "Added " + size + " document" + (size == 1 ? "" : "s") + "/URL" + (size == 1 ? "" : "s") + " to ZIP");
                this.zipName = zip.getName();
                if (newTransaction) {
                    tr.commit();
                }
                complete = true;
                boolean bl = true;
                return bl;
            }
            if (this.getFailMessage() == null) {
                this.fail("Failed to create export ZIP file");
            }
            zip.delete();
            if (newTransaction) {
                tr.abort();
            }
            complete = true;
            boolean bl = false;
            return bl;
        }
        catch (StartTransactionException e) {
            this.fail("Failed to start transaction");
            if (newTransaction) {
                tr.abort();
            }
            complete = true;
            boolean bl = false;
            return bl;
        }
        catch (QueryFailedException e) {
            this.fail("Failed to run database query: " + e.getMessage());
            if (newTransaction) {
                tr.abort();
            }
            complete = true;
            boolean bl = false;
            return bl;
        }
        catch (CommitTransactionException e) {
            this.fail("Failed to commit transaction");
            if (newTransaction) {
                tr.abort();
            }
            complete = true;
            boolean bl = false;
            return bl;
        }
        catch (Exception ex) {
            LoggerFactory.getLogger(ExportThread.class).error("Export failed due to exception", (Throwable)ex);
            this.fail("Failed due to exception " + ex.getClass().getName() + ": " + ex.getMessage());
            if (newTransaction) {
                tr.abort();
            }
            complete = true;
            boolean bl = false;
            return bl;
        }
        finally {
            if (newTransaction) {
                db.close();
                db = null;
            }
            if (complete) {
                this.complete("Export successful!");
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int zipContents(File zipFile, Group group, Database db, @Nullable Publication publication) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean addMetadata(URIToProcess utp, URI uri, String groupName, String uriFolder, String groupContext, String zipPath, ZipOutputStream zip, Database db) throws IOException, URIException {
        DocumentContentResolver psmlResolver = new DocumentContentResolver(uri.getId(), groupName);
        psmlResolver.setPSMLFormat(true);
        if (utp.hasRelease()) {
            psmlResolver.setReleaseId(utp.getReleaseID());
        }
        if (utp.hasCompare()) {
            psmlResolver.setCompareId(utp.getCompareID(), PSMLCompareHandler.DiffType.NONE);
        }
        ZipEntry entry = new ZipEntry(zipPath);
        entry.setMethod(8);
        zip.putNextEntry(entry);
        return this.adjustContent(psmlResolver.getContent(db), zip, uriFolder, groupContext, uri, db, this.userDetails, null, null, null, false);
    }

    public boolean adjustContent(InputStream in, OutputStream out, String uriFolder, String groupCtxt, URI uri, Database db, UserDetails userDetails, @Nullable NumberedTOC publicationToc, @Nullable PublicationConfig publicationConfig, @Nullable Map<String, String> publicationMetadata, boolean interpublication) throws IOException {
        block2: {
            ContentAdjustor handler = new ContentAdjustor((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8), publicationToc, publicationConfig, uri.getId().longValue(), this.publicationid, this.position, true, false, userDetails, db);
            handler.setRelativePaths(uriFolder, this.context, groupCtxt);
            handler.setInterpublicationXrefs(interpublication);
            handler.setPublicationMetadata(publicationMetadata);
            handler.setIndependent(this.independent);
            handler.writeXMLDeclaration();
            try {
                XMLHelpers.parse((InputStream)in, (ContentHandler)handler);
            }
            catch (FoundationException ex) {
                this.error("Failed to parse PSML", (Exception)((Object)ex));
                if (!this.failOnError) break block2;
                return false;
            }
        }
        return true;
    }

    private void error(String message, Exception ex) {
        String msg = message + (String)(ex == null || ex.getMessage() == null ? "" : ": " + ex.getMessage());
        if (this.failOnError) {
            this.updateStatus(ProcessStage.Status.ERROR, msg);
            this.fail(msg);
        } else {
            this.updateStatus(ProcessStage.Status.WARNING, msg);
        }
    }

    private class ToExport {
        private final long uriID;
        private final String uriPath;
        private final int uriPort;
        private final String uriScheme;
        private final String uriHost;

        ToExport(Long u) {
            this.uriID = u;
            this.uriPath = null;
            this.uriHost = null;
            this.uriPort = -1;
            this.uriScheme = null;
        }

        ToExport(String s, String h, int po, String pa) {
            this.uriID = -1L;
            this.uriHost = h;
            this.uriPort = po;
            this.uriScheme = s;
            this.uriPath = pa;
        }

        public URI resolve(Database db) {
            URI uri = null;
            if (this.uriID > 0L) {
                try {
                    uri = DatabaseQuery.getURIById((Database)db, (Long)this.uriID);
                    if (uri == null) {
                        ExportThread.this.error("Failed to load URI with ID " + this.uriID, null);
                    }
                    return uri;
                }
                catch (QueryFailedException e) {
                    ExportThread.this.error("Failed to load URI with ID " + this.uriID, (Exception)((Object)e));
                }
            } else {
                try {
                    uri = DatabaseQuery.getURIBySchemeHostPortPath((Database)db, (String)this.uriScheme, (String)this.uriHost, (Integer)this.uriPort, (String)this.uriPath);
                    if (uri == null) {
                        ExportThread.this.error("Failed to load URI with scheme " + this.uriScheme + ", host " + this.uriHost + ", port " + this.uriPort + " and path " + this.uriPath, null);
                    }
                }
                catch (QueryFailedException e) {
                    ExportThread.this.error("Failed to load URI with scheme " + this.uriScheme + ", host " + this.uriHost + ", port " + this.uriPort + " and path " + this.uriPath, (Exception)((Object)e));
                }
            }
            return uri;
        }
    }

    private class Manifest
    implements Closeable {
        private final File file;
        private final FileOutputStream stream;
        private final UniversalPrinter writer;

        public Manifest() {
            FileOutputStream fos;
            File f;
            try {
                f = File.createTempFile("export-manifest", ".xml");
                fos = new FileOutputStream(f);
            }
            catch (IOException ex) {
                f = null;
                fos = null;
            }
            if (f != null) {
                this.file = f;
                this.stream = fos;
                this.writer = new UniversalPrinter((OutputPrinter)new XMLOutputPrinter((Writer)new OutputStreamWriter((OutputStream)this.stream, StandardCharsets.UTF_8)));
                this.writer.startObject("uris");
            } else {
                this.file = null;
                this.stream = null;
                this.writer = null;
            }
        }

        public void addURI(URI uri) {
            if (this.writer != null) {
                this.writer.writeURI(uri, true, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToZip(ZipOutputStream zip) throws IOException {
            if (this.file != null) {
                ZipEntry entry = new ZipEntry("META-INF/manifest.xml");
                entry.setMethod(8);
                zip.putNextEntry(entry);
                FileInputStream fis = new FileInputStream(this.file);
                try {
                    IOUtils.copy((InputStream)fis, (OutputStream)zip);
                }
                finally {
                    fis.close();
                    this.file.delete();
                }
            }
        }

        @Override
        public void close() throws IOException {
            if (this.writer != null) {
                this.writer.endObject();
                this.writer.close();
                this.stream.close();
            }
        }
    }
}

